/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.firebase_auth.zzap;
import com.google.android.gms.internal.firebase_auth.zzgv;
import com.google.android.gms.internal.firebase_auth.zzha;
import com.google.android.gms.internal.firebase_auth.zzv;
import com.google.firebase.auth.api.internal.zzcg;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzao
extends AbstractSafeParcelable
implements zzcg<zzao, zzha.zza> {
    public static final Parcelable.Creator<zzao> CREATOR = new zzap();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzag;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzdt;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzjs;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zzjt;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzju;

    public zzao() {
        this.zzju = System.currentTimeMillis();
    }

    public zzao(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzao(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzag = string;
        this.zzdt = string2;
        this.zzjs = l;
        this.zzjt = string3;
        this.zzju = l2;
    }

    public final boolean isValid() {
        long l = this.zzju + this.zzjs * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }

    public final void zzr(@NonNull String string) {
        this.zzag = Preconditions.checkNotEmpty((String)string);
    }

    public final String zzan() {
        return this.zzag;
    }

    public final String zzau() {
        return this.zzdt;
    }

    public final long zzao() {
        if (this.zzjs == null) {
            return 0L;
        }
        return this.zzjs;
    }

    @Nullable
    public final String zzav() {
        return this.zzjt;
    }

    public final long zzaw() {
        return this.zzju;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzao zzao2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzao2.zzag, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzao2.zzdt, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)4, (Long)zzao2.zzao(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzao2.zzjt, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)zzao2.zzju, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final Class<zzha.zza> zzae() {
        return zzha.zza.class;
    }

    public final String toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)this.zzag);
            jSONObject.put("access_token", (Object)this.zzdt);
            jSONObject.put("expires_in", (Object)this.zzjs);
            jSONObject.put("token_type", (Object)this.zzjt);
            jSONObject.put("issued_at", (Object)this.zzju);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to convert GetTokenResponse to JSON");
            throw new zzv(jSONException);
        }
    }

    public static zzao zzs(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzao zzao2 = new zzao();
            new zzao().zzag = jSONObject.optString("refresh_token", null);
            zzao2.zzdt = jSONObject.optString("access_token", null);
            zzao2.zzjs = jSONObject.optLong("expires_in");
            zzao2.zzjt = jSONObject.optString("token_type", null);
            zzao2.zzju = jSONObject.optLong("issued_at");
            return zzao2;
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zzv(jSONException);
        }
    }

    @Override
    public final /* synthetic */ zzcg zza(zzgv zzgv2) {
        zzha.zza zza2 = (zzha.zza)zzgv2;
        zzao zzao2 = this;
        this.zzag = Strings.emptyToNull((String)zza2.zzag);
        zzao2.zzdt = Strings.emptyToNull((String)zza2.zzdt);
        zzao2.zzjs = zza2.zzah;
        zzao2.zzjt = Strings.emptyToNull((String)zza2.zzjt);
        zzao2.zzju = System.currentTimeMillis();
        return zzao2;
    }
}

