/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.firebase_auth.zzaq;
import com.google.android.gms.internal.firebase_auth.zzgy;
import com.google.android.gms.internal.firebase_auth.zzhd;
import com.google.android.gms.internal.firebase_auth.zzw;
import com.google.firebase.auth.api.internal.zzch;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzap
extends AbstractSafeParcelable
implements zzch<zzap, zzhd.zza> {
    public static final Parcelable.Creator<zzap> CREATOR = new zzaq();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzam;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzdz;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzkb;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zzkc;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzkd;

    public zzap() {
        this.zzkd = System.currentTimeMillis();
    }

    public zzap(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzap(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzam = string;
        this.zzdz = string2;
        this.zzkb = l;
        this.zzkc = string3;
        this.zzkd = l2;
    }

    public final boolean isValid() {
        long l = this.zzkd + this.zzkb * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }

    public final void zzr(@NonNull String string) {
        this.zzam = Preconditions.checkNotEmpty((String)string);
    }

    public final String zzar() {
        return this.zzam;
    }

    public final String zzaz() {
        return this.zzdz;
    }

    public final long zzas() {
        if (this.zzkb == null) {
            return 0L;
        }
        return this.zzkb;
    }

    @Nullable
    public final String zzba() {
        return this.zzkc;
    }

    public final long zzbb() {
        return this.zzkd;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzap zzap2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzap2.zzam, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzap2.zzdz, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)4, (Long)zzap2.zzas(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzap2.zzkc, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)zzap2.zzkd, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final Class<zzhd.zza> zzai() {
        return zzhd.zza.class;
    }

    public final String toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)this.zzam);
            jSONObject.put("access_token", (Object)this.zzdz);
            jSONObject.put("expires_in", (Object)this.zzkb);
            jSONObject.put("token_type", (Object)this.zzkc);
            jSONObject.put("issued_at", (Object)this.zzkd);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to convert GetTokenResponse to JSON");
            throw new zzw(jSONException);
        }
    }

    public static zzap zzs(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzap zzap2 = new zzap();
            new zzap().zzam = jSONObject.optString("refresh_token", null);
            zzap2.zzdz = jSONObject.optString("access_token", null);
            zzap2.zzkb = jSONObject.optLong("expires_in");
            zzap2.zzkc = jSONObject.optString("token_type", null);
            zzap2.zzkd = jSONObject.optLong("issued_at");
            return zzap2;
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zzw(jSONException);
        }
    }

    @Override
    public final /* synthetic */ zzch zza(zzgy zzgy2) {
        zzhd.zza zza2 = (zzhd.zza)zzgy2;
        zzap zzap2 = this;
        this.zzam = Strings.emptyToNull((String)zza2.zzam);
        zzap2.zzdz = Strings.emptyToNull((String)zza2.zzdz);
        zzap2.zzkb = zza2.zzan;
        zzap2.zzkc = Strings.emptyToNull((String)zza2.zzkc);
        zzap2.zzkd = System.currentTimeMillis();
        return zzap2;
    }
}

