/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbr;
import com.google.android.gms.internal.firebase_auth.zzdg;
import com.google.android.gms.internal.firebase_auth.zzdj;
import com.google.android.gms.internal.firebase_auth.zzev;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbt
extends zzbr<Boolean>
implements zzdj<Boolean>,
zzev,
RandomAccess {
    private static final zzbt zzmk = new zzbt();
    private boolean[] zzml;
    private int size;

    zzbt() {
        this(new boolean[10], 0);
    }

    private zzbt(boolean[] blArray, int n) {
        this.zzml = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzml, n2, this.zzml, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbt)) {
            return super.equals(object);
        }
        zzbt zzbt2 = (zzbt)object;
        if (this.size != zzbt2.size) {
            return false;
        }
        boolean[] blArray = zzbt2.zzml;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzml[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdg.zzg(this.zzml[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzbw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzml.length) {
            System.arraycopy(this.zzml, n, this.zzml, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzml, 0, blArray, 0, n);
            System.arraycopy(this.zzml, n, blArray, n + 1, this.size - n);
            this.zzml = blArray;
        }
        this.zzml[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzbw();
        zzdg.checkNotNull(collection);
        if (!(collection instanceof zzbt)) {
            return super.addAll(collection);
        }
        zzbt zzbt2 = (zzbt)collection;
        if (zzbt2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbt2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbt2.size;
        if (n > this.zzml.length) {
            this.zzml = Arrays.copyOf(this.zzml, n);
        }
        System.arraycopy(zzbt2.zzml, 0, this.zzml, this.size, zzbt2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzml[i])) continue;
            System.arraycopy(this.zzml, i + 1, this.zzml, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzbt zzbt2 = this;
        zzbt2.zzbw();
        zzbt2.zzh(n);
        boolean bl3 = zzbt2.zzml[n];
        zzbt2.zzml[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbt zzbt2 = this;
        zzbt2.zzbw();
        zzbt2.zzh(n);
        boolean bl = zzbt2.zzml[n];
        if (n < zzbt2.size - 1) {
            System.arraycopy(zzbt2.zzml, n + 1, zzbt2.zzml, n, zzbt2.size - n);
        }
        --zzbt2.size;
        ++zzbt2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzdj zzj(int n) {
        int n2 = n;
        zzbt zzbt2 = this;
        if (n2 < zzbt2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbt(Arrays.copyOf(zzbt2.zzml, n2), zzbt2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbt zzbt2 = this;
        zzbt2.zzh(n);
        return zzbt2.zzml[n];
    }

    static {
        zzmk.zzbv();
    }
}

