/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbr;
import com.google.android.gms.internal.firebase_auth.zzdg;
import com.google.android.gms.internal.firebase_auth.zzdj;
import com.google.android.gms.internal.firebase_auth.zzev;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdf
extends zzbr<Integer>
implements zzdj<Integer>,
zzev,
RandomAccess {
    private static final zzdf zzrw = new zzdf();
    private int[] zzrx;
    private int size;

    zzdf() {
        this(new int[10], 0);
    }

    private zzdf(int[] nArray, int n) {
        this.zzrx = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzrx, n2, this.zzrx, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdf)) {
            return super.equals(object);
        }
        zzdf zzdf2 = (zzdf)object;
        if (this.size != zzdf2.size) {
            return false;
        }
        int[] nArray = zzdf2.zzrx;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzrx[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzrx[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzh(n);
        return this.zzrx[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzal(int n) {
        this.zzo(this.size, n);
    }

    private final void zzo(int n, int n2) {
        this.zzbw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzrx.length) {
            System.arraycopy(this.zzrx, n, this.zzrx, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzrx, 0, nArray, 0, n);
            System.arraycopy(this.zzrx, n, nArray, n + 1, this.size - n);
            this.zzrx = nArray;
        }
        this.zzrx[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzbw();
        zzdg.checkNotNull(collection);
        if (!(collection instanceof zzdf)) {
            return super.addAll(collection);
        }
        zzdf zzdf2 = (zzdf)collection;
        if (zzdf2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdf2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdf2.size;
        if (n > this.zzrx.length) {
            this.zzrx = Arrays.copyOf(this.zzrx, n);
        }
        System.arraycopy(zzdf2.zzrx, 0, this.zzrx, this.size, zzdf2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzrx[i])) continue;
            System.arraycopy(this.zzrx, i + 1, this.zzrx, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdf zzdf2 = this;
        zzdf2.zzbw();
        zzdf2.zzh(n);
        int n4 = zzdf2.zzrx[n];
        zzdf2.zzrx[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdf zzdf2 = this;
        zzdf2.zzbw();
        zzdf2.zzh(n);
        int n2 = zzdf2.zzrx[n];
        if (n < zzdf2.size - 1) {
            System.arraycopy(zzdf2.zzrx, n + 1, zzdf2.zzrx, n, zzdf2.size - n);
        }
        --zzdf2.size;
        ++zzdf2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzo(n, n2);
    }

    @Override
    public final /* synthetic */ zzdj zzj(int n) {
        int n2 = n;
        zzdf zzdf2 = this;
        if (n2 < zzdf2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdf(Arrays.copyOf(zzdf2.zzrx, n2), zzdf2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzrw.zzbv();
    }
}

