/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbr;
import com.google.android.gms.internal.firebase_auth.zzdg;
import com.google.android.gms.internal.firebase_auth.zzdj;
import com.google.android.gms.internal.firebase_auth.zzev;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdy
extends zzbr<Long>
implements zzdj<Long>,
zzev,
RandomAccess {
    private static final zzdy zzta = new zzdy();
    private long[] zztb;
    private int size;

    zzdy() {
        this(new long[10], 0);
    }

    private zzdy(long[] lArray, int n) {
        this.zztb = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zztb, n2, this.zztb, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdy)) {
            return super.equals(object);
        }
        zzdy zzdy2 = (zzdy)object;
        if (this.size != zzdy2.size) {
            return false;
        }
        long[] lArray = zzdy2.zztb;
        for (int i = 0; i < this.size; ++i) {
            if (this.zztb[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdg.zzk(this.zztb[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzh(n);
        return this.zztb[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzl(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzbw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zztb.length) {
            System.arraycopy(this.zztb, n, this.zztb, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zztb, 0, lArray, 0, n);
            System.arraycopy(this.zztb, n, lArray, n + 1, this.size - n);
            this.zztb = lArray;
        }
        this.zztb[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzbw();
        zzdg.checkNotNull(collection);
        if (!(collection instanceof zzdy)) {
            return super.addAll(collection);
        }
        zzdy zzdy2 = (zzdy)collection;
        if (zzdy2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdy2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdy2.size;
        if (n > this.zztb.length) {
            this.zztb = Arrays.copyOf(this.zztb, n);
        }
        System.arraycopy(zzdy2.zztb, 0, this.zztb, this.size, zzdy2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zztb[i])) continue;
            System.arraycopy(this.zztb, i + 1, this.zztb, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdy zzdy2 = this;
        zzdy2.zzbw();
        zzdy2.zzh(n);
        long l3 = zzdy2.zztb[n];
        zzdy2.zztb[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdy zzdy2 = this;
        zzdy2.zzbw();
        zzdy2.zzh(n);
        long l = zzdy2.zztb[n];
        if (n < zzdy2.size - 1) {
            System.arraycopy(zzdy2.zztb, n + 1, zzdy2.zztb, n, zzdy2.size - n);
        }
        --zzdy2.size;
        ++zzdy2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzdj zzj(int n) {
        int n2 = n;
        zzdy zzdy2 = this;
        if (n2 < zzdy2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdy(Arrays.copyOf(zzdy2.zztb, n2), zzdy2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzta.zzbv();
    }
}

