/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.firebase_auth.zzbq;
import com.google.android.gms.internal.firebase_auth.zzex;
import com.google.android.gms.internal.firebase_auth.zzjg;
import com.google.android.gms.internal.firebase_auth.zzjq;
import com.google.android.gms.internal.firebase_auth.zzlo;
import com.google.firebase.auth.api.internal.zzea;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzey
extends AbstractSafeParcelable
implements zzea<zzey, zzlo.zzb> {
    public static final Parcelable.Creator<zzey> CREATOR = new zzex();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zza;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzc;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zzd;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zze;

    public zzey() {
        this.zze = System.currentTimeMillis();
    }

    public zzey(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzey(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = l;
        this.zzd = string3;
        this.zze = l2;
    }

    public final boolean zzb() {
        long l = this.zze + this.zzc * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }

    public final void zza(String string) {
        this.zza = Preconditions.checkNotEmpty((String)string);
    }

    public final String zzc() {
        return this.zza;
    }

    public final String zzd() {
        return this.zzb;
    }

    public final long zze() {
        if (this.zzc == null) {
            return 0L;
        }
        return this.zzc;
    }

    @Nullable
    public final String zzf() {
        return this.zzd;
    }

    public final long zzg() {
        return this.zze;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzey zzey2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzey2.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzey2.zzb, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)4, (Long)zzey2.zze(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzey2.zzd, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)zzey2.zze, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final zzjq<zzlo.zzb> zza() {
        return zzlo.zzb.zze();
    }

    public final String zzh() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)this.zza);
            jSONObject.put("access_token", (Object)this.zzb);
            jSONObject.put("expires_in", (Object)this.zzc);
            jSONObject.put("token_type", (Object)this.zzd);
            jSONObject.put("issued_at", (Object)this.zze);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to convert GetTokenResponse to JSON");
            throw new zzbq(jSONException);
        }
    }

    public static zzey zzb(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzey zzey2 = new zzey();
            new zzey().zza = jSONObject.optString("refresh_token", null);
            zzey2.zzb = jSONObject.optString("access_token", null);
            zzey2.zzc = jSONObject.optLong("expires_in");
            zzey2.zzd = jSONObject.optString("token_type", null);
            zzey2.zze = jSONObject.optLong("issued_at");
            return zzey2;
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zzbq(jSONException);
        }
    }

    @Override
    public final /* synthetic */ zzea zza(zzjg zzjg2) {
        zzjg zzjg3 = zzjg2;
        zzey zzey2 = this;
        if (!(zzjg3 instanceof zzlo.zzb)) {
            throw new IllegalArgumentException("The passed proto must be an instance of GrantTokenResponse.");
        }
        zzlo.zzb zzb2 = (zzlo.zzb)zzjg3;
        zzey2.zza = Strings.emptyToNull((String)zzb2.zzd());
        zzey2.zzb = Strings.emptyToNull((String)zzb2.zza());
        zzey2.zzc = zzb2.zzb();
        zzey2.zzd = Strings.emptyToNull((String)zzb2.zzc());
        zzey2.zze = System.currentTimeMillis();
        return zzey2;
    }
}

