/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.zzf;
import com.google.firebase.auth.zzj;

@SafeParcelable.Class(creator="EmailAuthCredentialCreator")
public class EmailAuthCredential
extends AuthCredential {
    public static final Parcelable.Creator<EmailAuthCredential> CREATOR = new zzj();
    @SafeParcelable.Field(id=1, getter="getEmail")
    private String zza;
    @SafeParcelable.Field(id=2, getter="getPassword")
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getSignInLink")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getCachedState")
    private String zzd;
    @SafeParcelable.Field(id=5, getter="isForLinking")
    private boolean zze;

    @SafeParcelable.Constructor
    EmailAuthCredential(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=3) @NonNull String string3, @SafeParcelable.Param(id=4) @NonNull String string4, @SafeParcelable.Param(id=5) @NonNull boolean bl) {
        this.zza = Preconditions.checkNotEmpty((String)string);
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Cannot create an EmailAuthCredential without a password or emailLink.");
        }
        this.zzb = string2;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = bl;
    }

    EmailAuthCredential(String string, String string2) {
        this(string, string2, null, null, false);
    }

    @NonNull
    public final String zza() {
        return this.zza;
    }

    @NonNull
    public final String zzb() {
        return this.zzb;
    }

    @NonNull
    public final String zzc() {
        return this.zzc;
    }

    @Nullable
    public final String zzd() {
        return this.zzd;
    }

    public final boolean zze() {
        return this.zze;
    }

    public final EmailAuthCredential zza(@Nullable FirebaseUser firebaseUser) {
        this.zzd = firebaseUser.zzf();
        this.zze = true;
        return this;
    }

    @Override
    @NonNull
    public String getProvider() {
        return "password";
    }

    @Override
    public String getSignInMethod() {
        if (!TextUtils.isEmpty((CharSequence)this.zzb)) {
            return "password";
        }
        return "emailLink";
    }

    public final boolean zzf() {
        return !TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public static boolean zza(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzf zzf2 = zzf.zza(string);
        return zzf2 != null && zzf2.zza() == 4;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        EmailAuthCredential emailAuthCredential = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)emailAuthCredential.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)emailAuthCredential.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)emailAuthCredential.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)emailAuthCredential.zzd, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)emailAuthCredential.zze);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

