/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase_auth.zzfr;
import com.google.android.gms.internal.firebase_auth.zzj;
import com.google.firebase.auth.internal.zzam;
import com.google.firebase.auth.internal.zzan;
import com.google.firebase.auth.internal.zzas;
import com.google.firebase.auth.internal.zzay;
import com.google.firebase.auth.internal.zzy;

@KeepName
public class FederatedSignInActivity
extends FragmentActivity {
    private static long zza = 0L;
    private boolean zzb = false;
    private static final zzam zzc = zzam.zza();
    private static Handler zzd;
    private static Runnable zze;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        String string = this.getIntent().getAction();
        if (!("com.google.firebase.auth.internal.SIGN_IN".equals(string) || "com.google.firebase.auth.internal.LINK".equals(string) || "com.google.firebase.auth.internal.REAUTHENTICATE".equals(string))) {
            String string2 = String.valueOf(string);
            Log.e((String)"IdpSignInActivity", (String)(string2.length() != 0 ? "Could not do operation - unknown action: ".concat(string2) : new String("Could not do operation - unknown action: ")));
            this.zza();
            return;
        }
        long l = DefaultClock.getInstance().currentTimeMillis();
        if (l - zza < 30000L) {
            Log.e((String)"IdpSignInActivity", (String)"Could not start operation - already in progress");
            return;
        }
        zza = l;
        if (bundle != null) {
            Bundle bundle2 = bundle;
            this.zzb = bundle2.getBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN");
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN", this.zzb);
    }

    protected void onResume() {
        zzfr zzfr2;
        String string;
        boolean bl;
        super.onResume();
        Intent intent = this.getIntent();
        FederatedSignInActivity federatedSignInActivity = this;
        if ("com.google.firebase.auth.internal.WEB_SIGN_IN_FAILED".equals(intent.getAction())) {
            Log.e((String)"IdpSignInActivity", (String)"Web sign-in failed, finishing");
            bl = true;
            if (zzay.zza(intent)) {
                federatedSignInActivity.zza(zzay.zzb(intent));
            } else {
                federatedSignInActivity.zza();
            }
        } else if (intent.hasExtra("com.google.firebase.auth.internal.OPERATION") && intent.hasExtra("com.google.firebase.auth.internal.VERIFY_ASSERTION_REQUEST")) {
            string = intent.getStringExtra("com.google.firebase.auth.internal.OPERATION");
            if ("com.google.firebase.auth.internal.SIGN_IN".equals(string) || "com.google.firebase.auth.internal.LINK".equals(string) || "com.google.firebase.auth.internal.REAUTHENTICATE".equals(string)) {
                bl = true;
                zzfr2 = (zzfr)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.firebase.auth.internal.VERIFY_ASSERTION_REQUEST", zzfr.CREATOR);
                String string2 = intent.getStringExtra("com.google.firebase.auth.internal.EXTRA_TENANT_ID");
                zzfr2.zzb(string2);
                String string3 = string2;
                zzfr zzfr3 = zzfr2;
                String string4 = string;
                FederatedSignInActivity federatedSignInActivity2 = federatedSignInActivity;
                zza = 0L;
                federatedSignInActivity2.zzb = false;
                Intent intent2 = new Intent();
                SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)zzfr3, (Intent)intent2, (String)"com.google.firebase.auth.internal.VERIFY_ASSERTION_REQUEST");
                intent2.putExtra("com.google.firebase.auth.internal.OPERATION", string4);
                intent2.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                if (!LocalBroadcastManager.getInstance((Context)federatedSignInActivity2).sendBroadcast(intent2)) {
                    String string5 = string3;
                    String string6 = string4;
                    zzfr zzfr4 = zzfr3;
                    Context context = federatedSignInActivity2.getApplicationContext();
                    zzas.zza(context, zzfr4, string6, string5);
                } else {
                    zzc.zza((Context)federatedSignInActivity2);
                }
                federatedSignInActivity2.finish();
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        if (!this.zzb) {
            federatedSignInActivity = this;
            intent = new Intent("com.google.firebase.auth.api.gms.ui.START_WEB_SIGN_IN");
            intent.setPackage("com.google.android.gms");
            intent.putExtras(federatedSignInActivity.getIntent().getExtras());
            intent.putExtra("com.google.firebase.auth.internal.OPERATION", federatedSignInActivity.getIntent().getAction());
            try {
                federatedSignInActivity.startActivityForResult(intent, 40963);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                string = "Could not launch web sign-in Intent. Google Play service is unavailable";
                Log.w((String)"IdpSignInActivity", (String)string);
                zzfr2 = new Status(17499, string);
                federatedSignInActivity.zza((Status)zzfr2);
            }
            this.zzb = true;
            return;
        }
        federatedSignInActivity = this;
        zze = new zzan(federatedSignInActivity);
        if (zzd == null) {
            zzd = new zzj();
        }
        zzd.postDelayed(zze, 800L);
    }

    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (zzd != null && zze != null) {
            zzd.removeCallbacks(zze);
            zze = null;
        }
        this.setIntent(intent);
    }

    private final void zza() {
        zza = 0L;
        this.zzb = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            Status status = zzy.zza("WEB_CONTEXT_CANCELED");
            FederatedSignInActivity federatedSignInActivity = this;
            zzas.zza((Context)federatedSignInActivity, status);
        } else {
            zzc.zza((Context)this);
        }
        this.finish();
    }

    private final void zza(Status status) {
        zza = 0L;
        this.zzb = false;
        Intent intent = new Intent();
        zzay.zza(intent, status);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            Status status2 = status;
            Context context = this.getApplicationContext();
            zzas.zza(context, status2);
        } else {
            zzc.zza((Context)this);
        }
        this.finish();
    }

    static /* synthetic */ void zza(FederatedSignInActivity federatedSignInActivity) {
        federatedSignInActivity.zza();
    }

    static /* synthetic */ Runnable zza(Runnable runnable) {
        zze = null;
        return null;
    }
}

