/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.api.internal.zzdw;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzay;
import com.google.firebase.auth.internal.zzy;
import java.lang.ref.WeakReference;

final class zzal
extends BroadcastReceiver {
    private final WeakReference<Activity> zza;
    private final TaskCompletionSource<AuthResult> zzb;
    private final FirebaseAuth zzc;
    private final FirebaseUser zzd;
    private final /* synthetic */ zzad zze;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    zzal(zzad zzad2, Activity activity, TaskCompletionSource taskCompletionSource, FirebaseAuth firebaseAuth, FirebaseUser firebaseUser) {
        this.zze = zzad2;
        this.zza = new WeakReference<Activity>(activity);
        this.zzb = taskCompletionSource;
        this.zzc = firebaseAuth;
        this.zzd = firebaseUser;
    }

    public final void onReceive(Context context, Intent intent) {
        Activity activity = (Activity)this.zza.get();
        if (activity == null) {
            Log.e((String)"FederatedAuthReceiver", (String)"Failed to unregister BroadcastReceiver because the Activity that launched this flow has been garbage collected; please do not finish() your Activity while performing a FederatedAuthProvider operation.");
            this.zzb.setException((Exception)zzdw.zza(new Status(17499, "Activity that started the web operation is no longer alive; see logcat for details")));
            zzad.zzb();
            return;
        }
        LocalBroadcastManager.getInstance((Context)activity).unregisterReceiver((BroadcastReceiver)this);
        if (intent.hasExtra("com.google.firebase.auth.internal.OPERATION")) {
            String string = intent.getStringExtra("com.google.firebase.auth.internal.OPERATION");
            if ("com.google.firebase.auth.internal.SIGN_IN".equals(string)) {
                zzad.zza(this.zze, intent, this.zzb, this.zzc);
                return;
            }
            if ("com.google.firebase.auth.internal.LINK".equals(string)) {
                zzad.zza(this.zze, intent, this.zzb, this.zzd);
                return;
            }
            if ("com.google.firebase.auth.internal.REAUTHENTICATE".equals(string)) {
                zzad.zzb(this.zze, intent, this.zzb, this.zzd);
                return;
            }
            this.zzb.setException((Exception)zzdw.zza(zzy.zza(new StringBuilder(50 + String.valueOf(string).length()).append("WEB_CONTEXT_CANCELED:Unknown operation received (").append(string).append(")").toString())));
            return;
        }
        if (zzay.zza(intent)) {
            Status status = zzay.zzb(intent);
            this.zzb.setException((Exception)zzdw.zza(status));
            zzad.zzb();
            return;
        }
        if (intent.hasExtra("com.google.firebase.auth.internal.EXTRA_CANCELED")) {
            this.zzb.setException((Exception)zzdw.zza(zzy.zza("WEB_CONTEXT_CANCELED")));
            zzad.zzb();
        }
    }
}

