/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzff;
import com.google.android.gms.internal.firebase_auth.zzfr;
import com.google.android.gms.internal.firebase_auth.zzgj;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorAssertion;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzee;
import com.google.firebase.auth.api.internal.zzeh;
import com.google.firebase.auth.api.internal.zzet;
import com.google.firebase.auth.api.internal.zzeu;
import com.google.firebase.auth.api.internal.zzex;
import com.google.firebase.auth.api.internal.zzfc;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.internal.zzao;
import com.google.firebase.auth.internal.zzar;
import com.google.firebase.auth.internal.zzau;
import com.google.firebase.auth.internal.zzaw;
import com.google.firebase.auth.internal.zzaz;
import com.google.firebase.auth.internal.zzba;
import com.google.firebase.auth.internal.zzbb;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.internal.zzo;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zza;
    private final List<IdTokenListener> zzb;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzc;
    private List<AuthStateListener> zzd;
    private com.google.firebase.auth.api.internal.zzau zze;
    private FirebaseUser zzf;
    private zzo zzg;
    private final Object zzh;
    private String zzi;
    private final Object zzj;
    private String zzk;
    private final zzaw zzl;
    private final zzao zzm;
    private zzaz zzn;
    private zzbb zzo;

    @NonNull
    @Keep
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @NonNull
    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzeu zzeu2 = new zzex(firebaseApp2.getOptions().getApiKey()).zza();
        this(firebaseApp, zzet.zza(firebaseApp2.getApplicationContext(), zzeu2), new zzaw(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey()), zzao.zza());
    }

    @VisibleForTesting
    private FirebaseAuth(FirebaseApp firebaseApp, com.google.firebase.auth.api.internal.zzau zzau2, zzaw zzaw2, zzao zzao2) {
        zzff zzff2;
        this.zzh = new Object();
        this.zzj = new Object();
        this.zza = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zze = (com.google.firebase.auth.api.internal.zzau)Preconditions.checkNotNull((Object)zzau2);
        this.zzl = (zzaw)Preconditions.checkNotNull((Object)zzaw2);
        this.zzg = new zzo();
        this.zzm = (zzao)Preconditions.checkNotNull((Object)zzao2);
        this.zzb = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzc = new CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener>();
        this.zzd = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzo = zzbb.zza();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzf = firebaseAuth.zzl.zza();
        if (firebaseAuth.zzf != null && (zzff2 = firebaseAuth.zzl.zzb(firebaseAuth.zzf)) != null) {
            firebaseAuth.zza(firebaseAuth.zzf, zzff2, false);
        }
        firebaseAuth.zzm.zza(firebaseAuth);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzf;
    }

    @Nullable
    public String getUid() {
        if (this.zzf == null) {
            return null;
        }
        return this.zzf.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzff zzff2, boolean bl) {
        this.zza(firebaseUser, zzff2, bl, false);
    }

    @VisibleForTesting
    final void zza(FirebaseUser firebaseUser, zzff zzff2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzff2);
        boolean bl5 = this.zzf != null && firebaseUser.getUid().equals(this.zzf.getUid());
        if (!bl5 && bl2) {
            return;
        }
        if (this.zzf == null) {
            bl4 = true;
            bl3 = true;
        } else {
            String string;
            String string2 = this.zzf.zze().zzd();
            boolean bl6 = !string2.equals(string = zzff2.zzd());
            bl4 = !bl5 || bl6;
            bl3 = !bl5;
        }
        boolean bl7 = bl3;
        boolean bl8 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Preconditions.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzf == null) {
            firebaseAuth.zzf = firebaseUser2;
        } else {
            firebaseAuth.zzf.zza(firebaseUser2.getProviderData());
            if (!firebaseUser2.isAnonymous()) {
                firebaseAuth.zzf.zzb();
            }
            List<MultiFactorInfo> list = firebaseUser2.getMultiFactor().getEnrolledFactors();
            firebaseAuth.zzf.zzb(list);
        }
        if (bl8) {
            firebaseAuth.zzl.zza(firebaseAuth.zzf);
        }
        if (bl4) {
            if (this.zzf != null) {
                this.zzf.zza(zzff2);
            }
            this.zzc(this.zzf);
        }
        if (bl7) {
            this.zzd(this.zzf);
        }
        if (bl) {
            this.zzl.zza(firebaseUser, zzff2);
        }
        firebaseAuth = this;
        firebaseAuth.zzd().zza(firebaseAuth.zzf.zze());
    }

    public final void zza() {
        if (this.zzf != null) {
            FirebaseUser firebaseUser = this.zzf;
            zzaw zzaw2 = this.zzl;
            Preconditions.checkNotNull((Object)firebaseUser);
            zzaw2.zza(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzf = null;
        }
        this.zzl.zza("com.google.firebase.auth.FIREBASE_USER");
        this.zzc(null);
        this.zzd(null);
    }

    @VisibleForTesting
    private final synchronized void zza(zzaz zzaz2) {
        this.zzn = zzaz2;
    }

    @VisibleForTesting
    private final synchronized zzaz zzd() {
        if (this.zzn == null) {
            this.zza(new zzaz(this.zza));
        }
        return this.zzn;
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zza;
    }

    public final FirebaseApp zzb() {
        return this.zza;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.add(idTokenListener);
        this.zzo.execute(new zzh(this, idTokenListener));
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.add(idTokenListener);
        this.zzd().zza(this.zzc.size());
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.remove(idTokenListener);
    }

    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.remove(idTokenListener);
        this.zzd().zza(this.zzc.size());
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.add(authStateListener);
        this.zzo.execute(new zzj(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.remove(authStateListener);
    }

    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzg() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult(string);
        this.zzo.execute(new zzi(this, internalTokenResult));
    }

    private final void zzd(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzo.execute(new zzl(this));
    }

    @NonNull
    public Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zza(this.zzf, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17495)));
        }
        zzff zzff2 = firebaseUser.zze();
        if (zzff2.zzb() && !bl) {
            return Tasks.forResult((Object)zzar.zza(zzff2.zzd()));
        }
        return this.zze.zza(this.zza, firebaseUser, zzff2.zzc(), (zzba)((Object)new zzk(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        AuthCredential authCredential2 = authCredential.zza();
        if (authCredential2 instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential2;
            if (!emailAuthCredential.zzg()) {
                return this.zze.zzb(this.zza, emailAuthCredential.zzb(), emailAuthCredential.zzc(), this.zzk, new zzb());
            }
            if (this.zzb(emailAuthCredential.zzd())) {
                return Tasks.forException((Exception)zzeh.zza(new Status(17072)));
            }
            return this.zze.zza(this.zza, emailAuthCredential, new zzb());
        }
        if (authCredential2 instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential2;
            return this.zze.zza(this.zza, phoneAuthCredential, this.zzk, (com.google.firebase.auth.internal.zza)new zzb());
        }
        return this.zze.zza(this.zza, authCredential2, this.zzk, (com.google.firebase.auth.internal.zza)new zzb());
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        AuthCredential authCredential2 = authCredential.zza();
        if (authCredential2 instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential2;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zze.zza(this.zza, firebaseUser, emailAuthCredential.zzb(), emailAuthCredential.zzc(), firebaseUser.zzd(), (zzba)((Object)new zza()));
            }
            if (this.zzb(emailAuthCredential.zzd())) {
                return Tasks.forException((Exception)zzeh.zza(new Status(17072)));
            }
            return this.zze.zza(this.zza, firebaseUser, emailAuthCredential, (zzba)((Object)new zza()));
        }
        if (authCredential2 instanceof PhoneAuthCredential) {
            return this.zze.zza(this.zza, firebaseUser, (PhoneAuthCredential)authCredential2, this.zzk, (zzba)((Object)new zza()));
        }
        return this.zze.zza(this.zza, firebaseUser, authCredential2, firebaseUser.zzd(), (zzba)((Object)new zza()));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        AuthCredential authCredential2 = authCredential.zza();
        if (authCredential2 instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential2;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zze.zzb(this.zza, firebaseUser, emailAuthCredential.zzb(), emailAuthCredential.zzc(), firebaseUser.zzd(), (zzba)((Object)new zza()));
            }
            if (this.zzb(emailAuthCredential.zzd())) {
                return Tasks.forException((Exception)zzeh.zza(new Status(17072)));
            }
            return this.zze.zzb(this.zza, firebaseUser, emailAuthCredential, (zzba)((Object)new zza()));
        }
        if (authCredential2 instanceof PhoneAuthCredential) {
            return this.zze.zzb(this.zza, firebaseUser, (PhoneAuthCredential)authCredential2, this.zzk, (zzba)((Object)new zza()));
        }
        return this.zze.zzb(this.zza, firebaseUser, authCredential2, firebaseUser.zzd(), (zzba)((Object)new zza()));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zza(this.zza, string, this.zzk, (com.google.firebase.auth.internal.zza)new zzb());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zzb(this.zza, string, string2, this.zzk, new zzb());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzf != null && this.zzf.isAnonymous()) {
            zzn zzn2 = (zzn)this.zzf;
            zzn2.zza(false);
            return Tasks.forResult((Object)new com.google.firebase.auth.internal.zzh(zzn2));
        }
        return this.zze.zza(this.zza, new zzb(), this.zzk);
    }

    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl, @Nullable String string2) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzfr zzfr2 = new zzfr(string, l2, bl, this.zzi, this.zzk, string2);
        onVerificationStateChangedCallbacks = this.zza(string, onVerificationStateChangedCallbacks);
        this.zze.zza(this.zza, zzfr2, onVerificationStateChangedCallbacks, activity, executor);
    }

    public static void zza(@NonNull PhoneAuthOptions phoneAuthOptions) {
        if (phoneAuthOptions.zzl()) {
            PhoneAuthOptions phoneAuthOptions2 = phoneAuthOptions;
            FirebaseAuth firebaseAuth = phoneAuthOptions.zza();
            long l = phoneAuthOptions2.zzc();
            PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks = firebaseAuth.zza(phoneAuthOptions2.zzb(), phoneAuthOptions2.zzd());
            zzy zzy2 = (zzy)phoneAuthOptions2.zzg();
            if (zzy2.zzc()) {
                firebaseAuth.zze.zza(zzy2, phoneAuthOptions2.zzb(), firebaseAuth.zzi, l, phoneAuthOptions2.zzf() != null, phoneAuthOptions2.zzi(), onVerificationStateChangedCallbacks, phoneAuthOptions2.zze(), phoneAuthOptions2.zzj());
                return;
            }
            firebaseAuth.zze.zza(zzy2, phoneAuthOptions2.zzk(), firebaseAuth.zzi, l, phoneAuthOptions2.zzf() != null, phoneAuthOptions2.zzi(), onVerificationStateChangedCallbacks, phoneAuthOptions2.zze(), phoneAuthOptions2.zzj());
            return;
        }
        phoneAuthOptions.zza().zza(phoneAuthOptions.zzb(), phoneAuthOptions.zzc(), TimeUnit.SECONDS, phoneAuthOptions.zzd(), phoneAuthOptions.zzj(), phoneAuthOptions.zze(), phoneAuthOptions.zzf() != null, phoneAuthOptions.zzh());
    }

    private final PhoneAuthProvider.OnVerificationStateChangedCallbacks zza(String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        if (this.zzg.zzc() && string.equals(this.zzg.zza())) {
            PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks2 = onVerificationStateChangedCallbacks;
            FirebaseAuth firebaseAuth = this;
            onVerificationStateChangedCallbacks = new com.google.firebase.auth.zzn(firebaseAuth, onVerificationStateChangedCallbacks2);
        }
        return onVerificationStateChangedCallbacks;
    }

    @NonNull
    public Task<Void> updateCurrentUser(@NonNull FirebaseUser firebaseUser) {
        if (firebaseUser == null) {
            throw new IllegalArgumentException("Cannot update current user with null user!");
        }
        if (firebaseUser.zzd() != null && !firebaseUser.zzd().equals(this.zzk) || this.zzk != null && !this.zzk.equals(firebaseUser.zzd())) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17072)));
        }
        String string = firebaseUser.zzc().getOptions().getApiKey();
        String string2 = this.zza.getOptions().getApiKey();
        if (firebaseUser.zze().zzb() && string2.equals(string)) {
            FirebaseUser firebaseUser2 = com.google.firebase.auth.internal.zzn.zza(this.zza, firebaseUser);
            this.zza(firebaseUser2, firebaseUser.zze(), true);
            return Tasks.forResult(null);
        }
        return this.zza(firebaseUser, (zzba)((Object)new zzc(this)));
    }

    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser) {
        return this.zza(firebaseUser, (zzba)((Object)new zza()));
    }

    @NonNull
    private final Task<Void> zza(@NonNull FirebaseUser firebaseUser, zzba zzba2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(this.zza, firebaseUser, zzba2);
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(this.zza, firebaseUser, authCredential.zza(), (zzba)((Object)new zza()));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zzd(this.zza, firebaseUser, string, (zzba)((Object)new zza()));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zza(this.zza, string, string2, this.zzk, (com.google.firebase.auth.internal.zza)new zzb());
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zza(this.zza, string, this.zzk);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zze.zza(this.zza, firebaseUser, userProfileChangeRequest, (zzba)((Object)new zza()));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzb(this.zza, firebaseUser, string, (zzba)((Object)new zza()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zze.zza(this.zza, firebaseUser, (PhoneAuthCredential)((AuthCredential)phoneAuthCredential).zza(), (zzba)((Object)new zza()));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzc(this.zza, firebaseUser, string, (zzba)((Object)new zza()));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zza();
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        actionCodeSettings.zza(zzgj.zzb);
        return this.zze.zza(this.zza, string, actionCodeSettings, this.zzk);
    }

    @NonNull
    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        return this.zze.zzb(this.zza, string, actionCodeSettings, this.zzk);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.zza(string);
    }

    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzi != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zza();
            }
            actionCodeSettings.zza(this.zzi);
        }
        return this.zze.zza(this.zza, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzb(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzc(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzd(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zza(this.zza, string, string2, this.zzk);
    }

    public final Task<Void> zzd(FirebaseUser firebaseUser, String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zze(this.zza, firebaseUser, string, (zzba)((Object)new zza())).continueWithTask((Continuation)new zzm(this));
    }

    public final Task<AuthResult> zza(MultiFactorAssertion multiFactorAssertion, zzy zzy2, @Nullable FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        Preconditions.checkNotNull((Object)((Object)zzy2));
        return this.zze.zza(this.zza, firebaseUser, (PhoneMultiFactorAssertion)multiFactorAssertion, zzy2.zzb(), (com.google.firebase.auth.internal.zza)new zzb());
    }

    @NonNull
    public Task<AuthResult> startActivityForSignInWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)activity);
        if (!zzee.zza()) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17063)));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzm.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this)) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17057)));
        }
        FirebaseAuth firebaseAuth = this;
        Context context = activity.getApplicationContext();
        zzau.zza(context, firebaseAuth);
        federatedAuthProvider.zza(activity);
        return taskCompletionSource.getTask();
    }

    public final Task<AuthResult> zza(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        if (!zzee.zza()) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17063)));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzm.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17057)));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Context context = activity.getApplicationContext();
        zzau.zza(context, firebaseAuth, firebaseUser2);
        federatedAuthProvider.zzb(activity);
        return taskCompletionSource.getTask();
    }

    public final Task<AuthResult> zzb(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        if (!zzee.zza()) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17063)));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzm.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzeh.zza(new Status(17057)));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Context context = activity.getApplicationContext();
        zzau.zza(context, firebaseAuth, firebaseUser2);
        federatedAuthProvider.zzc(activity);
        return taskCompletionSource.getTask();
    }

    @Nullable
    public Task<AuthResult> getPendingAuthResult() {
        return this.zzm.zzb();
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(firebaseUser, new com.google.firebase.auth.zzo(this, firebaseUser));
    }

    public final Task<Void> zza(String string, String string2, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zza();
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        return this.zze.zza(string, string2, actionCodeSettings);
    }

    public final Task<Void> zza(FirebaseUser firebaseUser, MultiFactorAssertion multiFactorAssertion, @Nullable String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        if (multiFactorAssertion instanceof PhoneMultiFactorAssertion) {
            return this.zze.zza(this.zza, (PhoneMultiFactorAssertion)multiFactorAssertion, firebaseUser, string, (com.google.firebase.auth.internal.zza)new zzb());
        }
        return Tasks.forException((Exception)zzeh.zza(new Status(17499)));
    }

    public void signOut() {
        this.zza();
        if (this.zzn != null) {
            this.zzn.zza();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzh;
        synchronized (object) {
            return this.zzi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzj;
        synchronized (object) {
            this.zzk = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzc() {
        Object object = this.zzj;
        synchronized (object) {
            return this.zzk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = zzfc.zza();
            return;
        }
    }

    @NonNull
    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzg;
    }

    @NonNull
    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zze.zza(string);
    }

    private final boolean zzb(String string) {
        ActionCodeUrl actionCodeUrl = ActionCodeUrl.parseLink(string);
        return actionCodeUrl != null && !TextUtils.equals((CharSequence)this.zzk, (CharSequence)actionCodeUrl.zza());
    }

    static /* synthetic */ List zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzd;
    }

    static /* synthetic */ zzo zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzg;
    }

    static /* synthetic */ FirebaseUser zze(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzf;
    }

    final class zzc
    extends zzb
    implements com.google.firebase.auth.internal.zza,
    zzag {
        zzc(FirebaseAuth firebaseAuth) {
        }

        @Override
        public final void zza(Status status) {
        }
    }

    @VisibleForTesting
    final class zza
    implements com.google.firebase.auth.internal.zza,
    zzag {
        zza() {
        }

        @Override
        public final void zza(@NonNull zzff zzff2, @NonNull FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzff2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzff2);
            FirebaseAuth.this.zza(firebaseUser, zzff2, true, true);
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005 || status.getStatusCode() == 17091) {
                FirebaseAuth.this.signOut();
            }
        }
    }

    @VisibleForTesting
    class zzb
    implements com.google.firebase.auth.internal.zza {
        zzb() {
        }

        @Override
        public final void zza(@NonNull zzff zzff2, @NonNull FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzff2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzff2);
            FirebaseAuth.this.zza(firebaseUser, zzff2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

