/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.android.gms.internal.firebase-auth-api.zzhm;
import com.google.android.gms.internal.firebase-auth-api.zzip;
import com.google.android.gms.internal.firebase-auth-api.zzzn;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class zzdw {
    private final SharedPreferences zza;
    private final String zzb;

    public zzdw(Context context, String string, String string2) throws IOException {
        this.zzb = "GenericIdpKeyset";
        context = context.getApplicationContext();
        if (string2 == null) {
            this.zza = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return;
        }
        this.zza = context.getSharedPreferences(string2, 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] zzc() throws IOException {
        Object[] objectArray;
        try {
            objectArray = this.zza.getString(this.zzb, null);
            if (objectArray != null) {
                int n = objectArray.length() % 2;
                if (n != 0) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Expected a string of even length");
                    throw illegalArgumentException;
                }
                int n2 = objectArray.length() / 2;
                byte[] byArray = new byte[n2];
                for (n = 0; n < n2; ++n) {
                    int n3 = n + n;
                    int n4 = Character.digit(objectArray.charAt(n3), 16);
                    n3 = Character.digit(objectArray.charAt(n3 + 1), 16);
                    if (n4 == -1 || n3 == -1) {
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("input is not hexadecimal");
                        throw illegalArgumentException;
                    }
                    byArray[n] = (byte)(n4 * 16 + n3);
                }
                return byArray;
            }
        }
        catch (ClassCastException | IllegalArgumentException runtimeException) {
            objectArray = new Object[]{this.zzb};
            CharConversionException charConversionException = new CharConversionException(String.format("can't read keyset; the pref value %s is not a valid hex string", objectArray));
            throw charConversionException;
        }
        {
            objectArray = new Object[]{this.zzb};
            FileNotFoundException fileNotFoundException = new FileNotFoundException(String.format("can't read keyset; the pref value %s does not exist", objectArray));
            throw fileNotFoundException;
        }
    }

    public final zzip zza() throws IOException {
        return zzip.zze(this.zzc(), zzzn.zza());
    }

    public final zzhm zzb() throws IOException {
        return zzhm.zzb(this.zzc(), zzzn.zza());
    }
}

