/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzun;
import com.google.android.gms.internal.firebase-auth-api.zzxw;
import com.google.firebase.auth.internal.zzi;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="VerifyAssertionRequestCreator")
public final class zzxv
extends AbstractSafeParcelable
implements zzun {
    public static final Parcelable.Creator<zzxv> CREATOR;
    @SafeParcelable.Field(id=2, getter="getRequestUri")
    private String zza;
    @SafeParcelable.Field(id=3, getter="getCurrentIdToken")
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getIdToken")
    private String zzc;
    @SafeParcelable.Field(id=5, getter="getAccessToken")
    private String zzd;
    @SafeParcelable.Field(id=6, getter="getProviderId")
    private String zze;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getEmail")
    private String zzf;
    @SafeParcelable.Field(id=8, getter="getPostBody")
    private String zzg;
    @SafeParcelable.Field(id=9, getter="getOauthTokenSecret")
    private String zzh;
    @SafeParcelable.Field(id=10, getter="getReturnSecureToken")
    private boolean zzi;
    @SafeParcelable.Field(id=11, getter="getAutoCreate")
    private boolean zzj;
    @SafeParcelable.Field(id=12, getter="getAuthCode")
    private String zzk;
    @SafeParcelable.Field(id=13, getter="getSessionId")
    private String zzl;
    @SafeParcelable.Field(id=14, getter="getIdpResponseUrl")
    private String zzm;
    @SafeParcelable.Field(id=15, getter="getTenantId")
    private String zzn;
    @SafeParcelable.Field(id=16, getter="getReturnIdpCredential")
    private boolean zzo;
    @SafeParcelable.Field(id=17, getter="getPendingToken")
    @Nullable
    private String zzp;

    public zzxv() {
        this.zzi = true;
        this.zzj = true;
    }

    @SafeParcelable.Constructor
    zzxv(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) String string7, @SafeParcelable.Param(id=9) String string8, @SafeParcelable.Param(id=10) boolean bl, @SafeParcelable.Param(id=11) boolean bl2, @SafeParcelable.Param(id=12) String string9, @SafeParcelable.Param(id=13) String string10, @SafeParcelable.Param(id=14) String string11, @SafeParcelable.Param(id=15) String string12, @SafeParcelable.Param(id=16) boolean bl3, @SafeParcelable.Param(id=17) String string13) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = string5;
        this.zzf = string6;
        this.zzg = string7;
        this.zzh = string8;
        this.zzi = bl;
        this.zzj = bl2;
        this.zzk = string9;
        this.zzl = string10;
        this.zzm = string11;
        this.zzn = string12;
        this.zzo = bl3;
        this.zzp = string13;
    }

    public zzxv(zzi object, String string) {
        Preconditions.checkNotNull((Object)object);
        this.zzl = Preconditions.checkNotEmpty((String)((zzi)object).zza());
        this.zzm = Preconditions.checkNotEmpty((String)string);
        this.zze = Preconditions.checkNotEmpty((String)((zzi)object).zzc());
        this.zzi = true;
        object = new StringBuilder();
        ((StringBuilder)object).append("providerId=");
        ((StringBuilder)object).append(this.zze);
        this.zzg = ((StringBuilder)object).toString();
    }

    public zzxv(@Nullable String charSequence, @Nullable String string, String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8) {
        ((zzxv)object).zza = "http://localhost";
        ((zzxv)object).zzc = charSequence;
        ((zzxv)object).zzd = string;
        ((zzxv)object).zzh = string4;
        ((zzxv)object).zzk = string5;
        ((zzxv)object).zzn = string6;
        ((zzxv)object).zzp = string7;
        ((zzxv)object).zzi = true;
        if (!(TextUtils.isEmpty((CharSequence)((zzxv)object).zzc) && TextUtils.isEmpty((CharSequence)((zzxv)object).zzd) && TextUtils.isEmpty((CharSequence)((zzxv)object).zzk))) {
            ((zzxv)object).zze = Preconditions.checkNotEmpty((String)string2);
            ((zzxv)object).zzf = null;
            if (!TextUtils.isEmpty((CharSequence)((zzxv)object).zzc)) {
                ((StringBuilder)charSequence).append("id_token=");
                ((StringBuilder)charSequence).append(((zzxv)object).zzc);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)((zzxv)object).zzd)) {
                ((StringBuilder)charSequence).append("access_token=");
                ((StringBuilder)charSequence).append(((zzxv)object).zzd);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)((zzxv)object).zzf)) {
                ((StringBuilder)charSequence).append("identifier=");
                ((StringBuilder)charSequence).append(((zzxv)object).zzf);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)((zzxv)object).zzh)) {
                ((StringBuilder)charSequence).append("oauth_token_secret=");
                ((StringBuilder)charSequence).append(((zzxv)object).zzh);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)((zzxv)object).zzk)) {
                ((StringBuilder)charSequence).append("code=");
                ((StringBuilder)charSequence).append(((zzxv)object).zzk);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)string8)) {
                ((StringBuilder)charSequence).append("nonce=");
                ((StringBuilder)charSequence).append(string8);
                ((StringBuilder)charSequence).append("&");
            }
        } else {
            Object object = new IllegalArgumentException("idToken, accessToken and authCode cannot all be null");
            throw object;
        }
        ((StringBuilder)charSequence).append("providerId=");
        ((StringBuilder)charSequence).append(((zzxv)object).zze);
        ((zzxv)object).zzg = ((StringBuilder)charSequence).toString();
        ((zzxv)object).zzj = true;
    }

    public final zzxv zzb(String string) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
        return this;
    }

    public final zzxv zzc(boolean bl) {
        this.zzj = false;
        return this;
    }

    public final zzxv zzd(@Nullable String string) {
        this.zzn = string;
        return this;
    }

    public final zzxv zze(boolean bl) {
        this.zzi = true;
        return this;
    }

    public final zzxv zzf(boolean bl) {
        this.zzo = true;
        return this;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)6, (String)this.zze, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)7, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)8, (String)this.zzg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)9, (String)this.zzh, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)10, (boolean)this.zzi);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)11, (boolean)this.zzj);
        SafeParcelWriter.writeString((Parcel)parcel, (int)12, (String)this.zzk, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)13, (String)this.zzl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)14, (String)this.zzm, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)15, (String)this.zzn, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)16, (boolean)this.zzo);
        SafeParcelWriter.writeString((Parcel)parcel, (int)17, (String)this.zzp, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String zza() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("autoCreate", this.zzj);
        jSONObject.put("returnSecureToken", this.zzi);
        String string = this.zzb;
        if (string != null) {
            jSONObject.put("idToken", (Object)string);
        }
        if ((string = this.zzg) != null) {
            jSONObject.put("postBody", (Object)string);
        }
        if ((string = this.zzn) != null) {
            jSONObject.put("tenantId", (Object)string);
        }
        if ((string = this.zzp) != null) {
            jSONObject.put("pendingToken", (Object)string);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzl)) {
            jSONObject.put("sessionId", (Object)this.zzl);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzm)) {
            jSONObject.put("requestUri", (Object)this.zzm);
        } else {
            string = this.zza;
            if (string != null) {
                jSONObject.put("requestUri", (Object)string);
            }
        }
        jSONObject.put("returnIdpCredential", this.zzo);
        return jSONObject.toString();
    }

    static {
        zzxw zzxw2;
        CREATOR = zzxw2 = new zzxw();
    }
}

