/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zztn;
import com.google.android.gms.internal.firebase-auth-api.zztp;
import com.google.android.gms.internal.firebase-auth-api.zztt;
import com.google.android.gms.internal.firebase-auth-api.zzuj;
import com.google.android.gms.internal.firebase-auth-api.zzuk;
import com.google.android.gms.internal.firebase-auth-api.zzul;
import com.google.android.gms.internal.firebase-auth-api.zzus;
import com.google.android.gms.internal.firebase-auth-api.zzvm;
import com.google.android.gms.internal.firebase-auth-api.zzvw;
import com.google.android.gms.internal.firebase-auth-api.zzwv;
import com.google.android.gms.internal.firebase-auth-api.zzxi;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorAssertion;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.internal.zzay;
import com.google.firebase.auth.internal.zzbg;
import com.google.firebase.auth.internal.zzbi;
import com.google.firebase.auth.internal.zzbj;
import com.google.firebase.auth.internal.zzbk;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzr;
import com.google.firebase.auth.internal.zzw;
import com.google.firebase.auth.internal.zzx;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.auth.zzp;
import com.google.firebase.auth.zzq;
import com.google.firebase.auth.zzs;
import com.google.firebase.auth.zzt;
import com.google.firebase.auth.zzu;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zza;
    private final List<IdTokenListener> zzb;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzc;
    private List<AuthStateListener> zzd;
    private zztn zze;
    @Nullable
    private FirebaseUser zzf;
    private zzw zzg;
    private final Object zzh;
    private String zzi;
    private final Object zzj;
    private String zzk;
    private final zzbg zzl;
    private final zzbm zzm;
    private final zzf zzn;
    private zzbi zzo;
    private zzbj zzp;

    @Keep
    @NonNull
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    @NonNull
    public static FirebaseAuth getInstance(@RecentlyNonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    public FirebaseAuth(@RecentlyNonNull FirebaseApp object) {
        Object object2 = object.getOptions();
        object2 = object2.getApiKey();
        object2 = Preconditions.checkNotEmpty((String)object2);
        object2 = zzuj.zza((String)object2);
        Object object3 = object.getApplicationContext();
        object2 = zzul.zza(object3, (zzuk)object2);
        super(object.getApplicationContext(), object.getPersistenceKey());
        zzbm zzbm2 = zzbm.zza();
        zzf zzf2 = com.google.firebase.auth.internal.zzf.zza();
        super();
        Object object4 = new CopyOnWriteArrayList();
        this.zzb = object4;
        object4 = new CopyOnWriteArrayList();
        this.zzc = object4;
        object4 = new CopyOnWriteArrayList();
        this.zzd = object4;
        this.zzh = object4 = new Object();
        this.zzj = object4 = new Object();
        this.zzp = zzbj.zza();
        this.zza = (FirebaseApp)Preconditions.checkNotNull((Object)object);
        this.zze = (zztn)Preconditions.checkNotNull((Object)object2);
        this.zzl = (zzbg)Preconditions.checkNotNull((Object)object3);
        super();
        this.zzg = object;
        this.zzm = (zzbm)Preconditions.checkNotNull((Object)zzbm2);
        this.zzn = (zzf)Preconditions.checkNotNull((Object)zzf2);
        this.zzf = this.zzl.zzb();
        object = this.zzf;
        if (object != null && (object = this.zzl.zzd((FirebaseUser)object)) != null) {
            FirebaseAuth.zzb(this, this.zzf, (zzwv)object, false, false);
        }
        this.zzm.zzf(this);
    }

    @RecentlyNullable
    public FirebaseUser getCurrentUser() {
        return this.zzf;
    }

    @RecentlyNullable
    public final String getUid() {
        FirebaseUser firebaseUser = ((FirebaseAuth)((Object)firebaseUser)).zzf;
        if (firebaseUser == null) {
            return null;
        }
        return firebaseUser.getUid();
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     */
    public void addIdTokenListener(@RecentlyNonNull IdTokenListener listener) {
        void var1_1;
        this.zzb.add((IdTokenListener)var1_1);
        Object object = this.zzp;
        object = Preconditions.checkNotNull((Object)object);
        object = (zzbj)object;
        zzj zzj2 = new zzj(this, (IdTokenListener)var1_1);
        ((zzbj)object).execute(zzj2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void addIdTokenListener(@RecentlyNonNull com.google.firebase.auth.internal.IdTokenListener listener) {
        void var1_1;
        Preconditions.checkNotNull((Object)listener);
        this.zzc.add((com.google.firebase.auth.internal.IdTokenListener)var1_1);
        this.zzd().zza(this.zzc.size());
    }

    /*
     * WARNING - void declaration
     */
    public void removeIdTokenListener(@RecentlyNonNull IdTokenListener listener) {
        void var1_1;
        this.zzb.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void removeIdTokenListener(@RecentlyNonNull com.google.firebase.auth.internal.IdTokenListener listenerToRemove) {
        void var1_1;
        Preconditions.checkNotNull((Object)listenerToRemove);
        this.zzc.remove(var1_1);
        this.zzd().zza(this.zzc.size());
    }

    /*
     * WARNING - void declaration
     */
    public void addAuthStateListener(@RecentlyNonNull AuthStateListener listener) {
        void var1_1;
        this.zzd.add((AuthStateListener)var1_1);
        zzbj zzbj2 = this.zzp;
        zzk zzk2 = new zzk(this, (AuthStateListener)var1_1);
        zzbj2.execute(zzk2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeAuthStateListener(@RecentlyNonNull AuthStateListener listener) {
        void var1_1;
        this.zzd.remove(var1_1);
    }

    @RecentlyNonNull
    public final Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zzh(this.zzf, bl);
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@RecentlyNonNull AuthCredential credential) {
        Object object;
        Preconditions.checkNotNull((Object)((Object)credential));
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if (!((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).zzh()) {
                zztn zztn2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzb();
                object = ((EmailAuthCredential)((Object)object)).zzc();
                object = Preconditions.checkNotEmpty((String)object);
                String string2 = firebaseAuth.zzk;
                zzs zzs2 = new zzs(firebaseAuth);
                return zztn2.zzq(firebaseApp, string, (String)object, string2, zzs2);
            }
            if (firebaseAuth.zzK(Preconditions.checkNotEmpty((String)((EmailAuthCredential)((Object)object)).zzd()))) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
            }
            zztn zztn3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzs zzs3 = new zzs(firebaseAuth);
            return zztn3.zzr(firebaseApp, (EmailAuthCredential)((Object)object), zzs3);
        }
        if (object instanceof PhoneAuthCredential) {
            object = (PhoneAuthCredential)object;
            zztn zztn4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            String string = firebaseAuth.zzk;
            zzs zzs4 = new zzs(firebaseAuth);
            return zztn4.zzw(firebaseApp, (PhoneAuthCredential)object, string, zzs4);
        }
        zztn zztn5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseAuth.zzk;
        zzs zzs5 = new zzs(firebaseAuth);
        return zztn5.zzg(firebaseApp, (AuthCredential)((Object)object), string, zzs5);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithCustomToken(@RecentlyNonNull String token) {
        void var1_1;
        Preconditions.checkNotEmpty((String)token);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztn2.zzf(firebaseApp, (String)var1_1, string, zzs2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@RecentlyNonNull String email, @RecentlyNonNull String password) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotEmpty((String)var2_2);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztn2.zzq(firebaseApp, (String)var1_1, (String)var2_2, string, zzs2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithEmailLink(@RecentlyNonNull String email, @RecentlyNonNull String link) {
        void var2_2;
        void var1_1;
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink((String)var1_1, (String)var2_2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        Object object = ((FirebaseAuth)((Object)this_)).zzf;
        if (object != null && ((FirebaseUser)object).isAnonymous()) {
            zzx this_ = (zzx)((FirebaseAuth)((Object)this_)).zzf;
            this_.zzn(false);
            object = new zzr(this_);
            return Tasks.forResult((Object)object);
        }
        object = ((FirebaseAuth)((Object)this_)).zze;
        FirebaseApp firebaseApp = ((FirebaseAuth)((Object)this_)).zza;
        zzs zzs2 = new zzs((FirebaseAuth)((Object)this_));
        return ((zztn)object).zzj(firebaseApp, zzs2, ((FirebaseAuth)((Object)this_)).zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> updateCurrentUser(@RecentlyNonNull FirebaseUser user) {
        String string;
        void var1_1;
        Object object;
        if (user == null) {
            object = new IllegalArgumentException("Cannot update current user with null user!");
            throw object;
        }
        Object object2 = var1_1.getTenantId();
        if ((object2 == null || ((String)object2).equals(((FirebaseAuth)object).zzk)) && ((string = ((FirebaseAuth)object).zzk) == null || string.equals(object2))) {
            object2 = var1_1.zzd().getOptions().getApiKey();
            string = ((FirebaseAuth)object).zza.getOptions().getApiKey();
            if (var1_1.zze().zzb() && string.equals(object2)) {
                ((FirebaseAuth)object).zza(zzx.zzs(((FirebaseAuth)object).zza, (FirebaseUser)var1_1), var1_1.zze(), true);
                return Tasks.forResult(null);
            }
            object2 = new zzu((FirebaseAuth)object);
            return ((FirebaseAuth)object).zzm((FirebaseUser)var1_1, (zzbk)object2);
        }
        object = new Status(17072);
        return Tasks.forException((Exception)zztt.zza((Status)object));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@RecentlyNonNull String email, @RecentlyNonNull String password) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotEmpty((String)var2_2);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztn2.zzp(firebaseApp, (String)var1_1, (String)var2_2, string, zzs2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@RecentlyNonNull String email) {
        void var1_1;
        Preconditions.checkNotEmpty((String)email);
        return this.zze.zzz(this.zza, (String)var1_1, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendPasswordResetEmail(@RecentlyNonNull String email) {
        void var1_1;
        Preconditions.checkNotEmpty((String)email);
        return this.sendPasswordResetEmail((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendPasswordResetEmail(@RecentlyNonNull String email, @Nullable ActionCodeSettings actionCodeSettings) {
        void var1_1;
        String string;
        ActionCodeSettings actionCodeSettings2;
        Preconditions.checkNotEmpty((String)email);
        if (actionCodeSettings2 == null) {
            actionCodeSettings2 = ActionCodeSettings.zza();
        }
        if ((string = this.zzi) != null) {
            actionCodeSettings2.zzc(string);
        }
        actionCodeSettings2.zze(1);
        return this.zze.zzA(this.zza, (String)var1_1, actionCodeSettings2, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendSignInLinkToEmail(@RecentlyNonNull String email, @RecentlyNonNull ActionCodeSettings actionCodeSettings) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotNull((Object)var2_2);
        if (!var2_2.canHandleCodeInApp()) {
            Object object = new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
            throw object;
        }
        String string = ((FirebaseAuth)object).zzi;
        if (string != null) {
            var2_2.zzc(string);
        }
        return ((FirebaseAuth)object).zze.zzB(((FirebaseAuth)object).zza, (String)var1_1, (ActionCodeSettings)var2_2, ((FirebaseAuth)object).zzk);
    }

    public boolean isSignInWithEmailLink(@RecentlyNonNull String link) {
        return EmailAuthCredential.zzi(link);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<ActionCodeResult> checkActionCode(@RecentlyNonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zze.zzD(this.zza, (String)var1_1, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> applyActionCode(@RecentlyNonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zze.zzE(this.zza, (String)var1_1, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<String> verifyPasswordResetCode(@RecentlyNonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zze.zzF(this.zza, (String)var1_1, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> confirmPasswordReset(@RecentlyNonNull String code, @RecentlyNonNull String newPassword) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)code);
        Preconditions.checkNotEmpty((String)var2_2);
        return this.zze.zzG(this.zza, (String)var1_1, (String)var2_2, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> startActivityForSignInWithProvider(@RecentlyNonNull Activity activity, @RecentlyNonNull FederatedAuthProvider federatedAuthProvider) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)var1_1);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzi((Activity)var1_1, (TaskCompletionSource<AuthResult>)taskCompletionSource, firebaseAuth)) {
            FirebaseAuth firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzb(var1_1.getApplicationContext(), firebaseAuth);
        var2_2.zza((Activity)var1_1);
        return taskCompletionSource.getTask();
    }

    @RecentlyNullable
    public Task<AuthResult> getPendingAuthResult() {
        return this.zzm.zzd();
    }

    public void signOut() {
        ((FirebaseAuth)((Object)this_)).zzc();
        zzbi this_ = ((FirebaseAuth)((Object)this_)).zzo;
        if (this_ != null) {
            this_.zzc();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLanguageCode(@RecentlyNonNull String languageCode) {
        Preconditions.checkNotEmpty((String)languageCode);
        Object object = this.zzh;
        synchronized (object) {
            void var1_2;
            this.zzi = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNullable
    public String getLanguageCode() {
        Object object = ((FirebaseAuth)this_).zzh;
        synchronized (object) {
            return ((FirebaseAuth)this_).zzi;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTenantId(@RecentlyNonNull String tenantId) {
        Preconditions.checkNotEmpty((String)tenantId);
        Object object = this.zzj;
        synchronized (object) {
            void var1_2;
            this.zzk = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNullable
    public String getTenantId() {
        Object object = ((FirebaseAuth)this_).zzj;
        synchronized (object) {
            return ((FirebaseAuth)this_).zzk;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void useAppLanguage() {
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = zzus.zza();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @NonNull
    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void useEmulator(@RecentlyNonNull String host, int port) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)host);
        boolean bl = var2_2 >= 0 ? var2_2 <= 65535 : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Port number must be in the range 0-65535");
        zzvw.zza(this.zza, (String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> setFirebaseUIVersion(@Nullable String firebaseUIVersion) {
        void var1_1;
        return this.zze.zzL((String)var1_1);
    }

    public final void zza(FirebaseUser firebaseUser, zzwv zzwv2, boolean bl) {
        FirebaseAuth.zzb(this, firebaseUser, zzwv2, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static void zzb(FirebaseAuth firebaseAuth, FirebaseUser firebaseUser, zzwv zzwv2, boolean bl, boolean bl2) {
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzwv2);
        boolean bl4 = firebaseAuth.zzf != null ? firebaseUser.getUid().equals(firebaseAuth.zzf.getUid()) : false;
        if (!bl4 && bl2) {
            return;
        }
        FirebaseUser firebaseUser2 = firebaseAuth.zzf;
        if (firebaseUser2 == null) {
            bl3 = true;
            bl4 = true;
        } else {
            bl3 = firebaseUser2.zze().zze().equals(zzwv2.zze()) ^ true;
            bl3 = bl4 ? bl3 : true;
            bl4 ^= true;
        }
        Preconditions.checkNotNull((Object)firebaseUser);
        List<MultiFactorInfo> list = firebaseAuth.zzf;
        if (list == null) {
            firebaseAuth.zzf = firebaseUser;
        } else {
            ((FirebaseUser)((Object)list)).zzb(firebaseUser.getProviderData());
            if (!firebaseUser.isAnonymous()) {
                firebaseAuth.zzf.zzc();
            }
            list = firebaseUser.getMultiFactor();
            list = ((MultiFactor)((Object)list)).getEnrolledFactors();
            firebaseAuth.zzf.zzi(list);
        }
        if (bl) {
            firebaseAuth.zzl.zza(firebaseAuth.zzf);
        }
        if (bl3) {
            FirebaseUser firebaseUser3 = firebaseAuth.zzf;
            if (firebaseUser3 != null) {
                firebaseUser3.zzf(zzwv2);
            }
            FirebaseAuth.zzf(firebaseAuth, firebaseAuth.zzf);
        }
        if (bl4) {
            FirebaseAuth.zzg(firebaseAuth, firebaseAuth.zzf);
        }
        if (bl) {
            firebaseAuth.zzl.zzc(firebaseUser, zzwv2);
        }
        if ((firebaseUser = firebaseAuth.zzf) != null) {
            FirebaseAuth.zze(firebaseAuth).zzb(firebaseUser.zze());
            return;
        }
    }

    public final void zzc() {
        Preconditions.checkNotNull((Object)this.zzl);
        FirebaseUser firebaseUser = this.zzf;
        if (firebaseUser != null) {
            zzbg zzbg2 = this.zzl;
            Preconditions.checkNotNull((Object)firebaseUser);
            Object[] objectArray = new Object[]{firebaseUser.getUid()};
            zzbg2.zze(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", objectArray));
            this.zzf = null;
        }
        this.zzl.zze("com.google.firebase.auth.FIREBASE_USER");
        FirebaseAuth.zzf(this, null);
        FirebaseAuth.zzg(this, null);
    }

    @VisibleForTesting
    public final synchronized zzbi zzd() {
        return FirebaseAuth.zze(this);
    }

    public static zzbi zze(FirebaseAuth firebaseAuth) {
        if (firebaseAuth.zzo == null) {
            zzbi zzbi2;
            Object object = firebaseAuth.zza;
            object = Preconditions.checkNotNull((Object)object);
            firebaseAuth.zzo = zzbi2 = new zzbi((FirebaseApp)object);
        }
        return firebaseAuth.zzo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzf(@RecentlyNonNull FirebaseAuth firebaseAuth, @Nullable FirebaseUser object) {
        String string;
        if (object != null) {
            string = ((FirebaseUser)object).getUid();
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 45);
            stringBuilder.append("Notifying id token listeners about user ( ");
            stringBuilder.append(string);
            stringBuilder.append(" ).");
            Log.d((String)"FirebaseAuth", (String)stringBuilder.toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        object = object != null ? ((FirebaseUser)object).zzh() : null;
        string = new InternalTokenResult((String)object);
        object = firebaseAuth.zzp;
        zzl zzl2 = new zzl(firebaseAuth, (InternalTokenResult)string);
        ((zzbj)object).execute(zzl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzg(@RecentlyNonNull FirebaseAuth firebaseAuth, @Nullable FirebaseUser object) {
        if (object != null) {
            object = ((FirebaseUser)object).getUid();
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 47);
            stringBuilder.append("Notifying auth state listeners about user ( ");
            stringBuilder.append((String)object);
            stringBuilder.append(" ).");
            Log.d((String)"FirebaseAuth", (String)stringBuilder.toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        object = firebaseAuth.zzp;
        zzm zzm2 = new zzm(firebaseAuth);
        ((zzbj)object).execute(zzm2);
    }

    @RecentlyNonNull
    public final Task<GetTokenResult> zzh(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            FirebaseAuth firebaseAuth = new Status(17495);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        Object object = firebaseUser.zze();
        if (((zzwv)object).zzb() && !bl) {
            return Tasks.forResult((Object)zzay.zza(((zzwv)object).zze()));
        }
        zztn zztn2 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        object = ((zzwv)object).zzd();
        zzn zzn2 = new zzn(firebaseAuth);
        return zztn2.zze(firebaseApp, firebaseUser, (String)object, zzn2);
    }

    @RecentlyNonNull
    public final Task<Void> zzi(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull AuthCredential object) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)object);
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if ("password".equals(((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).getSignInMethod())) {
                zztn zztn2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzb();
                object = ((EmailAuthCredential)((Object)object)).zzc();
                object = Preconditions.checkNotEmpty((String)object);
                String string2 = firebaseUser.getTenantId();
                zzt zzt2 = new zzt(firebaseAuth);
                return zztn2.zzs(firebaseApp, firebaseUser, string, (String)object, string2, zzt2);
            }
            if (firebaseAuth.zzK(Preconditions.checkNotEmpty((String)((EmailAuthCredential)((Object)object)).zzd()))) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
            }
            zztn zztn3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzt zzt3 = new zzt(firebaseAuth);
            return zztn3.zzu(firebaseApp, firebaseUser, (EmailAuthCredential)((Object)object), zzt3);
        }
        if (object instanceof PhoneAuthCredential) {
            zztn zztn4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            object = (PhoneAuthCredential)object;
            String string = firebaseAuth.zzk;
            zzt zzt4 = new zzt(firebaseAuth);
            return zztn4.zzx(firebaseApp, firebaseUser, (PhoneAuthCredential)object, string, zzt4);
        }
        zztn zztn5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseUser.getTenantId();
        zzt zzt5 = new zzt(firebaseAuth);
        return zztn5.zzh(firebaseApp, firebaseUser, (AuthCredential)((Object)object), string, zzt5);
    }

    @RecentlyNonNull
    public final Task<AuthResult> zzj(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull AuthCredential object) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)object);
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if ("password".equals(((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).getSignInMethod())) {
                zztn zztn2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzb();
                object = ((EmailAuthCredential)((Object)object)).zzc();
                object = Preconditions.checkNotEmpty((String)object);
                String string2 = firebaseUser.getTenantId();
                zzt zzt2 = new zzt(firebaseAuth);
                return zztn2.zzt(firebaseApp, firebaseUser, string, (String)object, string2, zzt2);
            }
            if (firebaseAuth.zzK(Preconditions.checkNotEmpty((String)((EmailAuthCredential)((Object)object)).zzd()))) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
            }
            zztn zztn3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzt zzt3 = new zzt(firebaseAuth);
            return zztn3.zzv(firebaseApp, firebaseUser, (EmailAuthCredential)((Object)object), zzt3);
        }
        if (object instanceof PhoneAuthCredential) {
            zztn zztn4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            object = (PhoneAuthCredential)object;
            String string = firebaseAuth.zzk;
            zzt zzt4 = new zzt(firebaseAuth);
            return zztn4.zzy(firebaseApp, firebaseUser, (PhoneAuthCredential)object, string, zzt4);
        }
        zztn zztn5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseUser.getTenantId();
        zzt zzt5 = new zzt(firebaseAuth);
        return zztn5.zzi(firebaseApp, firebaseUser, (AuthCredential)((Object)object), string, zzt5);
    }

    public final void zzk(@RecentlyNonNull String object, long l, @RecentlyNonNull TimeUnit object2, @RecentlyNonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @RecentlyNonNull Executor executor, boolean bl, @Nullable String string, @Nullable String string2) {
        long l2 = TimeUnit.SECONDS.convert(l, (TimeUnit)((Object)object2));
        if (l2 < 0L || l2 > 120L) {
            Object object3 = new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
            throw object3;
        }
        object2 = new zzxi((String)object, l2, bl, ((FirebaseAuth)object3).zzi, ((FirebaseAuth)object3).zzk, string, zztp.zza(), string2);
        object = super.zzJ((String)object, onVerificationStateChangedCallbacks);
        ((FirebaseAuth)object3).zze.zzk(((FirebaseAuth)object3).zza, (zzxi)object2, (PhoneAuthProvider.OnVerificationStateChangedCallbacks)object, activity, executor);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzl(@RecentlyNonNull PhoneAuthOptions object) {
        if (((PhoneAuthOptions)object).zzk()) {
            FirebaseAuth firebaseAuth = ((PhoneAuthOptions)object).zza();
            Object object2 = ((zzag)((Object)Preconditions.checkNotNull((Object)((Object)((PhoneAuthOptions)object).zzg())))).zze() ? Preconditions.checkNotEmpty((String)((PhoneAuthOptions)object).zzb()) : Preconditions.checkNotEmpty((String)((PhoneMultiFactorInfo)((Object)Preconditions.checkNotNull((Object)((Object)((PhoneAuthOptions)object).zzj())))).getUid());
            if (((PhoneAuthOptions)object).zzf() != null && zzvm.zzb((String)object2, ((PhoneAuthOptions)object).zzd(), (Activity)Preconditions.checkNotNull((Object)((PhoneAuthOptions)object).zzi()), ((PhoneAuthOptions)object).zze())) return;
            object2 = firebaseAuth.zzn;
            Object object3 = ((PhoneAuthOptions)object).zzb();
            Activity activity = ((PhoneAuthOptions)object).zzi();
            Object object4 = Preconditions.checkNotNull((Object)activity);
            Activity activity2 = (Activity)object4;
            boolean bl = zztp.zza();
            object2 = object2.zzb(firebaseAuth, (String)object3, activity2, bl);
            object3 = new zzp(firebaseAuth, (PhoneAuthOptions)object);
            object2.addOnCompleteListener((OnCompleteListener)object3);
            return;
        }
        FirebaseAuth firebaseAuth = ((PhoneAuthOptions)object).zza();
        String string = Preconditions.checkNotEmpty((String)((PhoneAuthOptions)object).zzb());
        long l = ((PhoneAuthOptions)object).zzc();
        TimeUnit timeUnit = TimeUnit.SECONDS;
        PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks = ((PhoneAuthOptions)object).zzd();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((PhoneAuthOptions)object).zzi());
        Executor executor = ((PhoneAuthOptions)object).zze();
        boolean bl = ((PhoneAuthOptions)object).zzf() != null;
        if (!bl && zzvm.zzb(string, onVerificationStateChangedCallbacks, activity, executor)) {
            return;
        }
        object = firebaseAuth.zzn;
        boolean bl2 = zztp.zza();
        object = ((zzf)object).zzb(firebaseAuth, string, activity, bl2);
        zzo zzo2 = new zzo(firebaseAuth, string, l, timeUnit, onVerificationStateChangedCallbacks, activity, executor, bl);
        object.addOnCompleteListener((OnCompleteListener)zzo2);
    }

    private final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzJ(@Nullable String object, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        if (this.zzg.zzc() && object != null && ((String)object).equals(this.zzg.zza())) {
            object = new zzq(this, onVerificationStateChangedCallbacks);
            return object;
        }
        return onVerificationStateChangedCallbacks;
    }

    public final Task<Void> zzm(FirebaseUser firebaseUser, zzbk zzbk2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zzJ(this.zza, firebaseUser, zzbk2);
    }

    @RecentlyNonNull
    public final Task<AuthResult> zzn(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        authCredential = authCredential.zza();
        zzt zzt2 = new zzt(this);
        return zztn2.zzH(firebaseApp, firebaseUser, authCredential, zzt2);
    }

    @RecentlyNonNull
    public final Task<AuthResult> zzo(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzI(firebaseApp, firebaseUser, string, zzt2);
    }

    @RecentlyNonNull
    public final Task<Void> zzp(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzl(firebaseApp, firebaseUser, userProfileChangeRequest, zzt2);
    }

    @RecentlyNonNull
    public final Task<Void> zzq(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzm(firebaseApp, firebaseUser, string, zzt2);
    }

    @RecentlyNonNull
    public final Task<Void> zzr(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        phoneAuthCredential = phoneAuthCredential.zzi();
        zzt zzt2 = new zzt(this);
        return zztn2.zzo(firebaseApp, firebaseUser, phoneAuthCredential, zzt2);
    }

    @RecentlyNonNull
    public final Task<Void> zzs(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzn(firebaseApp, firebaseUser, string, zzt2);
    }

    @RecentlyNonNull
    public final Task<Void> zzt(@Nullable ActionCodeSettings actionCodeSettings, @RecentlyNonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzi != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zza();
            }
            actionCodeSettings.zzc(this.zzi);
        }
        return this.zze.zzC(this.zza, actionCodeSettings, string);
    }

    @RecentlyNonNull
    public final Task<Void> zzu(@RecentlyNonNull FirebaseUser task, @RecentlyNonNull String object) {
        Preconditions.checkNotNull((Object)task);
        Preconditions.checkNotEmpty((String)object);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        task = zztn2.zzQ(firebaseApp, (FirebaseUser)task, (String)object, zzt2);
        object = new com.google.firebase.auth.zzr(this);
        return task.continueWithTask((Continuation)object);
    }

    public final Task<AuthResult> zzv(MultiFactorAssertion multiFactorAssertion, zzag object, @Nullable FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        Preconditions.checkNotNull((Object)object);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        multiFactorAssertion = (PhoneMultiFactorAssertion)multiFactorAssertion;
        object = object.zzd();
        object = Preconditions.checkNotEmpty((String)object);
        zzs zzs2 = new zzs(this);
        return zztn2.zzP(firebaseApp, firebaseUser, (PhoneMultiFactorAssertion)multiFactorAssertion, (String)object, zzs2);
    }

    @RecentlyNonNull
    public final Task<AuthResult> zzw(@RecentlyNonNull Activity activity, @RecentlyNonNull FederatedAuthProvider federatedAuthProvider, @RecentlyNonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzj(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, firebaseAuth, firebaseUser)) {
            FirebaseAuth firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzc(activity.getApplicationContext(), firebaseAuth, firebaseUser);
        federatedAuthProvider.zzb(activity);
        return taskCompletionSource.getTask();
    }

    @RecentlyNonNull
    public final Task<AuthResult> zzx(@RecentlyNonNull Activity activity, @RecentlyNonNull FederatedAuthProvider federatedAuthProvider, @RecentlyNonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzj(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, firebaseAuth, firebaseUser)) {
            FirebaseAuth firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzc(activity.getApplicationContext(), firebaseAuth, firebaseUser);
        federatedAuthProvider.zzc(activity);
        return taskCompletionSource.getTask();
    }

    @RecentlyNonNull
    public final Task<Void> zzy(@RecentlyNonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        zztn zztn2 = this.zze;
        zzi zzi2 = new zzi(this, firebaseUser);
        return zztn2.zzK(firebaseUser, zzi2);
    }

    @RecentlyNonNull
    public final Task<Void> zzz(@RecentlyNonNull String string, @RecentlyNonNull String string2, @Nullable ActionCodeSettings actionCodeSettings) {
        String string3;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zza();
        }
        if ((string3 = this.zzi) != null) {
            actionCodeSettings.zzc(string3);
        }
        return this.zze.zzR(string, string2, actionCodeSettings);
    }

    @RecentlyNonNull
    public final Task<Void> zzA(@RecentlyNonNull FirebaseUser firebaseUser, @RecentlyNonNull MultiFactorAssertion multiFactorAssertion, @Nullable String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        if (multiFactorAssertion instanceof PhoneMultiFactorAssertion) {
            zztn zztn2 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            multiFactorAssertion = (PhoneMultiFactorAssertion)multiFactorAssertion;
            zzs zzs2 = new zzs(firebaseAuth);
            return zztn2.zzN(firebaseApp, (PhoneMultiFactorAssertion)multiFactorAssertion, firebaseUser, string, zzs2);
        }
        FirebaseAuth firebaseAuth = new Status(17499);
        return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
    }

    private final boolean zzK(String object) {
        return (object = ActionCodeUrl.parseLink((String)object)) != null && !TextUtils.equals((CharSequence)this.zzk, (CharSequence)((ActionCodeUrl)object).zza());
    }

    static /* synthetic */ List zzB(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    static /* synthetic */ List zzC(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* synthetic */ List zzD(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzd;
    }

    static /* synthetic */ PhoneAuthProvider.OnVerificationStateChangedCallbacks zzE(FirebaseAuth firebaseAuth, String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        return firebaseAuth.zzJ(string, onVerificationStateChangedCallbacks);
    }

    static /* synthetic */ String zzF(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzi;
    }

    static /* synthetic */ zztn zzG(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zze;
    }

    static /* synthetic */ zzw zzH(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzg;
    }

    static /* synthetic */ FirebaseUser zzI(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzf;
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@RecentlyNonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@RecentlyNonNull FirebaseAuth var1);
    }
}

