/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import com.google.android.gms.internal.firebase-auth-api.zzaae;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzai;
import com.google.android.gms.internal.firebase-auth-api.zzaq;
import com.google.android.gms.internal.firebase-auth-api.zzaw;
import com.google.android.gms.internal.firebase-auth-api.zzax;
import com.google.android.gms.internal.firebase-auth-api.zzay;
import com.google.android.gms.internal.firebase-auth-api.zzdu;
import com.google.android.gms.internal.firebase-auth-api.zzdx;
import com.google.android.gms.internal.firebase-auth-api.zzdy;
import com.google.android.gms.internal.firebase-auth-api.zzdz;
import com.google.android.gms.internal.firebase-auth-api.zzij;
import com.google.android.gms.internal.firebase-auth-api.zzli;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.KeyGenerator;

public final class zzdt {
    private zzay zza = null;
    private String zzb = null;
    private zzag zzc = null;
    private zzaq zzd = null;
    @GuardedBy(value="this")
    private zzax zze;
    private zzdy zzf = null;

    static /* synthetic */ zzag zza(zzdt zzdt2) {
        return zzdt2.zzc;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final zzag zzh() throws GeneralSecurityException {
        Object[] objectArray;
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)zzdu.zzb(), (String)"Android Keystore requires at least Android M");
            return null;
        }
        Object[] objectArray2 = new zzdx();
        boolean bl = objectArray2.zzc(((zzdt)object).zzb);
        if (!bl) {
            objectArray = ((zzdt)object).zzb;
            zzdx zzdx2 = new zzdx();
            boolean bl2 = zzdx2.zzc((String)objectArray);
            if (bl2) {
                objectArray2 = new Object[]{objectArray};
                Object object = new IllegalArgumentException(String.format("cannot generate a new key %s because it already exists; please delete it with deleteKey() and try again", objectArray2));
                throw object;
            }
            objectArray = zzli.zza("android-keystore://", (String)objectArray);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            String[] stringArray = new KeyGenParameterSpec.Builder((String)objectArray, 3);
            objectArray = stringArray.setKeySize(256);
            stringArray = new String[]{"GCM"};
            objectArray = objectArray.setBlockModes(stringArray);
            stringArray = new String[]{"NoPadding"};
            keyGenerator.init((AlgorithmParameterSpec)objectArray.setEncryptionPaddings(stringArray).build());
            keyGenerator.generateKey();
        }
        return objectArray2.zza(((zzdt)object).zzb);
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zzdu.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            if (bl) {
                objectArray = new Object[]{((zzdt)object).zzb};
                KeyStoreException keyStoreException = new KeyStoreException(String.format("the master key %s exists but is unusable", objectArray), exception);
                throw keyStoreException;
            }
            Log.w((String)zzdu.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
    }

    static /* synthetic */ zzax zzb(zzdt zzdt2) {
        return zzdt2.zze;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final zzax zzi() throws GeneralSecurityException, IOException {
        zzag zzag2 = this.zzc;
        if (zzag2 == null) return zzax.zzf(zzai.zzb(this.zzf));
        try {
            zzdy zzdy2 = this.zzf;
            return zzax.zzf(zzaw.zzi(zzdy2, zzag2));
        }
        catch (zzaae | GeneralSecurityException exception) {
            Log.w((String)zzdu.zzb(), (String)"cannot decrypt keyset: ", (Throwable)exception);
            return zzax.zzf(zzai.zzb(this.zzf));
        }
    }

    static /* synthetic */ zzay zzc(zzdt zzdt2) {
        return zzdt2.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public final zzdt zzd(zzij object) {
        int n;
        String string = ((zzij)object).zzf();
        byte[] byArray = ((zzij)object).zze().zzs();
        object = ((zzij)object).zzd();
        switch (((Enum)object).ordinal()) {
            case 1: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                Object object2 = new IllegalArgumentException("Unknown output prefix type");
                throw object2;
            }
            case 2: {
                n = 2;
            }
        }
        ((zzdt)object2).zzd = zzaq.zze(string, byArray, n);
        return object2;
    }

    public final zzdt zze(String string) {
        if (!string.startsWith("android-keystore://")) {
            Object object = new IllegalArgumentException("key URI must start with android-keystore://");
            throw object;
        }
        ((zzdt)object).zzb = string;
        return object;
    }

    public final zzdt zzf(Context context, String string, String string2) throws IOException {
        if (context == null) {
            Object object = new IllegalArgumentException("need an Android context");
            throw object;
        }
        string = "GenericIdpKeyset";
        Object object = new zzdy(context, string, string2);
        ((zzdt)object).zzf = object;
        ((zzdt)object).zza = object = new zzdz(context, string, string2);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized zzdu zzg() throws GeneralSecurityException, IOException {
        Object object;
        if (((zzdt)object2).zzb != null) {
            ((zzdt)object2).zzc = ((zzdt)object2).zzh();
        }
        try {
            object = ((zzdt)object2).zzi();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.i((String)zzdu.zzb(), (String)"keyset not found, will generate a new one", (Throwable)fileNotFoundException);
            if (((zzdt)object2).zzd == null) {
                Object object2 = new GeneralSecurityException("cannot read or generate keyset");
                throw object2;
            }
            object = zzax.zze();
            ((zzax)object).zzc(((zzdt)object2).zzd);
            ((zzax)object).zzd(((zzax)object).zzb().zzd().zzb(0).zza());
            if (((zzdt)object2).zzc != null) {
                ((zzax)object).zzb().zzg(((zzdt)object2).zza, ((zzdt)object2).zzc);
            }
            zzai.zza(((zzax)object).zzb(), ((zzdt)object2).zza);
        }
        ((zzdt)object2).zze = object;
        return new zzdu((zzdt)object2, null);
    }
}

