/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzjw;
import com.google.android.gms.internal.firebase-auth-api.zzjx;
import com.google.android.gms.internal.firebase-auth-api.zzli;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzjy
implements zzag {
    private static final ThreadLocal<Cipher> zza;
    private static final ThreadLocal<Cipher> zzb;
    private final byte[] zzc;
    private final byte[] zzd;
    private final SecretKeySpec zze;
    private final int zzf;

    static {
        ThreadLocal threadLocal;
        zza = threadLocal = new zzjw();
        zzb = threadLocal = new zzjx();
    }

    public zzjy(byte[] object, int n) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        if (n != 12 && n != 16) {
            Object object2 = new IllegalArgumentException("IV size should be either 12 or 16 bytes");
            throw object2;
        }
        ((zzjy)object2).zzf = n;
        zzli.zzb(((byte[])object).length);
        ((zzjy)object2).zze = secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        object = zza.get();
        ((Cipher)object).init(1, ((zzjy)object2).zze);
        ((zzjy)object2).zzc = zzjy.zzc(((Cipher)object).doFinal(new byte[16]));
        ((zzjy)object2).zzd = zzjy.zzc(((zzjy)object2).zzc);
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Object object;
        int n = byArray.length;
        int n2 = n - ((zzjy)object).zzf + -16;
        if (n2 < 0) {
            object = new GeneralSecurityException("ciphertext too short");
            throw object;
        }
        Object object2 = zza.get();
        ((Cipher)object2).init(1, ((zzjy)object).zze);
        byte[] byArray3 = super.zzd((Cipher)object2, 0, byArray, 0, ((zzjy)object).zzf);
        byte[] byArray4 = super.zzd((Cipher)object2, 1, byArray2, 0, byArray2.length);
        object2 = super.zzd((Cipher)object2, 2, byArray, ((zzjy)object).zzf, n2);
        int n3 = n + -16;
        int n4 = 0;
        for (n = 0; n < 16; ++n) {
            n4 = (byte)(n4 | byArray[n3 + n] ^ byArray4[n] ^ byArray3[n] ^ object2[n]);
        }
        if (n4 != 0) {
            object = new AEADBadTagException("tag mismatch");
            throw object;
        }
        Cipher cipher = zzb.get();
        SecretKeySpec secretKeySpec = ((zzjy)object).zze;
        object2 = new IvParameterSpec(byArray3);
        cipher.init(1, (Key)secretKeySpec, (AlgorithmParameterSpec)object2);
        return cipher.doFinal(byArray, ((zzjy)object).zzf, n2);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        throw null;
    }

    private static byte[] zzc(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            int n2 = n + 1;
            byArray2[n] = (byte)((by + by ^ (byArray[n2] & 0xFF) >>> 7) & 0xFF);
            n = n2;
        }
        n = byArray[15];
        byArray2[15] = (byte)(n + n ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] zzd(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzjy.zze(byArray2, ((zzjy)object).zzc));
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                byArray3[i] = (byte)(byArray3[i] ^ byArray[n2 + n4 + i]);
            }
            byArray3 = cipher.doFinal(byArray3);
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            object = zzjy.zze(byArray, ((zzjy)object).zzc);
            return cipher.doFinal(zzjy.zze(byArray3, (byte[])object));
        }
        byte[] byArray4 = Arrays.copyOf(((zzjy)object).zzd, 16);
        for (int i = 0; i < (n3 = byArray.length); ++i) {
            byArray4[i] = (byte)(byArray4[i] ^ byArray[i]);
        }
        byArray4[n3] = (byte)(byArray4[n3] ^ 0x80);
        object = byArray4;
        return cipher.doFinal(zzjy.zze(byArray3, (byte[])object));
    }

    private static byte[] zze(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }
}

