/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebaseNetworkException;
import com.google.firebase.FirebaseTooManyRequestsException;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuthActionCodeException;
import com.google.firebase.auth.FirebaseAuthEmailException;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthRecentLoginRequiredException;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.FirebaseAuthWeakPasswordException;
import com.google.firebase.auth.FirebaseAuthWebException;
import com.google.firebase.auth.zzae;
import com.google.firebase.auth.zzaf;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;

public final class zzaaj {
    @VisibleForTesting
    static final SparseArray zza = new SparseArray();
    public static final /* synthetic */ int zzb;

    public static FirebaseException zza(Status object) {
        int n = object.getStatusCode();
        String string = zzaaj.zzd(zzaaj.zze(n), object);
        switch (n) {
            default: {
                return new FirebaseException("An internal error has occurred.");
            }
            case 17499: {
                object = zzaaj.zzd("An internal error has occurred.", object);
                return new FirebaseException((String)object);
            }
            case 17495: {
                object = zzaaj.zzd("Please sign in before trying to get a token.", object);
                return new FirebaseNoSignedInUserException((String)object);
            }
            case 17200: {
                return new zzaf(zzaaj.zzc(n), string);
            }
            case 17063: 
            case 17080: {
                return new FirebaseApiNotAvailableException(string);
            }
            case 17061: {
                object = zzaaj.zzd("There was a failure in the connection between the web widget and the Firebase Auth backend.", object);
                return new FirebaseNetworkException((String)object);
            }
            case 17057: 
            case 17058: 
            case 17062: 
            case 17065: {
                return new FirebaseAuthWebException(zzaaj.zzc(n), string);
            }
            case 17056: {
                return new zzae(zzaaj.zzc(n), string);
            }
            case 17052: {
                return new FirebaseTooManyRequestsException(string);
            }
            case 17031: 
            case 17032: 
            case 17033: {
                return new FirebaseAuthEmailException(zzaaj.zzc(n), string);
            }
            case 17029: 
            case 17030: {
                return new FirebaseAuthActionCodeException(zzaaj.zzc(n), string);
            }
            case 17026: {
                return new FirebaseAuthWeakPasswordException(zzaaj.zzc(n), string, object.getStatusMessage());
            }
            case 17020: {
                object = zzaaj.zzd("A network error (such as timeout, interrupted connection or unreachable host) has occurred.", object);
                return new FirebaseNetworkException((String)object);
            }
            case 17016: {
                object = zzaaj.zzd("User was not linked to an account with the given provider.", object);
                return new FirebaseException((String)object);
            }
            case 17015: {
                object = zzaaj.zzd("User has already been linked to the given provider.", object);
                return new FirebaseException((String)object);
            }
            case 17014: {
                return new FirebaseAuthRecentLoginRequiredException(zzaaj.zzc(n), string);
            }
            case 17010: {
                object = zzaaj.zzd("We have blocked all requests from this device due to unusual activity. Try again later.", object);
                return new FirebaseTooManyRequestsException((String)object);
            }
            case 17007: 
            case 17012: 
            case 17025: {
                return new FirebaseAuthUserCollisionException(zzaaj.zzc(n), string);
            }
            case 17006: 
            case 17028: 
            case 17040: 
            case 17064: 
            case 17068: 
            case 17071: 
            case 17072: 
            case 17073: 
            case 17074: 
            case 17079: 
            case 17085: 
            case 17086: 
            case 17087: 
            case 17088: 
            case 17089: 
            case 17090: 
            case 17091: 
            case 17093: 
            case 17095: 
            case 17096: 
            case 17201: 
            case 17202: 
            case 17203: 
            case 17204: 
            case 17205: 
            case 17206: 
            case 17207: 
            case 18001: 
            case 18002: {
                return new FirebaseAuthException(zzaaj.zzc(n), string);
            }
            case 17005: 
            case 17011: 
            case 17017: 
            case 17021: {
                return new FirebaseAuthInvalidUserException(zzaaj.zzc(n), string);
            }
            case 17000: 
            case 17002: 
            case 17004: 
            case 17008: 
            case 17009: 
            case 17024: 
            case 17034: 
            case 17035: 
            case 17041: 
            case 17042: 
            case 17043: 
            case 17044: 
            case 17045: 
            case 17046: 
            case 17049: 
            case 17051: 
            case 17075: 
            case 17077: 
            case 17081: 
            case 17082: 
            case 17083: 
            case 17084: 
            case 17094: 
        }
        return new FirebaseAuthInvalidCredentialsException(zzaaj.zzc(n), string);
    }

    public static FirebaseException zzb(Status object, AuthCredential authCredential, @Nullable String string, @Nullable String string2) {
        int n = object.getStatusCode();
        if (n == 17012 || n == 17007 || n == 17025) {
            object = zzaaj.zzd(zzaaj.zze(n), object);
            FirebaseAuthUserCollisionException firebaseAuthUserCollisionException = new FirebaseAuthUserCollisionException(zzaaj.zzc(n), (String)object);
            firebaseAuthUserCollisionException.zza(authCredential);
            firebaseAuthUserCollisionException.zzb(string);
            firebaseAuthUserCollisionException.zzc(string2);
            return firebaseAuthUserCollisionException;
        }
        return zzaaj.zza(object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String zzc(int n) {
        void var0_3;
        Pair pair = (Pair)zza.get(n);
        if (pair == null) return var0_3;
        String string = (String)pair.first;
        return var0_3;
    }

    private static String zzd(String objectArray, Status status) {
        if (TextUtils.isEmpty((CharSequence)status.getStatusMessage())) {
            return objectArray;
        }
        String string = String.valueOf(objectArray);
        objectArray = new Object[]{status.getStatusMessage()};
        return String.format(string.concat(" [ %s ]"), objectArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String zze(int n) {
        void var0_3;
        Pair pair = (Pair)zza.get(n);
        if (pair == null) return var0_3;
        String string = (String)pair.second;
        return var0_3;
    }

    static {
        zza.put(17000, (Object)new Pair((Object)"ERROR_INVALID_CUSTOM_TOKEN", (Object)"The custom token format is incorrect. Please check the documentation."));
        zza.put(17002, (Object)new Pair((Object)"ERROR_CUSTOM_TOKEN_MISMATCH", (Object)"The custom token corresponds to a different audience."));
        zza.put(17004, (Object)new Pair((Object)"ERROR_INVALID_CREDENTIAL", (Object)"The supplied auth credential is malformed or has expired."));
        zza.put(17008, (Object)new Pair((Object)"ERROR_INVALID_EMAIL", (Object)"The email address is badly formatted."));
        zza.put(17009, (Object)new Pair((Object)"ERROR_WRONG_PASSWORD", (Object)"The password is invalid or the user does not have a password."));
        zza.put(17024, (Object)new Pair((Object)"ERROR_USER_MISMATCH", (Object)"The supplied credentials do not correspond to the previously signed in user."));
        zza.put(17014, (Object)new Pair((Object)"ERROR_REQUIRES_RECENT_LOGIN", (Object)"This operation is sensitive and requires recent authentication. Log in again before retrying this request."));
        zza.put(17012, (Object)new Pair((Object)"ERROR_ACCOUNT_EXISTS_WITH_DIFFERENT_CREDENTIAL", (Object)"An account already exists with the same email address but different sign-in credentials. Sign in using a provider associated with this email address."));
        zza.put(17007, (Object)new Pair((Object)"ERROR_EMAIL_ALREADY_IN_USE", (Object)"The email address is already in use by another account."));
        zza.put(17025, (Object)new Pair((Object)"ERROR_CREDENTIAL_ALREADY_IN_USE", (Object)"This credential is already associated with a different user account."));
        zza.put(17005, (Object)new Pair((Object)"ERROR_USER_DISABLED", (Object)"The user account has been disabled by an administrator."));
        zza.put(17021, (Object)new Pair((Object)"ERROR_USER_TOKEN_EXPIRED", (Object)"The user's credential is no longer valid. The user must sign in again."));
        zza.put(17011, (Object)new Pair((Object)"ERROR_USER_NOT_FOUND", (Object)"There is no user record corresponding to this identifier. The user may have been deleted."));
        zza.put(17017, (Object)new Pair((Object)"ERROR_INVALID_USER_TOKEN", (Object)"This user's credential isn't valid for this project. This can happen if the user's token has been tampered with, or if the user isn't for the project associated with this API key."));
        zza.put(17006, (Object)new Pair((Object)"ERROR_OPERATION_NOT_ALLOWED", (Object)"The given sign-in provider is disabled for this Firebase project. Enable it in the Firebase console, under the sign-in method tab of the Auth section."));
        zza.put(17026, (Object)new Pair((Object)"ERROR_WEAK_PASSWORD", (Object)"The given password is invalid."));
        zza.put(17029, (Object)new Pair((Object)"ERROR_EXPIRED_ACTION_CODE", (Object)"The out of band code has expired."));
        zza.put(17030, (Object)new Pair((Object)"ERROR_INVALID_ACTION_CODE", (Object)"The out of band code is invalid. This can happen if the code is malformed, expired, or has already been used."));
        zza.put(17031, (Object)new Pair((Object)"ERROR_INVALID_MESSAGE_PAYLOAD", (Object)"The email template corresponding to this action contains invalid characters in its message. Please fix by going to the Auth email templates section in the Firebase Console."));
        zza.put(17033, (Object)new Pair((Object)"ERROR_INVALID_RECIPIENT_EMAIL", (Object)"The email corresponding to this action failed to send as the provided recipient email address is invalid."));
        zza.put(17032, (Object)new Pair((Object)"ERROR_INVALID_SENDER", (Object)"The email template corresponding to this action contains an invalid sender email or name. Please fix by going to the Auth email templates section in the Firebase Console."));
        zza.put(17034, (Object)new Pair((Object)"ERROR_MISSING_EMAIL", (Object)"An email address must be provided."));
        zza.put(17035, (Object)new Pair((Object)"ERROR_MISSING_PASSWORD", (Object)"A password must be provided."));
        zza.put(17041, (Object)new Pair((Object)"ERROR_MISSING_PHONE_NUMBER", (Object)"To send verification codes, provide a phone number for the recipient."));
        zza.put(17042, (Object)new Pair((Object)"ERROR_INVALID_PHONE_NUMBER", (Object)"The format of the phone number provided is incorrect. Please enter the phone number in a format that can be parsed into E.164 format. E.164 phone numbers are written in the format [+][country code][subscriber number including area code]."));
        zza.put(17043, (Object)new Pair((Object)"ERROR_MISSING_VERIFICATION_CODE", (Object)"The verification code from SMS/TOTP is empty. Please enter the verification code."));
        zza.put(17044, (Object)new Pair((Object)"ERROR_INVALID_VERIFICATION_CODE", (Object)"The verification code from SMS/TOTP is invalid. Please check and enter the correct verification code again."));
        zza.put(17045, (Object)new Pair((Object)"ERROR_MISSING_VERIFICATION_ID", (Object)"The Phone Auth Credential was created with an empty verification ID"));
        zza.put(17046, (Object)new Pair((Object)"ERROR_INVALID_VERIFICATION_ID", (Object)"The verification ID used to create the phone auth credential is invalid."));
        zza.put(17049, (Object)new Pair((Object)"ERROR_RETRY_PHONE_AUTH", (Object)"An error occurred during authentication using the PhoneAuthCredential. Please retry authentication."));
        zza.put(17051, (Object)new Pair((Object)"ERROR_SESSION_EXPIRED", (Object)"The sms code has expired. Please re-send the verification code to try again."));
        zza.put(17052, (Object)new Pair((Object)"ERROR_QUOTA_EXCEEDED", (Object)"This project's quota for this operation has been exceeded."));
        zza.put(17028, (Object)new Pair((Object)"ERROR_APP_NOT_AUTHORIZED", (Object)"This app is not authorized to use Firebase Authentication. Please verify that the correct package name and SHA-1 are configured in the Firebase Console."));
        zza.put(17063, (Object)new Pair((Object)"ERROR_API_NOT_AVAILABLE_WITHOUT_GOOGLE_PLAY", (Object)"The API that you are calling is not available on devices without Google Play services."));
        zza.put(17062, (Object)new Pair((Object)"ERROR_WEB_INTERNAL_ERROR", (Object)"There was an internal error in the web widget."));
        zza.put(17064, (Object)new Pair((Object)"ERROR_INVALID_CERT_HASH", (Object)"There was an error while trying to get your package certificate hash."));
        zza.put(17065, (Object)new Pair((Object)"ERROR_WEB_STORAGE_UNSUPPORTED", (Object)"This browser is not supported or 3rd party cookies and data may be disabled."));
        zza.put(17040, (Object)new Pair((Object)"ERROR_MISSING_CONTINUE_URI", (Object)"A continue URL must be provided in the request."));
        zza.put(17068, (Object)new Pair((Object)"ERROR_DYNAMIC_LINK_NOT_ACTIVATED", (Object)"Please activate Dynamic Links in the Firebase Console and agree to the terms and conditions."));
        zza.put(17071, (Object)new Pair((Object)"ERROR_INVALID_PROVIDER_ID", (Object)"The provider ID provided for the attempted web operation is invalid."));
        zza.put(17057, (Object)new Pair((Object)"ERROR_WEB_CONTEXT_ALREADY_PRESENTED", (Object)"A headful operation is already in progress. Please wait for that to finish."));
        zza.put(17058, (Object)new Pair((Object)"ERROR_WEB_CONTEXT_CANCELED", (Object)"The web operation was canceled by the user."));
        zza.put(17072, (Object)new Pair((Object)"ERROR_TENANT_ID_MISMATCH", (Object)"The provided tenant ID does not match the Auth instance's tenant ID."));
        zza.put(17073, (Object)new Pair((Object)"ERROR_UNSUPPORTED_TENANT_OPERATION", (Object)"This operation is not supported in a multi-tenant context."));
        zza.put(17074, (Object)new Pair((Object)"ERROR_INVALID_DYNAMIC_LINK_DOMAIN", (Object)"The provided dynamic link domain is not configured or authorized for the current project."));
        zza.put(17075, (Object)new Pair((Object)"ERROR_REJECTED_CREDENTIAL", (Object)"The request contains malformed or mismatching credentials"));
        zza.put(17077, (Object)new Pair((Object)"ERROR_PHONE_NUMBER_NOT_FOUND", (Object)"The provided phone number does not match any of the second factor phone numbers associated with this user."));
        zza.put(17079, (Object)new Pair((Object)"ERROR_INVALID_TENANT_ID", (Object)"The Auth instance's tenant ID is invalid."));
        zza.put(17078, (Object)new Pair((Object)"ERROR_SECOND_FACTOR_REQUIRED", (Object)"Please complete a second factor challenge to finish signing into this account."));
        zza.put(17080, (Object)new Pair((Object)"ERROR_API_NOT_AVAILABLE", (Object)"The API that you are calling is not available."));
        zza.put(17081, (Object)new Pair((Object)"ERROR_MISSING_MULTI_FACTOR_SESSION", (Object)"The request is missing proof of first factor successful sign-in."));
        zza.put(17082, (Object)new Pair((Object)"ERROR_MISSING_MULTI_FACTOR_INFO", (Object)"No second factor identifier is provided."));
        zza.put(17083, (Object)new Pair((Object)"ERROR_INVALID_MULTI_FACTOR_SESSION", (Object)"The request does not contain a valid proof of first factor successful sign-in."));
        zza.put(17084, (Object)new Pair((Object)"ERROR_MULTI_FACTOR_INFO_NOT_FOUND", (Object)"The user does not have a second factor matching the identifier provided."));
        zza.put(17085, (Object)new Pair((Object)"ERROR_ADMIN_RESTRICTED_OPERATION", (Object)"This operation is restricted to administrators only."));
        zza.put(17086, (Object)new Pair((Object)"ERROR_UNVERIFIED_EMAIL", (Object)"This operation requires a verified email."));
        zza.put(17087, (Object)new Pair((Object)"ERROR_SECOND_FACTOR_ALREADY_ENROLLED", (Object)"The second factor is already enrolled on this account."));
        zza.put(17088, (Object)new Pair((Object)"ERROR_MAXIMUM_SECOND_FACTOR_COUNT_EXCEEDED", (Object)"The maximum allowed number of second factors on a user has been exceeded."));
        zza.put(17089, (Object)new Pair((Object)"ERROR_UNSUPPORTED_FIRST_FACTOR", (Object)"Enrolling a second factor or signing in with a multi-factor account requires sign-in with a supported first factor."));
        zza.put(17090, (Object)new Pair((Object)"ERROR_EMAIL_CHANGE_NEEDS_VERIFICATION", (Object)"Multi-factor users must always have a verified email."));
        zza.put(17091, (Object)new Pair((Object)"ERROR_INTERNAL_SUCCESS_SIGN_OUT", (Object)"This is an internal error code indicating that the operation was successful but the user needs to be signed out."));
        zza.put(17093, (Object)new Pair((Object)"ERROR_MISSING_CLIENT_IDENTIFIER", (Object)"This request is missing a valid app identifier, meaning that Play Integrity checks, SafetyNet checks, and reCAPTCHA checks were unsuccessful. Please try again, or check the logcat for more details."));
        zza.put(18002, (Object)new Pair((Object)"ERROR_ALTERNATE_CLIENT_IDENTIFIER_REQUIRED", (Object)"This request contains an app identifier which could not be verified. Please try again with a different identifier(like Recaptcha). Check the logcat for more details."));
        zza.put(17094, (Object)new Pair((Object)"ERROR_MISSING_OR_INVALID_NONCE", (Object)"The request does not contain a valid nonce. This can occur if the SHA-256 hash of the provided raw nonce does not match the hashed nonce in the ID token payload."));
        zza.put(18001, (Object)new Pair((Object)"ERROR_USER_CANCELLED", (Object)"The user did not grant your application the permissions it requested."));
        zza.put(17095, (Object)new Pair((Object)"ERROR_UNSUPPORTED_PASSTHROUGH_OPERATION", (Object)"This operation is not supported while in passthrough mode."));
        zza.put(17096, (Object)new Pair((Object)"ERROR_TOKEN_REFRESH_UNAVAILABLE", (Object)"No refresh token is available."));
        zza.put(17201, (Object)new Pair((Object)"ERROR_MISSING_RECAPTCHA_TOKEN", (Object)"The request is missing a ReCAPTCHA token."));
        zza.put(17202, (Object)new Pair((Object)"ERROR_INVALID_RECAPTCHA_TOKEN", (Object)"The request contains an invalid ReCAPTCHA token."));
        zza.put(17203, (Object)new Pair((Object)"ERROR_INVALID_RECAPTCHA_ACTION", (Object)"The request contains an invalid ReCAPTCHA action."));
        zza.put(17200, (Object)new Pair((Object)"ERROR_RECAPTCHA_NOT_ENABLED", (Object)"ReCAPTCHA is not enabled."));
        zza.put(17204, (Object)new Pair((Object)"ERROR_MISSING_CLIENT_TYPE", (Object)"The request is missing the ReCAPTCHA client type."));
        zza.put(17205, (Object)new Pair((Object)"ERROR_MISSING_RECAPTCHA_VERSION", (Object)"The request is missing the ReCAPTCHA version."));
        zza.put(17206, (Object)new Pair((Object)"ERROR_INVALID_RECAPTCHA_VERSION", (Object)"The request contains an invalid ReCAPTCHA version."));
        zza.put(17207, (Object)new Pair((Object)"ERROR_INVALID_REQ_TYPE", (Object)"The request is invalid. This can occur if input parameters are missing or malformed."));
        zza.put(17056, (Object)new Pair((Object)"ERROR_CAPTCHA_CHECK_FAILED", (Object)"The ReCAPTCHA assessment failed for this request."));
    }
}

