/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase-auth-api.zzaau;
import com.google.android.gms.internal.firebase-auth-api.zzadh;
import com.google.android.gms.internal.firebase-auth-api.zzvz;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzadg
extends AbstractSafeParcelable
implements zzaau<zzadg> {
    private static final String zza = zzadg.class.getSimpleName();
    public static final Parcelable.Creator<zzadg> CREATOR = new zzadh();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzc;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzd;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zze;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzf;

    public final long zzb() {
        Long l = ((zzadg)((Object)l)).zzd;
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public final long zzc() {
        return this.zzf;
    }

    public static zzadg zzd(String object) {
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            ((zzadg)object)();
            ((zzadg)object).zzb = jSONObject.optString("refresh_token", null);
            ((zzadg)object).zzc = jSONObject.optString("access_token", null);
            ((zzadg)object).zzd = jSONObject.optLong("expires_in");
            ((zzadg)object).zze = jSONObject.optString("token_type", null);
            ((zzadg)object).zzf = jSONObject.optLong("issued_at");
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zzvz(jSONException);
        }
        return object;
    }

    public final String zze() {
        return this.zzc;
    }

    public final String zzf() {
        return this.zzb;
    }

    @Nullable
    public final String zzg() {
        return this.zze;
    }

    public final String zzh() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)((zzadg)((Object)string)).zzb);
            jSONObject.put("access_token", (Object)((zzadg)((Object)string)).zzc);
            jSONObject.put("expires_in", (Object)((zzadg)((Object)string)).zzd);
            jSONObject.put("token_type", (Object)((zzadg)((Object)string)).zze);
            jSONObject.put("issued_at", (Object)((zzadg)((Object)string)).zzf);
            String string = jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to convert GetTokenResponse to JSON");
            throw new zzvz(jSONException);
        }
        return string;
    }

    public zzadg() {
        this.zzf = System.currentTimeMillis();
    }

    public zzadg(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzadg(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzb = string;
        this.zzc = string2;
        this.zzd = l;
        this.zze = string3;
        this.zzf = l2;
    }

    public final void zzi(String string) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel, (int)4, (Long)this.zzb(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.zze, (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)this.zzf, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean zzj() {
        long l = this.zzf + this.zzd * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }
}

