/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzdf;
import com.google.android.gms.internal.firebase-auth-api.zzdh;
import com.google.android.gms.internal.firebase-auth-api.zzdi;
import com.google.android.gms.internal.firebase-auth-api.zzdk;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import javax.annotation.Nullable;

public final class zzdg {
    @Nullable
    private Integer zza = null;
    @Nullable
    private Integer zzb = null;
    @Nullable
    private Integer zzc = null;
    private zzdh zzd = null;
    private zzdi zze;

    public final zzdg zza(int n) throws GeneralSecurityException {
        if (n != 16 && n != 24 && n != 32) {
            Object[] objectArray = new Object[]{n};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size %d; only 16-byte, 24-byte and 32-byte AES keys are supported", objectArray));
        }
        objectArray.zza = n;
        return objectArray;
    }

    public final zzdg zzb(zzdh zzdh2) {
        this.zzd = zzdh2;
        return this;
    }

    public final zzdg zzc(int n) throws GeneralSecurityException {
        if (n < 16) {
            Object[] objectArray = new Object[]{n};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size in bytes %d; HMAC key must be at least 16 bytes", objectArray));
        }
        objectArray.zzb = n;
        return objectArray;
    }

    public final zzdg zzd(int n) throws GeneralSecurityException {
        if (n < 10) {
            Object[] objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; must be at least 10 bytes", objectArray));
        }
        objectArray.zzc = n;
        return objectArray;
    }

    public final zzdg zze(zzdi zzdi2) {
        this.zze = zzdi2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzdk zzf() throws GeneralSecurityException {
        Object[] objectArray;
        if (objectArray.zza == null) {
            throw new GeneralSecurityException("AES key size is not set");
        }
        if (objectArray.zzb == null) {
            throw new GeneralSecurityException("HMAC key size is not set");
        }
        Integer n = objectArray.zzc;
        if (n == null) {
            throw new GeneralSecurityException("tag size is not set");
        }
        if (objectArray.zzd == null) {
            throw new GeneralSecurityException("hash type is not set");
        }
        if (objectArray.zze == null) {
            throw new GeneralSecurityException("variant is not set");
        }
        int n2 = n;
        zzdh zzdh2 = objectArray.zzd;
        if (zzdh2 == zzdh.zza) {
            if (n2 <= 20) return new zzdk(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zze, objectArray.zzd, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 20 bytes for SHA1", objectArray));
        }
        if (zzdh2 == zzdh.zzb) {
            if (n2 <= 28) return new zzdk(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zze, objectArray.zzd, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 28 bytes for SHA224", objectArray));
        }
        if (zzdh2 == zzdh.zzc) {
            if (n2 <= 32) return new zzdk(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zze, objectArray.zzd, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 32 bytes for SHA256", objectArray));
        }
        if (zzdh2 == zzdh.zzd) {
            if (n2 <= 48) return new zzdk(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zze, objectArray.zzd, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 48 bytes for SHA384", objectArray));
        }
        if (zzdh2 != zzdh.zze) {
            throw new GeneralSecurityException("unknown hash type; must be SHA1, SHA224, SHA256, SHA384 or SHA512");
        }
        if (n2 <= 64) {
            return new zzdk(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zze, objectArray.zzd, null);
        }
        objectArray = new Object[]{n2};
        throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 64 bytes for SHA512", objectArray));
    }

    private zzdg() {
        throw null;
    }

    /* synthetic */ zzdg(zzdf zzdf2) {
        this.zze = zzdi.zzc;
    }
}

