/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzaav;
import com.google.android.gms.internal.firebase-auth-api.zzach;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.GenericIdpActivity;
import com.google.firebase.auth.zzam;
import com.google.firebase.auth.zzan;
import com.google.firebase.auth.zzao;
import com.google.firebase.auth.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OAuthProvider
extends FederatedAuthProvider {
    private final Bundle zza;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static AuthCredential getCredential(@NonNull String providerId, @NonNull String idToken, @NonNull String accessToken) {
        void var2_2;
        void var1_1;
        return zze.zzc(providerId, (String)var1_1, (String)var2_2, null, null);
    }

    @NonNull
    public static Builder newBuilder(@NonNull String providerId) {
        return OAuthProvider.newBuilder(providerId, FirebaseAuth.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Builder newBuilder(@NonNull String providerId, @NonNull FirebaseAuth firebaseAuth) {
        String string;
        void var1_1;
        Preconditions.checkNotEmpty((String)providerId);
        Preconditions.checkNotNull((Object)var1_1);
        if ("facebook.com".equals(string) && !zzach.zzg(var1_1.getApp())) {
            throw new IllegalArgumentException("Sign in with Facebook is not supported via this method; the Facebook TOS dictate that you must use the Facebook Android SDK for Facebook login.");
        }
        return new Builder(string, (FirebaseAuth)var1_1, null);
    }

    @NonNull
    public static CredentialBuilder newCredentialBuilder(@NonNull String providerId) {
        String string;
        return new CredentialBuilder(Preconditions.checkNotEmpty((String)string), null);
    }

    @Nullable
    public String getProviderId() {
        return this.zza.getString("com.google.firebase.auth.KEY_PROVIDER_ID");
    }

    /* synthetic */ OAuthProvider(Bundle bundle, zzao zzao2) {
        this.zza = bundle;
    }

    @Override
    public final void zza(@NonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_LINK");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        Activity activity2 = activity;
        intent.setPackage(activity2.getPackageName());
        intent.putExtras(this.zza);
        activity2.startActivity(intent);
    }

    @Override
    public final void zzb(@NonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        Activity activity2 = activity;
        intent.setPackage(activity2.getPackageName());
        intent.putExtras(this.zza);
        activity2.startActivity(intent);
    }

    @Override
    public final void zzc(@NonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        Activity activity2 = activity;
        intent.setPackage(activity2.getPackageName());
        intent.putExtras(this.zza);
        activity2.startActivity(intent);
    }

    public static class Builder {
        private final FirebaseAuth zzb;
        @VisibleForTesting
        final Bundle zza = new Bundle();
        private final Bundle zzc = new Bundle();

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCustomParameter(@NonNull String paramKey, @NonNull String paramValue) {
            void var2_2;
            void var1_1;
            this.zzc.putString((String)var1_1, (String)var2_2);
            return this;
        }

        @NonNull
        public Builder addCustomParameters(@NonNull Map<String, String> customParameters) {
            for (Map.Entry<String, String> entry : customParameters.entrySet()) {
                this.zzc.putString(entry.getKey(), entry.getValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setScopes(@NonNull List<String> scopes) {
            void var1_1;
            ArrayList arrayList = new ArrayList(var1_1);
            this.zza.putStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES", arrayList);
            return this;
        }

        @NonNull
        public OAuthProvider build() {
            return new OAuthProvider(this.zza, null);
        }

        @KeepForSdk
        @NonNull
        public List<String> getScopes() {
            ArrayList this_ = ((Builder)((Object)this_)).zza.getStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
            if (this_ != null) {
                return this_;
            }
            return Collections.emptyList();
        }

        /* synthetic */ Builder(String string, FirebaseAuth object, zzam zzam2) {
            ((Builder)((Object)string2)).zzb = object;
            object = ((Builder)((Object)string2)).zzb.getApp().getOptions().getApiKey();
            ((Builder)((Object)string2)).zza.putString("com.google.firebase.auth.KEY_API_KEY", (String)object);
            ((Builder)((Object)string2)).zza.putString("com.google.firebase.auth.KEY_PROVIDER_ID", string);
            ((Builder)((Object)string2)).zza.putBundle("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS", ((Builder)((Object)string2)).zzc);
            string = zzaav.zza().zzb();
            ((Builder)((Object)string2)).zza.putString("com.google.firebase.auth.internal.CLIENT_VERSION", string);
            string = ((Builder)((Object)string2)).zzb.getTenantId();
            ((Builder)((Object)string2)).zza.putString("com.google.firebase.auth.KEY_TENANT_ID", string);
            String string2 = ((Builder)((Object)string2)).zzb.getApp().getName();
            ((Builder)((Object)string2)).zza.putString("com.google.firebase.auth.KEY_FIREBASE_APP_NAME", string2);
        }
    }

    public static class CredentialBuilder {
        private final String zza;
        @Nullable
        private String zzb;
        @Nullable
        private String zzc;
        @Nullable
        private String zzd;

        @NonNull
        public AuthCredential build() {
            String string = ((CredentialBuilder)((Object)this_)).zza;
            String string2 = ((CredentialBuilder)((Object)this_)).zzb;
            String string3 = ((CredentialBuilder)((Object)this_)).zzc;
            String this_ = ((CredentialBuilder)((Object)this_)).zzd;
            Preconditions.checkNotEmpty((String)string, (Object)"Must specify a non-empty providerId");
            if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
                throw new IllegalArgumentException("Must specify an idToken or an accessToken.");
            }
            return new zze(string, string2, string3, null, null, null, this_);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public CredentialBuilder setAccessToken(@NonNull String accessToken) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public CredentialBuilder setIdToken(@NonNull String idToken) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public CredentialBuilder setIdTokenWithRawNonce(@NonNull String idToken, @Nullable String rawNonce) {
            void var2_2;
            void var1_1;
            this.zzb = var1_1;
            this.zzd = var2_2;
            return this;
        }

        @KeepForSdk
        @Nullable
        public String getAccessToken() {
            return this.zzc;
        }

        @KeepForSdk
        @Nullable
        public String getIdToken() {
            return this.zzb;
        }

        /* synthetic */ CredentialBuilder(String string, zzan zzan2) {
            this.zza = string;
        }
    }
}

