/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.internal.zzai;
import com.google.firebase.auth.zzaq;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class PhoneAuthOptions {
    private final FirebaseAuth zza;
    private final Long zzb;
    private final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzc;
    private final Executor zzd;
    @Nullable
    private final String zze;
    private final Activity zzf;
    @Nullable
    private final PhoneAuthProvider.ForceResendingToken zzg;
    @Nullable
    private final MultiFactorSession zzh;
    @Nullable
    private final PhoneMultiFactorInfo zzi;
    private final boolean zzj;
    private boolean zzk;

    @NonNull
    public static Builder newBuilder() {
        return new Builder(FirebaseAuth.getInstance());
    }

    @NonNull
    public static Builder newBuilder(@NonNull FirebaseAuth auth) {
        FirebaseAuth firebaseAuth;
        return new Builder(firebaseAuth);
    }

    @Nullable
    public final Activity zza() {
        return this.zzf;
    }

    @NonNull
    public final FirebaseAuth zzb() {
        return this.zza;
    }

    @Nullable
    public final MultiFactorSession zzc() {
        return this.zzh;
    }

    @Nullable
    public final PhoneAuthProvider.ForceResendingToken zzd() {
        return this.zzg;
    }

    @NonNull
    public final PhoneAuthProvider.OnVerificationStateChangedCallbacks zze() {
        return this.zzc;
    }

    @Nullable
    public final PhoneMultiFactorInfo zzf() {
        return this.zzi;
    }

    @NonNull
    public final Long zzg() {
        return this.zzb;
    }

    @Nullable
    public final String zzh() {
        return this.zze;
    }

    @NonNull
    public final Executor zzi() {
        return this.zzd;
    }

    /* synthetic */ PhoneAuthOptions(FirebaseAuth firebaseAuth, Long l, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, Executor executor, String string, Activity activity, PhoneAuthProvider.ForceResendingToken forceResendingToken, MultiFactorSession multiFactorSession, PhoneMultiFactorInfo phoneMultiFactorInfo, boolean bl, zzaq zzaq2) {
        this.zza = firebaseAuth;
        this.zze = string;
        this.zzb = l;
        this.zzc = onVerificationStateChangedCallbacks;
        this.zzf = activity;
        this.zzd = executor;
        this.zzg = forceResendingToken;
        this.zzh = multiFactorSession;
        this.zzi = phoneMultiFactorInfo;
        this.zzj = bl;
    }

    public final void zzj(boolean bl) {
        this.zzk = true;
    }

    public final boolean zzk() {
        return this.zzk;
    }

    public final boolean zzl() {
        return this.zzj;
    }

    public final boolean zzm() {
        return this.zzh != null;
    }

    public static final class Builder {
        private final FirebaseAuth zza;
        private String zzb;
        private Long zzc;
        private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzd;
        private Executor zze;
        private Activity zzf;
        @Nullable
        private PhoneAuthProvider.ForceResendingToken zzg;
        private MultiFactorSession zzh;
        private PhoneMultiFactorInfo zzi;
        private boolean zzj;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requireSmsValidation(boolean requireSmsValidation) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActivity(@NonNull Activity activity) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCallbacks(@NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks callbacks) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setForceResendingToken(@NonNull PhoneAuthProvider.ForceResendingToken forceResendingToken) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMultiFactorHint(@NonNull PhoneMultiFactorInfo phoneMultiFactorInfo) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMultiFactorSession(@NonNull MultiFactorSession multiFactorSession) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPhoneNumber(@NonNull String phoneNumber) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTimeout(@NonNull Long timeout, @NonNull TimeUnit unit) {
            void var2_2;
            void var1_1;
            this.zzc = TimeUnit.SECONDS.convert(var1_1.longValue(), (TimeUnit)var2_2);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public PhoneAuthOptions build() {
            Preconditions.checkNotNull((Object)this.zza, (Object)"FirebaseAuth instance cannot be null");
            Preconditions.checkNotNull((Object)this.zzc, (Object)"You must specify an auto-retrieval timeout; please call #setTimeout()");
            Preconditions.checkNotNull((Object)this.zzd, (Object)"You must specify callbacks on your PhoneAuthOptions. Please call #setCallbacks()");
            this.zze = TaskExecutors.MAIN_THREAD;
            if (this.zzc < 0L) throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
            if (this.zzc > 120L) {
                throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
            }
            MultiFactorSession multiFactorSession = this.zzh;
            if (multiFactorSession == null) {
                Preconditions.checkNotEmpty((String)this.zzb, (Object)"The given phoneNumber is empty. Please set a non-empty phone number with #setPhoneNumber()");
                Preconditions.checkArgument((boolean)(this.zzj ^ true), (Object)"You cannot require sms validation without setting a multi-factor session.");
                boolean bl = this.zzi == null;
                Preconditions.checkArgument((boolean)bl, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
                return new PhoneAuthOptions(this.zza, this.zzc, this.zzd, this.zze, this.zzb, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, null);
            }
            if (((zzai)multiFactorSession).zze()) {
                Preconditions.checkNotEmpty((String)this.zzb);
                boolean bl = this.zzi == null;
                Preconditions.checkArgument((boolean)bl, (Object)"Invalid MultiFactorSession - use the getSession method in MultiFactorResolver to get a valid sign-in session.");
                return new PhoneAuthOptions(this.zza, this.zzc, this.zzd, this.zze, this.zzb, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, null);
            }
            boolean bl = this.zzi != null;
            Preconditions.checkArgument((boolean)bl, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
            bl = this.zzb == null;
            Preconditions.checkArgument((boolean)bl, (Object)"A phone number must not be set for MFA sign-in. A PhoneMultiFactorInfo should be set instead.");
            return new PhoneAuthOptions(this.zza, this.zzc, this.zzd, this.zze, this.zzb, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, null);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull FirebaseAuth auth) {
            void var1_1;
            this.zza = (FirebaseAuth)Preconditions.checkNotNull((Object)var1_1);
        }
    }
}

