/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zzacx;
import com.google.android.gms.internal.firebase-auth-api.zzadl;
import com.google.android.gms.internal.firebase-auth-api.zzvz;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzw;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="DefaultAuthUserInfoCreator")
public final class zzv
extends AbstractSafeParcelable
implements UserInfo {
    public static final Parcelable.Creator<zzv> CREATOR = new zzw();
    @SafeParcelable.Field(id=1, getter="getUid")
    @NonNull
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getProviderId")
    @NonNull
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getDisplayName")
    @Nullable
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getPhotoUrlString")
    @Nullable
    private String zzd;
    @Nullable
    private Uri zze;
    @SafeParcelable.Field(id=5, getter="getEmail")
    @Nullable
    private final String zzf;
    @SafeParcelable.Field(id=6, getter="getPhoneNumber")
    @Nullable
    private final String zzg;
    @SafeParcelable.Field(id=7, getter="isEmailVerified")
    private final boolean zzh;
    @SafeParcelable.Field(id=8, getter="getRawUserInfo")
    @Nullable
    private final String zzi;

    @Override
    @Nullable
    public final Uri getPhotoUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.zzd) && this.zze == null) {
            this.zze = Uri.parse((String)this.zzd);
        }
        return this.zze;
    }

    @Override
    @Nullable
    public final String getDisplayName() {
        return this.zzc;
    }

    @Override
    @Nullable
    public final String getEmail() {
        return this.zzf;
    }

    @Override
    @Nullable
    public final String getPhoneNumber() {
        return this.zzg;
    }

    @Override
    @NonNull
    public final String getProviderId() {
        return this.zzb;
    }

    @Nullable
    public final String zza() {
        return this.zzi;
    }

    @Override
    @NonNull
    public final String getUid() {
        return this.zza;
    }

    @Nullable
    public final String zzb() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("userId", (Object)((zzv)((Object)string)).zza);
            jSONObject.putOpt("providerId", (Object)((zzv)((Object)string)).zzb);
            jSONObject.putOpt("displayName", (Object)((zzv)((Object)string)).zzc);
            jSONObject.putOpt("photoUrl", (Object)((zzv)((Object)string)).zzd);
            jSONObject.putOpt("email", (Object)((zzv)((Object)string)).zzf);
            jSONObject.putOpt("phoneNumber", (Object)((zzv)((Object)string)).zzg);
            jSONObject.putOpt("isEmailVerified", (Object)((zzv)((Object)string)).zzh);
            jSONObject.putOpt("rawUserInfo", (Object)((zzv)((Object)string)).zzi);
            String string = jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to jsonify this object");
            throw new zzvz(jSONException);
        }
        return string;
    }

    public zzv(zzadl zzadl2) {
        Preconditions.checkNotNull((Object)zzadl2);
        this.zza = zzadl2.zzd();
        this.zzb = Preconditions.checkNotEmpty((String)zzadl2.zzf());
        this.zzc = zzadl2.zzb();
        Uri uri = zzadl2.zza();
        if (uri != null) {
            this.zzd = uri.toString();
            this.zze = uri;
        }
        this.zzf = zzadl2.zzc();
        this.zzg = zzadl2.zze();
        this.zzh = false;
        this.zzi = zzadl2.zzg();
    }

    public zzv(zzacx zzacx2, String string) {
        Preconditions.checkNotNull((Object)zzacx2);
        Preconditions.checkNotEmpty((String)"firebase");
        zzv zzv2 = this;
        zzv2.zza = Preconditions.checkNotEmpty((String)zzacx2.zzo());
        zzv2.zzb = "firebase";
        this.zzf = zzacx2.zzn();
        this.zzc = zzacx2.zzm();
        string = zzacx2.zzc();
        if (string != null) {
            this.zzd = string.toString();
            this.zze = string;
        }
        this.zzh = zzacx2.zzs();
        this.zzi = null;
        this.zzg = zzacx2.zzp();
    }

    @VisibleForTesting
    @SafeParcelable.Constructor
    public zzv(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=3) @Nullable String string5, @SafeParcelable.Param(id=6) @Nullable String string6, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) @Nullable String string7) {
        this.zza = string;
        this.zzb = string2;
        this.zzf = string3;
        this.zzg = string4;
        this.zzc = string5;
        this.zzd = string6;
        if (!TextUtils.isEmpty((CharSequence)this.zzd)) {
            this.zze = Uri.parse((String)this.zzd);
        }
        this.zzh = bl;
        this.zzi = string7;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)6, (String)this.zzg, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)7, (boolean)this.zzh);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)this.zzi, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final boolean isEmailVerified() {
        return this.zzh;
    }
}

