/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzaco;
import com.google.android.gms.internal.zzacq;
import com.google.android.gms.internal.zzact;
import com.google.android.gms.internal.zzacv;
import com.google.android.gms.internal.zzacx;
import com.google.android.gms.internal.zzacy;
import com.google.android.gms.internal.zzadc;
import com.google.android.gms.internal.zzadd;
import com.google.android.gms.internal.zzade;
import com.google.android.gms.internal.zzadf;
import com.google.android.gms.internal.zzadh;
import com.google.android.gms.internal.zzadi;
import com.google.android.gms.internal.zzadj;
import com.google.android.gms.internal.zzadk;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetAccountInfoUser;
import com.google.firebase.auth.api.model.ProviderUserInfo;
import com.google.firebase.auth.api.model.VerifyAssertionRequest;
import java.util.ArrayList;
import java.util.List;

public class zzacn
extends com.google.android.gms.common.api.zzc<zzacv.zza> {
    zzacn(@NonNull Context context, @NonNull zzacv.zza zza2) {
        super(context, zzacv.zzbFz, (Api.ApiOptions)zza2);
    }

    public Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzadc zzadc2) {
        return this.zza(this.zza(new zzd(string).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzn(string).zzd(firebaseApp).zzaa(zzadc2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzm(authCredential).zzd(firebaseApp).zzaa(zzadc2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzh(authCredential).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzl().zzd(firebaseApp).zzaa(zzadc2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzt(userProfileChangeRequest).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzr(string).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzs(string).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zza(string, string2).zzd(firebaseApp).zzaa(zzadc2)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzo(string, string2).zzd(firebaseApp).zzaa(zzadc2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzi(string, string2).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    public Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(this.zza(new zzc(string).zzd(firebaseApp)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(this.zza(new zzk(string).zzd(firebaseApp)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzadc zzadc2) {
        zzaa.zzz((Object)firebaseApp);
        zzaa.zzz((Object)authCredential);
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzz((Object)zzadc2);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            return this.zza(firebaseApp, (EmailAuthCredential)authCredential, firebaseUser, zzadc2);
        }
        return this.zza(firebaseApp, authCredential, firebaseUser, zzadc2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zze(emailAuthCredential).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzadc zzadc2) {
        zzaa.zzz((Object)firebaseApp);
        zzaa.zzz((Object)authCredential);
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzz((Object)zzadc2);
        List list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzacq.zzbN(new Status(17015)));
        }
        return this.zzb(this.zza(new zzf(authCredential).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    public Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzadc zzadc2) {
        zzaa.zzz((Object)firebaseApp);
        zzaa.zzdl((String)string);
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzz((Object)zzadc2);
        List list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzacq.zzbN(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                return this.zza(firebaseApp, firebaseUser, zzadc2);
            }
        }
        return this.zza(firebaseApp, string, firebaseUser, zzadc2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzp().zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull FirebaseUser firebaseUser, @NonNull zzadc zzadc2) {
        return this.zzb(this.zza(new zzq(string).zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzadc zzadc2) {
        return this.zza(this.zza(new zzj().zzd(firebaseApp).zzd(firebaseUser).zzaa(zzadc2)));
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzadk zzadk2) {
        return this.zzb(this.zza(new zzb().zzd(firebaseUser).zzaa(zzadk2)));
    }

    @NonNull
    private static zzadh zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser) {
        return zzacn.zza(firebaseApp, getAccountInfoUser, false);
    }

    @NonNull
    private static zzadh zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser, boolean bl) {
        zzaa.zzz((Object)firebaseApp);
        zzaa.zzz((Object)getAccountInfoUser);
        ArrayList<zzadf> arrayList = new ArrayList<zzadf>();
        zzadf zzadf2 = new zzadf(getAccountInfoUser, "firebase");
        arrayList.add(zzadf2);
        List list = getAccountInfoUser.zzOD();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzadf((ProviderUserInfo)list.get(i)));
            }
        }
        zzadh zzadh2 = new zzadh(firebaseApp, arrayList);
        zzadh cfr_ignored_0 = (zzadh)zzadh2.zzaK(bl);
        if (!TextUtils.isEmpty((CharSequence)getAccountInfoUser.getEmail()) && !TextUtils.isEmpty((CharSequence)getAccountInfoUser.getPassword())) {
            zzadh2.zzhI("password");
        }
        return zzadh2;
    }

    private <ResultT, CallbackT> zzg<ResultT, CallbackT> zza(zzacy<ResultT, CallbackT> zzacy2) {
        return new zzg<ResultT, CallbackT>(zzacy2);
    }

    private class zzg<ResultT, CallbackT>
    extends zzpd<zzaco, ResultT>
    implements zzacx<ResultT> {
        private zzacy<ResultT, CallbackT> zzbFr;
        private TaskCompletionSource<ResultT> zzalF;

        public zzg(zzacy<ResultT, CallbackT> zzacy2) {
            this.zzbFr = zzacy2;
            this.zzbFr.zza(this);
        }

        protected void zza(zzaco zzaco2, TaskCompletionSource<ResultT> taskCompletionSource) throws RemoteException {
            this.zzalF = taskCompletionSource;
            this.zzbFr.zza(zzaco2.zzOs());
        }

        @Override
        public final void zza(ResultT ResultT, Status status) {
            zzaa.zzb(this.zzalF, (Object)"doExecute must be called before onComplete");
            if (status != null) {
                this.zzalF.setException((Exception)zzacq.zzbN(status));
            } else {
                this.zzalF.setResult(ResultT);
            }
        }
    }

    static final class zzb
    extends zzacy<Void, zzadk> {
        public zzb() {
            super(5);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzg(this.zzbFC.zzOm(), this.zzbFB);
        }

        @Override
        public void zzOr() {
            ((zzadk)this.zzbFE).zzOk();
            this.zzab(null);
        }
    }

    static final class zzj
    extends zzacy<Void, zzadc> {
        public zzj() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzf(this.zzbFC.zzOm(), this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH, this.zzbFC.isAnonymous());
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(null);
        }
    }

    static final class zzq
    extends zzacy<AuthResult, zzadc> {
        @NonNull
        private String zzbFt;

        public zzq(@NonNull String string) {
            super(2);
            this.zzbFt = zzaa.zzh((String)string, (Object)"provider cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zze(this.zzbFt, this.zzbFC.zzOm(), this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zzp
    extends zzacy<AuthResult, zzadc> {
        public zzp() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zze(this.zzbFC.zzOm(), this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zzf
    extends zzacy<AuthResult, zzadc> {
        @NonNull
        private final VerifyAssertionRequest zzbFq;

        public zzf(@NonNull AuthCredential authCredential) {
            super(2);
            zzaa.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbFq = zzadd.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFC.zzOm(), this.zzbFq, (zzact)this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zze
    extends zzacy<AuthResult, zzadc> {
        @NonNull
        private final EmailAuthCredential zzbFp;

        public zze(@NonNull EmailAuthCredential emailAuthCredential) {
            super(2);
            this.zzbFp = (EmailAuthCredential)zzaa.zzb((Object)emailAuthCredential, (Object)"credential cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFp.getEmail(), this.zzbFp.getPassword(), this.zzbFC.zzOm(), this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zzk
    extends zzacy<Void, zzadc> {
        @NonNull
        private String zzacn;

        public zzk(@NonNull String string) {
            super(4);
            this.zzacn = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzd(this.zzacn, this.zzbFB);
        }

        @Override
        public void zzOr() {
            this.zzOx();
        }
    }

    static final class zzc
    extends zzacy<ProviderQueryResult, zzadc> {
        @NonNull
        private final String zzacn;

        public zzc(@NonNull String string) {
            super(3);
            this.zzacn = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzc(this.zzacn, this.zzbFB);
        }

        @Override
        public void zzOr() {
            this.zzab(new zzadi(this.zzbFI));
        }
    }

    static final class zzi
    extends zzacy<Void, zzadc> {
        @NonNull
        private final String zzacn;
        @NonNull
        private final String zzabx;

        public zzi(@NonNull String string, @NonNull String string2) {
            super(2);
            this.zzacn = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzabx = zzaa.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzd(this.zzacn, this.zzabx, this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = com.google.android.gms.internal.zzacn.zza(this.zzbEZ, this.zzbFH);
            if (this.zzbFC.getUid().equalsIgnoreCase(zzadh2.getUid())) {
                ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
                this.zzOx();
            } else {
                this.zzbO(zzadj.zzOS());
            }
        }
    }

    static final class zzo
    extends zzacy<AuthResult, zzadc> {
        @NonNull
        private String zzacn;
        @NonNull
        private String zzabx;

        public zzo(String string, String string2) {
            super(2);
            this.zzacn = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzabx = zzaa.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzd(this.zzacn, this.zzabx, this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = com.google.android.gms.internal.zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zza
    extends zzacy<AuthResult, zzadc> {
        @NonNull
        private String zzacn;
        @NonNull
        private String zzabx;

        public zza(@NonNull String string, @NonNull String string2) {
            super(2);
            this.zzacn = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzabx = zzaa.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzc(this.zzacn, this.zzabx, this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = com.google.android.gms.internal.zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zzs
    extends zzacy<Void, zzadc> {
        @NonNull
        private final String zzabx;

        public zzs(@NonNull String string) {
            super(2);
            this.zzabx = zzaa.zzh((String)string, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzb(this.zzbFC.zzOm(), this.zzabx, this.zzbFB);
        }

        @Override
        public void zzOr() {
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzacn.zza(this.zzbEZ, this.zzbFH));
            this.zzOx();
        }
    }

    static final class zzr
    extends zzacy<Void, zzadc> {
        @NonNull
        private final String zzacn;

        public zzr(String string) {
            super(2);
            this.zzacn = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFC.zzOm(), this.zzacn, (zzact)this.zzbFB);
        }

        @Override
        public void zzOr() {
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)com.google.android.gms.internal.zzacn.zza(this.zzbEZ, this.zzbFH));
            this.zzOx();
        }
    }

    static final class zzt
    extends zzacy<Void, zzadc> {
        @NonNull
        private final UserProfileChangeRequest zzbFu;

        public zzt(UserProfileChangeRequest userProfileChangeRequest) {
            super(2);
            this.zzbFu = (UserProfileChangeRequest)zzaa.zzb((Object)userProfileChangeRequest, (Object)"request cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFC.zzOm(), this.zzbFu, (zzact)this.zzbFB);
        }

        @Override
        public void zzOr() {
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzacn.zza(this.zzbEZ, this.zzbFH));
            this.zzOx();
        }
    }

    static final class zzl
    extends zzacy<AuthResult, zzadc> {
        public zzl() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH, true);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zzh
    extends zzacy<Void, zzadc> {
        @NonNull
        private final VerifyAssertionRequest zzbFq;

        public zzh(@NonNull AuthCredential authCredential) {
            super(2);
            zzaa.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbFq = zzadd.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFq, (zzact)this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH);
            if (this.zzbFC.getUid().equalsIgnoreCase(zzadh2.getUid())) {
                ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
                this.zzOx();
            } else {
                this.zzbO(zzadj.zzOS());
            }
        }
    }

    static final class zzm
    extends zzacy<AuthResult, zzadc> {
        @NonNull
        private final VerifyAssertionRequest zzbFq;

        public zzm(@NonNull AuthCredential authCredential) {
            super(2);
            zzaa.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbFq = zzadd.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFq, (zzact)this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zzn
    extends zzacy<AuthResult, zzadc> {
        @NonNull
        private final String zzabf;

        public zzn(@NonNull String string) {
            super(2);
            this.zzabf = zzaa.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zzb(this.zzabf, this.zzbFB);
        }

        @Override
        public void zzOr() {
            zzadh zzadh2 = zzacn.zza(this.zzbEZ, this.zzbFH);
            ((zzadc)this.zzbFE).zza(this.zzbFG, (FirebaseUser)zzadh2);
            this.zzab(new zzade(zzadh2));
        }
    }

    static final class zzd
    extends zzacy<GetTokenResult, zzadc> {
        @NonNull
        private final String zzbFo;

        public zzd(@NonNull String string) {
            super(1);
            this.zzbFo = zzaa.zzh((String)string, (Object)"refresh token cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbFD.zza(this.zzbFo, (zzact)this.zzbFB);
        }

        @Override
        public void zzOr() {
            this.zzbFG.zzhH(this.zzbFo);
            ((zzadc)this.zzbFE).zza(this.zzbFG, this.zzbFC);
            this.zzab(new GetTokenResult(this.zzbFG.getAccessToken()));
        }
    }
}

