/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.util.zzu;
import com.google.android.gms.internal.zzaac;
import com.google.android.gms.internal.zzbth;
import com.google.android.gms.internal.zzbti;
import com.google.android.gms.internal.zzbtj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzbWA = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzbWB = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzbWC = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzbWD = Arrays.asList(new String[0]);
    private static final Set<String> zzbWE = Collections.emptySet();
    private static final Object zztX = new Object();
    static final Map<String, FirebaseApp> zzbhH = new ArrayMap();
    private final Context zzwi;
    private final String mName;
    private final FirebaseOptions zzbWF;
    private final AtomicBoolean zzbWG = new AtomicBoolean(false);
    private final AtomicBoolean zzbWH = new AtomicBoolean();
    private final List<zza> zzbWI = new CopyOnWriteArrayList<zza>();
    private final List<zzb> zzbWJ = new CopyOnWriteArrayList<zzb>();
    private final List<Object> zzbWK = new CopyOnWriteArrayList<Object>();
    private zzbti zzbWL;

    @NonNull
    public Context getApplicationContext() {
        this.zzUU();
        return this.zzwi;
    }

    @NonNull
    public String getName() {
        this.zzUU();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzUU();
        return this.zzbWF;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzbWF).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzbth zzbth2 = zzbth.zzcw(context);
        Object object = zztX;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzbhH.values());
            Set<String> set = zzbth.zzabY().zzabZ();
            set.removeAll(zzbhH.keySet());
            for (String string : set) {
                zzbth2.zzjC(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zztX;
        synchronized (object) {
            FirebaseApp firebaseApp = zzbhH.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = String.valueOf(zzu.zzzr());
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zztX;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzbhH.get(FirebaseApp.zzis(string));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzUX();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string2);
            throw new IllegalStateException(string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zztX;
        synchronized (object) {
            if (zzbhH.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzbth zzbth2 = zzbth.zzcw(context);
        FirebaseApp.zzcl(context);
        String string2 = FirebaseApp.zzis(string);
        Context context2 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = zztX;
        synchronized (object) {
            zzac.zza((!zzbhH.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzac.zzb((Object)context2, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context2, string2, firebaseOptions);
            zzbhH.put(string2, firebaseApp);
        }
        zzbth2.zzg(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbWA);
        if (firebaseApp.zzUV()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbWB);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzbWC);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzat(boolean bl) {
        Object object = zztX;
        synchronized (object) {
            for (FirebaseApp firebaseApp : new ArrayList<FirebaseApp>(zzbhH.values())) {
                if (!firebaseApp.zzbWG.get()) continue;
                firebaseApp.zzaW(bl);
            }
        }
    }

    public void zza(@NonNull zzbti zzbti2) {
        this.zzbWL = (zzbti)zzac.zzw((Object)zzbti2);
    }

    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzUU();
        if (this.zzbWL == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzbWL.zzaX(bl);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzUU();
        boolean bl2 = this.zzbWG.compareAndSet(!bl, bl);
        if (bl2) {
            boolean bl3 = zzaac.zzvB().zzvC();
            if (bl && bl3) {
                this.zzaW(true);
            } else if (!bl && bl3) {
                this.zzaW(false);
            }
        }
    }

    protected FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zzwi = (Context)zzac.zzw((Object)context);
        this.mName = zzac.zzdr((String)string);
        this.zzbWF = (FirebaseOptions)zzac.zzw((Object)firebaseOptions);
    }

    private void zzUU() {
        zzac.zza((!this.zzbWH.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public boolean zzUV() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public void zza(@NonNull zzbtj zzbtj2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        for (zza zza2 : this.zzbWI) {
            zza2.zzb(zzbtj2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private void zzaW(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        for (zzb zzb2 : this.zzbWJ) {
            zzb2.zzat(bl);
        }
    }

    public void zza(@NonNull zza zza2) {
        this.zzUU();
        zzac.zzw((Object)zza2);
        this.zzbWI.add(zza2);
    }

    public void zza(zzb zzb2) {
        this.zzUU();
        if (this.zzbWG.get() && zzaac.zzvB().zzvC()) {
            zzb2.zzat(true);
        }
        this.zzbWJ.add(zzb2);
    }

    public String zzUW() {
        String string = String.valueOf(com.google.android.gms.common.util.zzc.zzs((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(com.google.android.gms.common.util.zzc.zzs((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzUX() {
        com.google.android.gms.common.util.zza zza2 = new com.google.android.gms.common.util.zza();
        ArrayList<String> arrayList = zztX;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzbhH.values()) {
                zza2.add(firebaseApp.getName());
            }
            zzbth zzbth2 = zzbth.zzabY();
            if (zzbth2 != null) {
                zza2.addAll(zzbth2.zzabZ());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zza2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private void zzUY() {
        this.zza(FirebaseApp.class, this, zzbWA);
        if (this.zzUV()) {
            this.zza(FirebaseApp.class, this, zzbWB);
            this.zza(Context.class, this.zzwi, zzbWC);
        }
    }

    private <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.zzwi);
        if (bl) {
            zzc.zzcm(this.zzwi);
        }
        for (String string : iterable) {
            try {
                Class<?> clazz2;
                Method method;
                int n;
                if (bl && !zzbWD.contains(string) || !Modifier.isPublic(n = (method = (clazz2 = Class.forName(string)).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzbWE.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    private static String zzis(@NonNull String string) {
        return string.trim();
    }

    @TargetApi(value=14)
    private static void zzcl(Context context) {
        zzt.zzzg();
        if (context.getApplicationContext() instanceof Application) {
            Application application = (Application)context.getApplicationContext();
            zzaac.zza((Application)application);
            zzaac.zzvB().zza(new zzaac.zza(){

                public void zzat(boolean bl) {
                    FirebaseApp.zzat(bl);
                }
            });
        }
    }

    @TargetApi(value=24)
    private static class zzc
    extends BroadcastReceiver {
        private static AtomicReference<zzc> zzbWM = new AtomicReference();
        private final Context zzwi;

        public zzc(Context context) {
            this.zzwi = context;
        }

        private static void zzcm(Context context) {
            zzc zzc2;
            if (zzbWM.get() == null && zzbWM.compareAndSet(null, zzc2 = new zzc(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzc2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = zztX;
            synchronized (object) {
                for (FirebaseApp firebaseApp : zzbhH.values()) {
                    firebaseApp.zzUY();
                }
            }
            this.unregister();
        }

        public void unregister() {
            this.zzwi.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public static interface zzb {
        public void zzat(boolean var1);
    }

    public static interface zza {
        public void zzb(@NonNull zzbtj var1);
    }
}

