/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import android.util.Base64OutputStream;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.UserManagerCompat;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.components.Component;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Lazy;
import com.google.firebase.components.Qualified;
import com.google.firebase.heartbeatinfo.HeartBeatConsumer;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.heartbeatinfo.HeartBeatInfoStorage;
import com.google.firebase.heartbeatinfo.HeartBeatResult;
import com.google.firebase.inject.Provider;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultHeartBeatController
implements HeartBeatController,
HeartBeatInfo {
    private final Provider<HeartBeatInfoStorage> storageProvider;
    private final Context applicationContext;
    private final Provider<UserAgentPublisher> userAgentProvider;
    private final Set<HeartBeatConsumer> consumers;
    private final Executor backgroundExecutor;

    public Task<Void> registerHeartBeat() {
        boolean inDirectBoot;
        if (this.consumers.size() <= 0) {
            return Tasks.forResult(null);
        }
        boolean bl = inDirectBoot = !UserManagerCompat.isUserUnlocked((Context)this.applicationContext);
        if (inDirectBoot) {
            return Tasks.forResult(null);
        }
        return Tasks.call((Executor)this.backgroundExecutor, () -> {
            DefaultHeartBeatController defaultHeartBeatController = this;
            synchronized (defaultHeartBeatController) {
                ((HeartBeatInfoStorage)this.storageProvider.get()).storeHeartBeat(System.currentTimeMillis(), ((UserAgentPublisher)this.userAgentProvider.get()).getUserAgent());
            }
            return null;
        });
    }

    @Override
    public Task<String> getHeartBeatsHeader() {
        boolean inDirectBoot;
        boolean bl = inDirectBoot = !UserManagerCompat.isUserUnlocked((Context)this.applicationContext);
        if (inDirectBoot) {
            return Tasks.forResult((Object)"");
        }
        return Tasks.call((Executor)this.backgroundExecutor, () -> {
            DefaultHeartBeatController defaultHeartBeatController = this;
            synchronized (defaultHeartBeatController) {
                HeartBeatInfoStorage storage = (HeartBeatInfoStorage)this.storageProvider.get();
                List<HeartBeatResult> allHeartBeats = storage.getAllHeartBeats();
                storage.deleteAllHeartBeats();
                JSONArray array = new JSONArray();
                for (int i = 0; i < allHeartBeats.size(); ++i) {
                    HeartBeatResult result = allHeartBeats.get(i);
                    JSONObject obj = new JSONObject();
                    obj.put("agent", (Object)result.getUserAgent());
                    obj.put("dates", (Object)new JSONArray(result.getUsedDates()));
                    array.put((Object)obj);
                }
                JSONObject output = new JSONObject();
                output.put("heartbeats", (Object)array);
                output.put("version", (Object)"2");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (Base64OutputStream b64os = new Base64OutputStream((OutputStream)out, 11);
                     GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)b64os);){
                    gzip.write(output.toString().getBytes("UTF-8"));
                }
                return out.toString("UTF-8");
            }
        });
    }

    private DefaultHeartBeatController(Context context, String persistenceKey, Set<HeartBeatConsumer> consumers, Provider<UserAgentPublisher> userAgentProvider, Executor backgroundExecutor) {
        this((Provider<HeartBeatInfoStorage>)new Lazy(() -> new HeartBeatInfoStorage(context, persistenceKey)), consumers, backgroundExecutor, userAgentProvider, context);
    }

    @VisibleForTesting
    DefaultHeartBeatController(Provider<HeartBeatInfoStorage> testStorage, Set<HeartBeatConsumer> consumers, Executor executor, Provider<UserAgentPublisher> userAgentProvider, Context context) {
        this.storageProvider = testStorage;
        this.consumers = consumers;
        this.backgroundExecutor = executor;
        this.userAgentProvider = userAgentProvider;
        this.applicationContext = context;
    }

    @NonNull
    public static Component<DefaultHeartBeatController> component() {
        Qualified backgroundExecutor = Qualified.qualified(Background.class, Executor.class);
        return Component.builder(DefaultHeartBeatController.class, (Class[])new Class[]{HeartBeatController.class, HeartBeatInfo.class}).add(Dependency.required(Context.class)).add(Dependency.required(FirebaseApp.class)).add(Dependency.setOf(HeartBeatConsumer.class)).add(Dependency.requiredProvider(UserAgentPublisher.class)).add(Dependency.required((Qualified)backgroundExecutor)).factory(c -> new DefaultHeartBeatController((Context)c.get(Context.class), ((FirebaseApp)c.get(FirebaseApp.class)).getPersistenceKey(), c.setOf(HeartBeatConsumer.class), (Provider<UserAgentPublisher>)c.getProvider(UserAgentPublisher.class), (Executor)c.get(backgroundExecutor))).build();
    }

    @Override
    @NonNull
    public synchronized HeartBeatInfo.HeartBeat getHeartBeatCode(@NonNull String heartBeatTag) {
        long presentTime = System.currentTimeMillis();
        HeartBeatInfoStorage storage = (HeartBeatInfoStorage)this.storageProvider.get();
        boolean shouldSendGlobalHB = storage.shouldSendGlobalHeartBeat(presentTime);
        if (shouldSendGlobalHB) {
            storage.postHeartBeatCleanUp();
            return HeartBeatInfo.HeartBeat.GLOBAL;
        }
        return HeartBeatInfo.HeartBeat.NONE;
    }
}

