/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.AbstractComponentContainer;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.ComponentRuntime$$Lambda$1;
import com.google.firebase.components.ComponentRuntime$$Lambda$4;
import com.google.firebase.components.ComponentRuntime$$Lambda$5;
import com.google.firebase.components.CycleDetector;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.EventBus;
import com.google.firebase.components.Lazy;
import com.google.firebase.components.MissingDependencyException;
import com.google.firebase.components.Preconditions;
import com.google.firebase.components.RestrictedComponentContainer;
import com.google.firebase.events.Publisher;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public class ComponentRuntime
extends AbstractComponentContainer {
    private static final Provider<Set<Object>> EMPTY_PROVIDER = ComponentRuntime$$Lambda$5.lambdaFactory$();
    private final Map<Component<?>, Lazy<?>> components = new HashMap();
    private final Map<Class<?>, Lazy<?>> lazyInstanceMap = new HashMap();
    private final Map<Class<?>, Lazy<Set<?>>> lazySetMap = new HashMap();
    private final EventBus eventBus;

    public ComponentRuntime(Executor defaultEventExecutor, Iterable<ComponentRegistrar> registrars, Component<?> ... additionalComponents) {
        this.eventBus = new EventBus(defaultEventExecutor);
        ArrayList componentsToAdd = new ArrayList();
        componentsToAdd.add(Component.of(this.eventBus, EventBus.class, Subscriber.class, Publisher.class));
        for (ComponentRegistrar componentRegistrar : registrars) {
            componentsToAdd.addAll(componentRegistrar.getComponents());
        }
        for (Component<?> additionalComponent : additionalComponents) {
            if (additionalComponent == null) continue;
            componentsToAdd.add(additionalComponent);
        }
        CycleDetector.detect(componentsToAdd);
        for (Component component : componentsToAdd) {
            Lazy lazy = new Lazy(ComponentRuntime$$Lambda$1.lambdaFactory$(this, component));
            this.components.put(component, lazy);
        }
        this.processInstanceComponents();
        this.processSetComponents();
    }

    private void processInstanceComponents() {
        for (Map.Entry<Component<?>, Lazy<?>> entry : this.components.entrySet()) {
            Component<?> component = entry.getKey();
            if (!component.isValue()) continue;
            Lazy<?> lazy = entry.getValue();
            for (Class<?> anInterface : component.getProvidedInterfaces()) {
                this.lazyInstanceMap.put(anInterface, lazy);
            }
        }
        this.validateDependencies();
    }

    private void processSetComponents() {
        HashMap setIndex = new HashMap();
        for (Map.Entry<Component<?>, Lazy<?>> entry : this.components.entrySet()) {
            Component<?> component = entry.getKey();
            if (component.isValue()) continue;
            Lazy<?> lazy = entry.getValue();
            for (Class<?> anInterface : component.getProvidedInterfaces()) {
                if (!setIndex.containsKey(anInterface)) {
                    setIndex.put(anInterface, new HashSet());
                }
                ((Set)setIndex.get(anInterface)).add(lazy);
            }
        }
        for (Map.Entry<Component<Object>, Lazy<Object>> entry : setIndex.entrySet()) {
            Set lazies = (Set)((Object)entry.getValue());
            this.lazySetMap.put((Class)((Object)entry.getKey()), new Lazy(ComponentRuntime$$Lambda$4.lambdaFactory$(lazies)));
        }
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> anInterface) {
        Preconditions.checkNotNull(anInterface, "Null interface requested.");
        return this.lazyInstanceMap.get(anInterface);
    }

    @Override
    public <T> Provider<Set<T>> setOfProvider(Class<T> anInterface) {
        Lazy<Set<T>> lazy = this.lazySetMap.get(anInterface);
        if (lazy != null) {
            return lazy;
        }
        return EMPTY_PROVIDER;
    }

    public void initializeEagerComponents(boolean isDefaultApp) {
        for (Map.Entry<Component<?>, Lazy<?>> entry : this.components.entrySet()) {
            Component<?> component = entry.getKey();
            Lazy<?> lazy = entry.getValue();
            if (!component.isAlwaysEager() && (!component.isEagerInDefaultApp() || !isDefaultApp)) continue;
            lazy.get();
        }
        this.eventBus.enablePublishingAndFlushPending();
    }

    private void validateDependencies() {
        for (Component<?> component : this.components.keySet()) {
            for (Dependency dependency : component.getDependencies()) {
                if (!dependency.isRequired() || this.lazyInstanceMap.containsKey(dependency.getInterface())) continue;
                throw new MissingDependencyException(String.format("Unsatisfied dependency for component %s: %s", component, dependency.getInterface()));
            }
        }
    }

    static /* synthetic */ Set lambda$processSetComponents$1(Set lazies) {
        HashSet set = new HashSet();
        for (Lazy lazy : lazies) {
            set.add(lazy.get());
        }
        return Collections.unmodifiableSet(set);
    }

    static /* synthetic */ Object lambda$new$0(ComponentRuntime this_, Component component) {
        return component.getFactory().create(new RestrictedComponentContainer(component, this_));
    }
}

