/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzadi;
import com.google.android.gms.internal.zzado;
import com.google.android.gms.internal.zzblq;
import com.google.android.gms.internal.zzbtl;
import com.google.android.gms.internal.zzbtm;
import com.google.android.gms.internal.zzbtn;
import com.google.android.gms.internal.zzbto;
import com.google.android.gms.internal.zzbtp;
import com.google.android.gms.internal.zzbtq;
import com.google.android.gms.internal.zzbtr;
import com.google.android.gms.internal.zzbts;
import com.google.android.gms.internal.zzbxl;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzclU;
    private zzbto zzclV;
    private zzbto zzclW;
    private zzbto zzclX;
    private zzbtr zzclY;
    private final Context mContext;
    private final ReadWriteLock zzclZ = new ReentrantReadWriteLock(true);

    FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzbto zzbto2, zzbto zzbto3, zzbto zzbto4, zzbtr zzbtr2) {
        this.mContext = context;
        this.zzclY = zzbtr2 != null ? zzbtr2 : new zzbtr();
        this.zzclY.zzaV(this.zzcz(this.mContext));
        if (zzbto2 != null) {
            this.zzclV = zzbto2;
        }
        if (zzbto3 != null) {
            this.zzclW = zzbto3;
        }
        if (zzbto4 != null) {
            this.zzclX = zzbto4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzclU == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            return FirebaseRemoteConfig.zzcy(context);
        }
        return zzclU;
    }

    public static FirebaseRemoteConfig zzcy(Context context) {
        if (zzclU == null) {
            zzbts.zze zze2 = FirebaseRemoteConfig.zzcA(context);
            if (zze2 == null) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                }
                zzclU = new FirebaseRemoteConfig(context);
            } else {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                }
                zzbto zzbto2 = FirebaseRemoteConfig.zza(zze2.zzcmz);
                zzbto zzbto3 = FirebaseRemoteConfig.zza(zze2.zzcmA);
                zzbto zzbto4 = FirebaseRemoteConfig.zza(zze2.zzcmB);
                zzbtr zzbtr2 = FirebaseRemoteConfig.zza(zze2.zzcmC);
                if (zzbtr2 != null) {
                    zzbtr2.zzaI(FirebaseRemoteConfig.zza(zze2.zzcmD));
                }
                zzclU = new FirebaseRemoteConfig(context, zzbto2, zzbto3, zzbto4, zzbtr2);
            }
        }
        return zzclU;
    }

    private long zzcz(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzbts.zze zzcA(Context context) {
        zzbts.zze zze2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            zzbxl zzbxl2 = zzbxl.zzaf((byte[])FirebaseRemoteConfig.zzk(fileInputStream));
            zze2 = new zzbts.zze();
            zze2.zzb(zzbxl2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zze2;
    }

    private static Map<String, zzbtl> zza(zzbts.zzf[] zzfArray) {
        HashMap<String, zzbtl> hashMap = new HashMap<String, zzbtl>();
        if (zzfArray == null) {
            return hashMap;
        }
        for (zzbts.zzf zzf2 : zzfArray) {
            String string = zzf2.zzaGP;
            int n = zzf2.resourceId;
            long l = zzf2.zzcmF;
            hashMap.put(string, new zzbtl(n, l));
        }
        return hashMap;
    }

    private static zzbtr zza(zzbts.zzc zzc2) {
        if (zzc2 == null) {
            return null;
        }
        zzbtr zzbtr2 = new zzbtr();
        zzbtr2.zzqJ(zzc2.zzcmu);
        zzbtr2.zzbh(zzc2.zzcmv);
        zzbtr2.zzaW(zzc2.zzcmw);
        return zzbtr2;
    }

    /*
     * WARNING - void declaration
     */
    private static zzbto zza(zzbts.zza zza2) {
        void var5_8;
        zzbts.zzd[] zzdArray;
        if (zza2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        zzbts.zzd[] object = zzdArray = zza2.zzcmq;
        int arrayList = object.length;
        boolean bl = false;
        while (var5_8 < arrayList) {
            zzbts.zzd zzd2 = object[var5_8];
            String string = zzd2.zzaGP;
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            for (zzbts.zzb zzb2 : zzd2.zzcmy) {
                hashMap2.put(zzb2.zzaB, zzb2.zzcmt);
            }
            hashMap.put(string, hashMap2);
            ++var5_8;
        }
        byte[][] byArray = zza2.zzcmr;
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        for (byte[] byArray2 : byArray) {
            arrayList2.add(byArray2);
        }
        return new zzbto(hashMap, zza2.timestamp, arrayList2);
    }

    private static byte[] zzk(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FirebaseRemoteConfig.zzb(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zzb(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFetched() {
        this.zzclZ.writeLock().lock();
        try {
            if (this.zzclV == null) {
                return false;
            }
            if (this.zzclW != null && this.zzclW.getTimestamp() >= this.zzclV.getTimestamp()) {
                return false;
            }
            long l = this.zzclV.getTimestamp();
            this.zzclW = this.zzclV;
            this.zzclW.setTimestamp(System.currentTimeMillis());
            this.zzclV = new zzbto(null, l, null);
            long l2 = this.zzclY.zzack();
            this.zzclY.zzaW(zzblq.zza(l2, this.zzclW.zzzE()));
            this.zza(this.mContext, this.zzclW.zzzE(), l2);
            this.zzacc();
            return true;
        }
        finally {
            this.zzclZ.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzclZ.readLock().lock();
        try {
            if (this.zzclY != null && this.zzclY.zzaci() != null && this.zzclY.zzaci().get(string) != null && n == ((zzbtl)(object = this.zzclY.zzaci().get(string))).zzacd() && this.zzclY.zzacj() == ((zzbtl)object).zzace()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
        object = new HashMap();
        try {
            Resources resources = this.mContext.getResources();
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzbtl zzbtl2 = new zzbtl(n, this.zzclY.zzacj());
            this.zzclY.zza(string, zzbtl2);
            this.zzc((Map<String, Object>)object, string, false);
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzbtq.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzbtq.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzbtq.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzbtq.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzbtq.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzbtq.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzclZ.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzclX == null || !this.zzclX.zzjF(string)) {
                    return;
                }
                this.zzclX.zzj(null, string);
                this.zzclX.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzclX == null) {
                    this.zzclX = new zzbto(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzclX.zzj(hashMap, string);
                this.zzclX.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzclY.zzjG(string);
            }
            this.zzacc();
        }
        finally {
            this.zzclZ.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzclZ.writeLock().lock();
        try {
            boolean bl = this.zzclY.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzclY.zzbh(bl2);
            if (bl != bl2) {
                this.zzacc();
            }
        }
        finally {
            this.zzclZ.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzclZ.readLock().lock();
        try {
            if (this.zzclW != null && this.zzclW.zzaA(string, string2)) {
                byte[] byArray = this.zzclW.zzaB(string, string2);
                return byArray;
            }
            if (this.zzclX != null && this.zzclX.zzaA(string, string2)) {
                byte[] byArray = this.zzclX.zzaB(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.zzclZ.readLock().lock();
        try {
            if (this.zzclW != null && this.zzclW.zzaA(string, string2)) {
                String string3 = new String(this.zzclW.zzaB(string, string2), zzbtq.UTF_8);
                return string3;
            }
            if (this.zzclX != null && this.zzclX.zzaA(string, string2)) {
                String string4 = new String(this.zzclX.zzaB(string, string2), zzbtq.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzclZ.readLock().lock();
        try {
            String string3;
            if (this.zzclW != null && this.zzclW.zzaA(string, string2)) {
                string3 = new String(this.zzclW.zzaB(string, string2), zzbtq.UTF_8);
                if (zzbtq.zzaII.matcher(string3).matches()) {
                    return true;
                }
                if (zzbtq.zzaIJ.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzclX != null && this.zzclX.zzaA(string, string2)) {
                string3 = new String(this.zzclX.zzaB(string, string2), zzbtq.UTF_8);
                if (zzbtq.zzaII.matcher(string3).matches()) {
                    return true;
                }
                if (zzbtq.zzaIJ.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzbtq(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzclZ.readLock().lock();
        try {
            if (this.zzclW != null && this.zzclW.zzaA(string, string2)) {
                zzbtq zzbtq2 = new zzbtq(this.zzclW.zzaB(string, string2), 2);
                return zzbtq2;
            }
            if (this.zzclX != null && this.zzclX.zzaA(string, string2)) {
                zzbtq zzbtq3 = new zzbtq(this.zzclX.zzaB(string, string2), 1);
                return zzbtq3;
            }
            zzbtq zzbtq4 = new zzbtq(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzbtq4;
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        zzbtp zzbtp2 = new zzbtp();
        this.zzclZ.readLock().lock();
        try {
            long l = this.zzclV == null ? -1L : this.zzclV.getTimestamp();
            zzbtp2.zzaU(l);
            zzbtp2.zzqJ(this.zzclY.getLastFetchStatus());
            zzbtp2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzclY.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
        return zzbtp2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzclZ.readLock().lock();
        try {
            if (this.zzclW == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzclW.zzaC(string, string2);
            return set;
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
    }

    private void zzt(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private void zza(Context context, List<byte[]> list, long l) {
        this.zzt(new zzbtm(context, list, l));
    }

    private void zzacc() {
        this.zzclZ.readLock().lock();
        try {
            this.zzt(new zzbtn(this.mContext, this.zzclV, this.zzclW, this.zzclX, this.zzclY));
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> fetch(long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzclZ.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzadi.zza.zza zza2 = new zzadi.zza.zza();
            zza2.zzK(l);
            if (this.zzclY.isDeveloperModeEnabled()) {
                zza2.zzH("_rcn_developer", "true");
            }
            zza2.zzdr(10300);
            if (this.zzclW != null && this.zzclW.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzclW.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zza2.zzdt(n);
            }
            if (this.zzclV != null && this.zzclV.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzclV.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zza2.zzds(n);
            }
            PendingResult<zzadi.zzb> pendingResult = new zzado(this.mContext).zza(zza2.zzzD());
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<zzadi.zzb>(){

                public void zza(@NonNull zzadi.zzb zzb2) {
                    FirebaseRemoteConfig.this.zza((TaskCompletionSource<Void>)taskCompletionSource, zzb2);
                }

                public /* synthetic */ void onResult(@NonNull Result result) {
                    this.zza((zzadi.zzb)result);
                }
            });
        }
        finally {
            this.zzclZ.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void zza(TaskCompletionSource<Void> taskCompletionSource, zzadi.zzb zzb2) {
        if (zzb2 == null || zzb2.getStatus() == null) {
            this.zzclY.zzqJ(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzacc();
            return;
        }
        int n = zzb2.getStatus().getStatusCode();
        this.zzclZ.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzclY.zzqJ(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzacc();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzclY.zzqJ(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzb2.getThrottleEndTimeMillis())));
                    this.zzacc();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzclY.zzqJ(-1);
                    if (this.zzclV != null && !this.zzclV.zzacg()) {
                        Map<String, Set<String>> map = zzb2.zzzF();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzb2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzclV = new zzbto(hashMap, this.zzclV.getTimestamp(), zzb2.zzzE());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzacc();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzb2.zzzF();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzb2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzclV = new zzbto(hashMap, System.currentTimeMillis(), zzb2.zzzE());
                    this.zzclY.zzqJ(-1);
                    taskCompletionSource.setResult(null);
                    this.zzacc();
                    return;
                }
                default: {
                    if (zzb2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzclY.zzqJ(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzacc();
                    return;
                }
            }
        }
        finally {
            this.zzclZ.writeLock().unlock();
        }
    }
}

