/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.abe;
import com.google.android.gms.internal.abf;
import com.google.android.gms.internal.abg;
import com.google.android.gms.internal.abh;
import com.google.android.gms.internal.abi;
import com.google.android.gms.internal.abj;
import com.google.android.gms.internal.abk;
import com.google.android.gms.internal.abl;
import com.google.android.gms.internal.abm;
import com.google.android.gms.internal.abn;
import com.google.android.gms.internal.abo;
import com.google.android.gms.internal.abp;
import com.google.android.gms.internal.abq;
import com.google.android.gms.internal.adg;
import com.google.android.gms.internal.in;
import com.google.android.gms.internal.zzbhb;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzbhg;
import com.google.android.gms.internal.zzbhh;
import com.google.android.gms.internal.zzbhs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzcnh;
    private abh zzcni;
    private abh zzcnj;
    private abh zzcnk;
    private abk zzcnl;
    private final Context mContext;
    private final ReadWriteLock zzcnm = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, abh abh2, abh abh3, abh abh4, abk abk2) {
        this.mContext = context;
        this.zzcnl = abk2 != null ? abk2 : new abk();
        this.zzcnl.zzaL(this.zzbS(this.mContext));
        if (abh2 != null) {
            this.zzcni = abh2;
        }
        if (abh3 != null) {
            this.zzcnj = abh3;
        }
        if (abh4 != null) {
            this.zzcnk = abh4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzcnh == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzcnh == null) {
                abp abp2 = FirebaseRemoteConfig.zzbT(context);
                if (abp2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzcnh = new FirebaseRemoteConfig(context);
                } else {
                    abk abk2;
                    abk abk3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    abh abh2 = FirebaseRemoteConfig.zza(abp2.zzcnM);
                    abh abh3 = FirebaseRemoteConfig.zza(abp2.zzcnN);
                    abh abh4 = FirebaseRemoteConfig.zza(abp2.zzcnO);
                    abn abn2 = abp2.zzcnP;
                    if (abn2 == null) {
                        abk3 = null;
                    } else {
                        abk abk4 = new abk();
                        abk4.zzce(abn2.zzcnH);
                        abk4.zzaJ(abn2.zzcnI);
                        abk4.zzaM(abn2.zzcnJ);
                        abk3 = abk2 = abk4;
                    }
                    if (abk3 != null) {
                        abk2.zzH(FirebaseRemoteConfig.zza(abp2.zzcnQ));
                    }
                    zzcnh = new FirebaseRemoteConfig(context, abh2, abh3, abh4, abk2);
                }
            }
            return zzcnh;
        }
        return zzcnh;
    }

    private final long zzbS(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static abp zzbT(Context context) {
        abp abp2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            adg adg2 = adg.zzb((byte[])byArray, (int)0, (int)((Object)object).length);
            abp2 = new abp();
            abp2.zza(adg2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return abp2;
    }

    private static Map<String, abe> zza(abq[] abqArray) {
        HashMap<String, abe> hashMap = new HashMap<String, abe>();
        if (abqArray == null) {
            return hashMap;
        }
        abq[] abqArray2 = abqArray;
        int n = abqArray.length;
        for (int i = 0; i < n; ++i) {
            abq abq2 = abqArray2[i];
            String string = abq2.zzbxU;
            int n2 = abq2.resourceId;
            long l = abq2.zzcnS;
            hashMap.put(string, new abe(n2, l));
        }
        return hashMap;
    }

    private static abh zza(abl abl2) {
        Object object;
        if (abl2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = abl2.zzcnD;
        int n = abl2.zzcnD.length;
        for (int i = 0; i < n; ++i) {
            abo abo2 = object2[i];
            String string = abo2.zzbxU;
            object = new HashMap();
            abm[] abmArray = abo2.zzcnL;
            int n2 = abo2.zzcnL.length;
            for (int j = 0; j < n2; ++j) {
                abm abm2 = abmArray[j];
                object.put(abm2.key, abm2.zzcnG);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = abl2.zzcnE;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((abo[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new abh(hashMap, abl2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzcnm.writeLock().lock();
        try {
            if (this.zzcni == null) {
                return false;
            }
            if (this.zzcnj != null && this.zzcnj.getTimestamp() >= this.zzcni.getTimestamp()) {
                return false;
            }
            long l = this.zzcni.getTimestamp();
            this.zzcnj = this.zzcni;
            this.zzcnj.setTimestamp(System.currentTimeMillis());
            this.zzcni = new abh(null, l, null);
            long l2 = this.zzcnl.zzKJ();
            this.zzcnl.zzaM(in.zza(l2, this.zzcnj.zzss()));
            long l3 = l2;
            List<byte[]> list = this.zzcnj.zzss();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzr(new abf(context, list, l3));
            this.zzKC();
            return true;
        }
        finally {
            this.zzcnm.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzcnm.readLock().lock();
        try {
            if (this.zzcnl != null && this.zzcnl.zzKH() != null && this.zzcnl.zzKH().get(string) != null && n == ((abe)(object = this.zzcnl.zzKH().get(string))).zzKD() && this.zzcnl.zzKI() == ((abe)object).zzKE()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            abe abe2 = new abe(n, this.zzcnl.zzKI());
            this.zzcnl.zza(string, abe2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(abj.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(abj.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(abj.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(abj.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(abj.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(abj.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzcnm.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzcnk == null || !this.zzcnk.zzhH(string)) {
                    return;
                }
                this.zzcnk.zzh(null, string);
                this.zzcnk.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzcnk == null) {
                    this.zzcnk = new abh(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzcnk.zzh(hashMap, string);
                this.zzcnk.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzcnl.zzhI(string);
            }
            this.zzKC();
            return;
        }
        finally {
            this.zzcnm.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzcnm.writeLock().lock();
        try {
            boolean bl = this.zzcnl.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzcnl.zzaJ(bl2);
            if (bl != bl2) {
                this.zzKC();
            }
            return;
        }
        finally {
            this.zzcnm.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzcnm.readLock().lock();
        try {
            if (this.zzcnj != null && this.zzcnj.zzaj(string, string2)) {
                byte[] byArray = this.zzcnj.zzak(string, string2);
                return byArray;
            }
            if (this.zzcnk != null && this.zzcnk.zzaj(string, string2)) {
                byte[] byArray = this.zzcnk.zzak(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzcnm.readLock().lock();
            try {
                if (this.zzcnj == null || !this.zzcnj.zzaj(string, string2)) break block5;
                String string3 = new String(this.zzcnj.zzak(string, string2), abj.UTF_8);
                this.zzcnm.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzcnm.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzcnk != null && this.zzcnk.zzaj(string, string2)) {
            String string4 = new String(this.zzcnk.zzak(string, string2), abj.UTF_8);
            this.zzcnm.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzcnm.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzcnm.readLock().lock();
        try {
            String string3;
            if (this.zzcnj != null && this.zzcnj.zzaj(string, string2)) {
                string3 = new String(this.zzcnj.zzak(string, string2), abj.UTF_8);
                if (abj.zzaKs.matcher(string3).matches()) {
                    return true;
                }
                if (abj.zzaKt.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzcnk != null && this.zzcnk.zzaj(string, string2)) {
                string3 = new String(this.zzcnk.zzak(string, string2), abj.UTF_8);
                if (abj.zzaKs.matcher(string3).matches()) {
                    return true;
                }
                if (abj.zzaKt.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new abj(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzcnm.readLock().lock();
        try {
            if (this.zzcnj != null && this.zzcnj.zzaj(string, string2)) {
                abj abj2 = new abj(this.zzcnj.zzak(string, string2), 2);
                return abj2;
            }
            if (this.zzcnk != null && this.zzcnk.zzaj(string, string2)) {
                abj abj3 = new abj(this.zzcnk.zzak(string, string2), 1);
                return abj3;
            }
            abj abj4 = new abj(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return abj4;
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        abi abi2 = new abi();
        this.zzcnm.readLock().lock();
        try {
            long l = this.zzcni == null ? -1L : this.zzcni.getTimestamp();
            abi2.zzaK(l);
            abi2.zzce(this.zzcnl.getLastFetchStatus());
            abi2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzcnl.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
        return abi2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzcnm.readLock().lock();
        try {
            if (this.zzcnj == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzcnj.zzal(string, string2);
            return set;
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
    }

    private static void zzr(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzKC() {
        this.zzcnm.readLock().lock();
        try {
            FirebaseRemoteConfig.zzr(new abg(this.mContext, this.zzcni, this.zzcnj, this.zzcnk, this.zzcnl));
            return;
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcnm.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbhg zzbhg2 = new zzbhg();
            zzbhg2.zzA(l);
            if (this.zzcnl.isDeveloperModeEnabled()) {
                zzbhg2.zzA("_rcn_developer", "true");
            }
            zzbhg2.zzaE(10300);
            if (this.zzcnj != null && this.zzcnj.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzcnj.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbhg2.zzaG(n);
            }
            if (this.zzcni != null && this.zzcni.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzcni.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbhg2.zzaF(n);
            }
            zzbhf zzbhf2 = zzbhg2.zzsr();
            zzbhs zzbhs2 = new zzbhs(this.mContext);
            zzbhb.zzaKl.zza(zzbhs2.zzpi(), zzbhf2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzcnm.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbhh zzbhh2) {
        if (zzbhh2 == null || zzbhh2.getStatus() == null) {
            this.zzcnl.zzce(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzKC();
            return;
        }
        int n = zzbhh2.getStatus().getStatusCode();
        this.zzcnm.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzcnl.zzce(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzKC();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzcnl.zzce(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbhh2.getThrottleEndTimeMillis())));
                    this.zzKC();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzcnl.zzce(-1);
                    if (this.zzcni != null && !this.zzcni.zzKG()) {
                        Map<String, Set<String>> map = zzbhh2.zzst();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbhh2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzcni = new abh(hashMap, this.zzcni.getTimestamp(), zzbhh2.zzss());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzKC();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbhh2.zzst();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbhh2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzcni = new abh(hashMap, System.currentTimeMillis(), zzbhh2.zzss());
                    this.zzcnl.zzce(-1);
                    taskCompletionSource.setResult(null);
                    this.zzKC();
                    return;
                }
                default: {
                    if (zzbhh2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzcnl.zzce(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzKC();
                    return;
                }
            }
        }
        finally {
            this.zzcnm.writeLock().unlock();
        }
    }
}

