/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbdq;
import com.google.android.gms.internal.zzbdu;
import com.google.android.gms.internal.zzbdv;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbeh;
import com.google.android.gms.internal.zzdim;
import com.google.android.gms.internal.zzebd;
import com.google.android.gms.internal.zzebe;
import com.google.android.gms.internal.zzebf;
import com.google.android.gms.internal.zzebg;
import com.google.android.gms.internal.zzebh;
import com.google.android.gms.internal.zzebi;
import com.google.android.gms.internal.zzebj;
import com.google.android.gms.internal.zzebk;
import com.google.android.gms.internal.zzebl;
import com.google.android.gms.internal.zzebm;
import com.google.android.gms.internal.zzebn;
import com.google.android.gms.internal.zzebo;
import com.google.android.gms.internal.zzebp;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzmor;
    private zzebg zzmos;
    private zzebg zzmot;
    private zzebg zzmou;
    private zzebj zzmov;
    private final Context mContext;
    private final ReadWriteLock zzmow = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzebg zzebg2, zzebg zzebg3, zzebg zzebg4, zzebj zzebj2) {
        this.mContext = context;
        this.zzmov = zzebj2 != null ? zzebj2 : new zzebj();
        this.zzmov.zzck(this.zzev(this.mContext));
        if (zzebg2 != null) {
            this.zzmos = zzebg2;
        }
        if (zzebg3 != null) {
            this.zzmot = zzebg3;
        }
        if (zzebg4 != null) {
            this.zzmou = zzebg4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzmor == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzmor == null) {
                zzebo zzebo2 = FirebaseRemoteConfig.zzew(context);
                if (zzebo2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzmor = new FirebaseRemoteConfig(context);
                } else {
                    zzebj zzebj2;
                    zzebj zzebj3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzebg zzebg2 = FirebaseRemoteConfig.zza(zzebo2.zzmpw);
                    zzebg zzebg3 = FirebaseRemoteConfig.zza(zzebo2.zzmpx);
                    zzebg zzebg4 = FirebaseRemoteConfig.zza(zzebo2.zzmpy);
                    zzebm zzebm2 = zzebo2.zzmpz;
                    if (zzebm2 == null) {
                        zzebj3 = null;
                    } else {
                        zzebj zzebj4 = new zzebj();
                        zzebj4.zzgb(zzebm2.zzmpr);
                        zzebj4.zzck(zzebm2.zzmps);
                        zzebj4.zzcl(zzebm2.zzmpt);
                        zzebj3 = zzebj2 = zzebj4;
                    }
                    if (zzebj3 != null) {
                        zzebj2.zzai(FirebaseRemoteConfig.zza(zzebo2.zzmqa));
                    }
                    zzmor = new FirebaseRemoteConfig(context, zzebg2, zzebg3, zzebg4, zzebj2);
                }
            }
            return zzmor;
        }
        return zzmor;
    }

    private final long zzev(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzebo zzew(Context context) {
        zzebo zzebo2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzegf zzegf2 = zzegf.zzh((byte[])byArray, (int)0, (int)((Object)object).length);
            zzebo2 = new zzebo();
            zzebo2.zza(zzegf2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzebo2;
    }

    private static Map<String, zzebd> zza(zzebp[] zzebpArray) {
        HashMap<String, zzebd> hashMap = new HashMap<String, zzebd>();
        if (zzebpArray == null) {
            return hashMap;
        }
        zzebp[] zzebpArray2 = zzebpArray;
        int n = zzebpArray.length;
        for (int i = 0; i < n; ++i) {
            zzebp zzebp2 = zzebpArray2[i];
            String string = zzebp2.zzjdp;
            int n2 = zzebp2.resourceId;
            long l = zzebp2.zzmqc;
            hashMap.put(string, new zzebd(n2, l));
        }
        return hashMap;
    }

    private static zzebg zza(zzebk zzebk2) {
        Object object;
        if (zzebk2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzebk2.zzmpn;
        int n = zzebk2.zzmpn.length;
        for (int i = 0; i < n; ++i) {
            zzebn zzebn2 = object2[i];
            String string = zzebn2.zzjdp;
            object = new HashMap();
            zzebl[] zzeblArray = zzebn2.zzmpv;
            int n2 = zzebn2.zzmpv.length;
            for (int j = 0; j < n2; ++j) {
                zzebl zzebl2 = zzeblArray[j];
                object.put(zzebl2.key, zzebl2.zzmpq);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzebk2.zzmpo;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzebn[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzebg(hashMap, zzebk2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzmow.writeLock().lock();
        try {
            if (this.zzmos == null) {
                return false;
            }
            if (this.zzmot != null && this.zzmot.getTimestamp() >= this.zzmos.getTimestamp()) {
                return false;
            }
            long l = this.zzmos.getTimestamp();
            this.zzmot = this.zzmos;
            this.zzmot.setTimestamp(System.currentTimeMillis());
            this.zzmos = new zzebg(null, l, null);
            long l2 = this.zzmov.zzbzz();
            this.zzmov.zzcl(zzdim.zza(l2, this.zzmot.zzalx()));
            long l3 = l2;
            List<byte[]> list = this.zzmot.zzalx();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzo(new zzebe(context, list, l3));
            this.zzbzs();
            return true;
        }
        finally {
            this.zzmow.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzmow.readLock().lock();
        try {
            if (this.zzmov != null && this.zzmov.zzbzx() != null && this.zzmov.zzbzx().get(string) != null && n == ((zzebd)(object = this.zzmov.zzbzx().get(string))).zzbzt() && this.zzmov.zzbzy() == ((zzebd)object).zzbzu()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzmow.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzebd zzebd2 = new zzebd(n, this.zzmov.zzbzy());
            this.zzmov.zza(string, zzebd2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzebi.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzebi.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzebi.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzebi.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzebi.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzebi.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzmow.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzmou == null || !this.zzmou.zzqq(string)) {
                    return;
                }
                this.zzmou.zzh(null, string);
                this.zzmou.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzmou == null) {
                    this.zzmou = new zzebg(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzmou.zzh(hashMap, string);
                this.zzmou.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzmov.zzqr(string);
            }
            this.zzbzs();
            return;
        }
        finally {
            this.zzmow.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzmow.writeLock().lock();
        try {
            boolean bl = this.zzmov.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzmov.zzck(bl2);
            if (bl != bl2) {
                this.zzbzs();
            }
            return;
        }
        finally {
            this.zzmow.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzmow.readLock().lock();
        try {
            if (this.zzmot != null && this.zzmot.zzbm(string, string2)) {
                byte[] byArray = this.zzmot.zzbn(string, string2);
                return byArray;
            }
            if (this.zzmou != null && this.zzmou.zzbm(string, string2)) {
                byte[] byArray = this.zzmou.zzbn(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzmow.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzmow.readLock().lock();
            try {
                if (this.zzmot == null || !this.zzmot.zzbm(string, string2)) break block5;
                String string3 = new String(this.zzmot.zzbn(string, string2), zzebi.UTF_8);
                this.zzmow.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzmow.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzmou != null && this.zzmou.zzbm(string, string2)) {
            String string4 = new String(this.zzmou.zzbn(string, string2), zzebi.UTF_8);
            this.zzmow.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzmow.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzmow.readLock().lock();
        try {
            String string3;
            if (this.zzmot != null && this.zzmot.zzbm(string, string2)) {
                string3 = new String(this.zzmot.zzbn(string, string2), zzebi.UTF_8);
                if (zzebi.zzfzv.matcher(string3).matches()) {
                    return true;
                }
                if (zzebi.zzfzw.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzmou != null && this.zzmou.zzbm(string, string2)) {
                string3 = new String(this.zzmou.zzbn(string, string2), zzebi.UTF_8);
                if (zzebi.zzfzv.matcher(string3).matches()) {
                    return true;
                }
                if (zzebi.zzfzw.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzmow.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzebi(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzmow.readLock().lock();
        try {
            if (this.zzmot != null && this.zzmot.zzbm(string, string2)) {
                zzebi zzebi2 = new zzebi(this.zzmot.zzbn(string, string2), 2);
                return zzebi2;
            }
            if (this.zzmou != null && this.zzmou.zzbm(string, string2)) {
                zzebi zzebi3 = new zzebi(this.zzmou.zzbn(string, string2), 1);
                return zzebi3;
            }
            zzebi zzebi4 = new zzebi(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzebi4;
        }
        finally {
            this.zzmow.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzebh zzebh2 = new zzebh();
        this.zzmow.readLock().lock();
        try {
            long l = this.zzmos == null ? -1L : this.zzmos.getTimestamp();
            zzebh2.zzcj(l);
            zzebh2.zzgb(this.zzmov.getLastFetchStatus());
            zzebh2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzmov.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzmow.readLock().unlock();
        }
        return zzebh2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzmow.readLock().lock();
        try {
            if (this.zzmot == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzmot.zzbo(string, string2);
            return set;
        }
        finally {
            this.zzmow.readLock().unlock();
        }
    }

    private static void zzo(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzbzs() {
        this.zzmow.readLock().lock();
        try {
            FirebaseRemoteConfig.zzo(new zzebf(this.mContext, this.zzmos, this.zzmot, this.zzmou, this.zzmov));
            return;
        }
        finally {
            this.zzmow.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzmow.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbdv zzbdv2 = new zzbdv();
            zzbdv2.zzaa(l);
            if (this.zzmov.isDeveloperModeEnabled()) {
                zzbdv2.zzaa("_rcn_developer", "true");
            }
            zzbdv2.zzch(10300);
            if (this.zzmot != null && this.zzmot.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzmot.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbdv2.zzcj(n);
            }
            if (this.zzmos != null && this.zzmos.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzmos.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbdv2.zzci(n);
            }
            zzbdu zzbdu2 = zzbdv2.zzalw();
            zzbeh zzbeh2 = new zzbeh(this.mContext);
            zzbdq.zzfzo.zza(zzbeh2.zzafk(), zzbdu2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzmow.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbdw zzbdw2) {
        if (zzbdw2 == null || zzbdw2.getStatus() == null) {
            this.zzmov.zzgb(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzbzs();
            return;
        }
        int n = zzbdw2.getStatus().getStatusCode();
        this.zzmow.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzmov.zzgb(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzbzs();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzmov.zzgb(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbdw2.getThrottleEndTimeMillis())));
                    this.zzbzs();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzmov.zzgb(-1);
                    if (this.zzmos != null && !this.zzmos.zzbzw()) {
                        Map<String, Set<String>> map = zzbdw2.zzaly();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbdw2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzmos = new zzebg(hashMap, this.zzmos.getTimestamp(), zzbdw2.zzalx());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzbzs();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbdw2.zzaly();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbdw2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzmos = new zzebg(hashMap, System.currentTimeMillis(), zzbdw2.zzalx());
                    this.zzmov.zzgb(-1);
                    taskCompletionSource.setResult(null);
                    this.zzbzs();
                    return;
                }
                default: {
                    if (zzbdw2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzmov.zzgb(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzbzs();
                    return;
                }
            }
        }
        finally {
            this.zzmow.writeLock().unlock();
        }
    }
}

