/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbev;
import com.google.android.gms.internal.zzdix;
import com.google.android.gms.internal.zzebu;
import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzebw;
import com.google.android.gms.internal.zzebx;
import com.google.android.gms.internal.zzeby;
import com.google.android.gms.internal.zzebz;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzecb;
import com.google.android.gms.internal.zzecc;
import com.google.android.gms.internal.zzecd;
import com.google.android.gms.internal.zzece;
import com.google.android.gms.internal.zzecf;
import com.google.android.gms.internal.zzecg;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzmrx;
    private zzebx zzmry;
    private zzebx zzmrz;
    private zzebx zzmsa;
    private zzeca zzmsb;
    private final Context mContext;
    private final ReadWriteLock zzmsc = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzebx zzebx2, zzebx zzebx3, zzebx zzebx4, zzeca zzeca2) {
        this.mContext = context;
        this.zzmsb = zzeca2 != null ? zzeca2 : new zzeca();
        this.zzmsb.zzck(this.zzew(this.mContext));
        if (zzebx2 != null) {
            this.zzmry = zzebx2;
        }
        if (zzebx3 != null) {
            this.zzmrz = zzebx3;
        }
        if (zzebx4 != null) {
            this.zzmsa = zzebx4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzmrx == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzmrx == null) {
                zzecf zzecf2 = FirebaseRemoteConfig.zzex(context);
                if (zzecf2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzmrx = new FirebaseRemoteConfig(context);
                } else {
                    zzeca zzeca2;
                    zzeca zzeca3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzebx zzebx2 = FirebaseRemoteConfig.zza(zzecf2.zzmtc);
                    zzebx zzebx3 = FirebaseRemoteConfig.zza(zzecf2.zzmtd);
                    zzebx zzebx4 = FirebaseRemoteConfig.zza(zzecf2.zzmte);
                    zzecd zzecd2 = zzecf2.zzmtf;
                    if (zzecd2 == null) {
                        zzeca3 = null;
                    } else {
                        zzeca zzeca4 = new zzeca();
                        zzeca4.zzgd(zzecd2.zzmsx);
                        zzeca4.zzcm(zzecd2.zzmsy);
                        zzeca4.zzcl(zzecd2.zzmsz);
                        zzeca3 = zzeca2 = zzeca4;
                    }
                    if (zzeca3 != null) {
                        zzeca2.zzai(FirebaseRemoteConfig.zza(zzecf2.zzmtg));
                    }
                    zzmrx = new FirebaseRemoteConfig(context, zzebx2, zzebx3, zzebx4, zzeca2);
                }
            }
            return zzmrx;
        }
        return zzmrx;
    }

    private final long zzew(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzecf zzex(Context context) {
        zzecf zzecf2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzegx zzegx2 = zzegx.zzh((byte[])byArray, (int)0, (int)((Object)object).length);
            zzecf2 = new zzecf();
            zzecf2.zza(zzegx2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzecf2;
    }

    private static Map<String, zzebu> zza(zzecg[] zzecgArray) {
        HashMap<String, zzebu> hashMap = new HashMap<String, zzebu>();
        if (zzecgArray == null) {
            return hashMap;
        }
        zzecg[] zzecgArray2 = zzecgArray;
        int n = zzecgArray.length;
        for (int i = 0; i < n; ++i) {
            zzecg zzecg2 = zzecgArray2[i];
            String string = zzecg2.zzjdy;
            int n2 = zzecg2.resourceId;
            long l = zzecg2.zzmti;
            hashMap.put(string, new zzebu(n2, l));
        }
        return hashMap;
    }

    private static zzebx zza(zzecb zzecb2) {
        Object object;
        if (zzecb2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzecb2.zzmst;
        int n = zzecb2.zzmst.length;
        for (int i = 0; i < n; ++i) {
            zzece zzece2 = object2[i];
            String string = zzece2.zzjdy;
            object = new HashMap();
            zzecc[] zzeccArray = zzece2.zzmtb;
            int n2 = zzece2.zzmtb.length;
            for (int j = 0; j < n2; ++j) {
                zzecc zzecc2 = zzeccArray[j];
                object.put(zzecc2.key, zzecc2.zzmsw);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzecb2.zzmsu;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzece[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzebx(hashMap, zzecb2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzmsc.writeLock().lock();
        try {
            if (this.zzmry == null) {
                return false;
            }
            if (this.zzmrz != null && this.zzmrz.getTimestamp() >= this.zzmry.getTimestamp()) {
                return false;
            }
            long l = this.zzmry.getTimestamp();
            this.zzmrz = this.zzmry;
            this.zzmrz.setTimestamp(System.currentTimeMillis());
            this.zzmry = new zzebx(null, l, null);
            long l2 = this.zzmsb.zzcag();
            this.zzmsb.zzcl(zzdix.zza(l2, this.zzmrz.zzaly()));
            long l3 = l2;
            List<byte[]> list = this.zzmrz.zzaly();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzo(new zzebv(context, list, l3));
            this.zzbzz();
            return true;
        }
        finally {
            this.zzmsc.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzmsc.readLock().lock();
        try {
            if (this.zzmsb != null && this.zzmsb.zzcae() != null && this.zzmsb.zzcae().get(string) != null && n == ((zzebu)(object = this.zzmsb.zzcae().get(string))).zzcaa() && this.zzmsb.zzcaf() == ((zzebu)object).zzcab()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzebu zzebu2 = new zzebu(n, this.zzmsb.zzcaf());
            this.zzmsb.zza(string, zzebu2);
            this.zzd((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzd(map, string, true);
    }

    private final void zzd(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzebz.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzebz.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzebz.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzebz.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzebz.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzebz.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzmsc.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzmsa == null || !this.zzmsa.zzqy(string)) {
                    return;
                }
                this.zzmsa.zzh(null, string);
                this.zzmsa.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzmsa == null) {
                    this.zzmsa = new zzebx(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzmsa.zzh(hashMap, string);
                this.zzmsa.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzmsb.zzqz(string);
            }
            this.zzbzz();
            return;
        }
        finally {
            this.zzmsc.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzmsc.writeLock().lock();
        try {
            boolean bl = this.zzmsb.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzmsb.zzcm(bl2);
            if (bl != bl2) {
                this.zzbzz();
            }
            return;
        }
        finally {
            this.zzmsc.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzmsc.readLock().lock();
        try {
            if (this.zzmrz != null && this.zzmrz.zzbl(string, string2)) {
                byte[] byArray = this.zzmrz.zzbm(string, string2);
                return byArray;
            }
            if (this.zzmsa != null && this.zzmsa.zzbl(string, string2)) {
                byte[] byArray = this.zzmsa.zzbm(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzmsc.readLock().lock();
            try {
                if (this.zzmrz == null || !this.zzmrz.zzbl(string, string2)) break block5;
                String string3 = new String(this.zzmrz.zzbm(string, string2), zzebz.UTF_8);
                this.zzmsc.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzmsc.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzmsa != null && this.zzmsa.zzbl(string, string2)) {
            String string4 = new String(this.zzmsa.zzbm(string, string2), zzebz.UTF_8);
            this.zzmsc.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzmsc.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzmsc.readLock().lock();
        try {
            String string3;
            if (this.zzmrz != null && this.zzmrz.zzbl(string, string2)) {
                string3 = new String(this.zzmrz.zzbm(string, string2), zzebz.UTF_8);
                if (zzebz.zzgaa.matcher(string3).matches()) {
                    return true;
                }
                if (zzebz.zzgab.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzmsa != null && this.zzmsa.zzbl(string, string2)) {
                string3 = new String(this.zzmsa.zzbm(string, string2), zzebz.UTF_8);
                if (zzebz.zzgaa.matcher(string3).matches()) {
                    return true;
                }
                if (zzebz.zzgab.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzebz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzmsc.readLock().lock();
        try {
            if (this.zzmrz != null && this.zzmrz.zzbl(string, string2)) {
                zzebz zzebz2 = new zzebz(this.zzmrz.zzbm(string, string2), 2);
                return zzebz2;
            }
            if (this.zzmsa != null && this.zzmsa.zzbl(string, string2)) {
                zzebz zzebz3 = new zzebz(this.zzmsa.zzbm(string, string2), 1);
                return zzebz3;
            }
            zzebz zzebz4 = new zzebz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzebz4;
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzeby zzeby2 = new zzeby();
        this.zzmsc.readLock().lock();
        try {
            long l = this.zzmry == null ? -1L : this.zzmry.getTimestamp();
            zzeby2.zzcj(l);
            zzeby2.zzgd(this.zzmsb.getLastFetchStatus());
            zzeby2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzmsb.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
        return zzeby2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzmsc.readLock().lock();
        try {
            if (this.zzmrz == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzmrz.zzbn(string, string2);
            return set;
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
    }

    private static void zzo(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzbzz() {
        this.zzmsc.readLock().lock();
        try {
            FirebaseRemoteConfig.zzo(new zzebw(this.mContext, this.zzmry, this.zzmrz, this.zzmsa, this.zzmsb));
            return;
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzmsc.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbej zzbej2 = new zzbej();
            zzbej2.zzaa(l);
            if (this.zzmsb.isDeveloperModeEnabled()) {
                zzbej2.zzy("_rcn_developer", "true");
            }
            zzbej2.zzci(10300);
            if (this.zzmrz != null && this.zzmrz.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzmrz.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbej2.zzck(n);
            }
            if (this.zzmry != null && this.zzmry.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzmry.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbej2.zzcj(n);
            }
            zzbei zzbei2 = zzbej2.zzalx();
            zzbev zzbev2 = new zzbev(this.mContext);
            zzbee.zzfzt.zza(zzbev2.zzafl(), zzbei2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzmsc.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbek zzbek2) {
        if (zzbek2 == null || zzbek2.getStatus() == null) {
            this.zzmsb.zzgd(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzbzz();
            return;
        }
        int n = zzbek2.getStatus().getStatusCode();
        this.zzmsc.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzmsb.zzgd(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzbzz();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzmsb.zzgd(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbek2.getThrottleEndTimeMillis())));
                    this.zzbzz();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzmsb.zzgd(-1);
                    if (this.zzmry != null && !this.zzmry.zzcad()) {
                        Map<String, Set<String>> map = zzbek2.zzalz();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbek2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzmry = new zzebx(hashMap, this.zzmry.getTimestamp(), zzbek2.zzaly());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzbzz();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbek2.zzalz();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbek2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzmry = new zzebx(hashMap, System.currentTimeMillis(), zzbek2.zzaly());
                    this.zzmsb.zzgd(-1);
                    taskCompletionSource.setResult(null);
                    this.zzbzz();
                    return;
                }
                default: {
                    if (zzbek2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzmsb.zzgd(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzbzz();
                    return;
                }
            }
        }
        finally {
            this.zzmsc.writeLock().unlock();
        }
    }
}

