/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbev;
import com.google.android.gms.internal.zzdjx;
import com.google.android.gms.internal.zzema;
import com.google.android.gms.internal.zzemb;
import com.google.android.gms.internal.zzemc;
import com.google.android.gms.internal.zzemd;
import com.google.android.gms.internal.zzeme;
import com.google.android.gms.internal.zzemf;
import com.google.android.gms.internal.zzemg;
import com.google.android.gms.internal.zzemh;
import com.google.android.gms.internal.zzemi;
import com.google.android.gms.internal.zzemj;
import com.google.android.gms.internal.zzemk;
import com.google.android.gms.internal.zzeml;
import com.google.android.gms.internal.zzemm;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zznlx;
    private zzemd zznly;
    private zzemd zznlz;
    private zzemd zznma;
    private zzemg zznmb;
    private final Context mContext;
    private final ReadWriteLock zznmc = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzemd zzemd2, zzemd zzemd3, zzemd zzemd4, zzemg zzemg2) {
        this.mContext = context;
        this.zznmb = zzemg2 != null ? zzemg2 : new zzemg();
        this.zznmb.zzcl(this.zzew(this.mContext));
        if (zzemd2 != null) {
            this.zznly = zzemd2;
        }
        if (zzemd3 != null) {
            this.zznlz = zzemd3;
        }
        if (zzemd4 != null) {
            this.zznma = zzemd4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zznlx == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zznlx == null) {
                zzeml zzeml2 = FirebaseRemoteConfig.zzex(context);
                if (zzeml2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zznlx = new FirebaseRemoteConfig(context);
                } else {
                    zzemg zzemg2;
                    zzemg zzemg3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzemd zzemd2 = FirebaseRemoteConfig.zza(zzeml2.zznnc);
                    zzemd zzemd3 = FirebaseRemoteConfig.zza(zzeml2.zznnd);
                    zzemd zzemd4 = FirebaseRemoteConfig.zza(zzeml2.zznne);
                    zzemj zzemj2 = zzeml2.zznnf;
                    if (zzemj2 == null) {
                        zzemg3 = null;
                    } else {
                        zzemg zzemg4 = new zzemg();
                        zzemg4.zzhp(zzemj2.zznmx);
                        zzemg4.zzcp(zzemj2.zznmy);
                        zzemg4.zzcm(zzemj2.zznmz);
                        zzemg3 = zzemg2 = zzemg4;
                    }
                    if (zzemg3 != null) {
                        zzemg2.zzal(FirebaseRemoteConfig.zza(zzeml2.zznng));
                    }
                    zznlx = new FirebaseRemoteConfig(context, zzemd2, zzemd3, zzemd4, zzemg2);
                }
            }
            return zznlx;
        }
        return zznlx;
    }

    private final long zzew(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzeml zzex(Context context) {
        zzeml zzeml2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzeye zzeye2 = zzeye.zzm((byte[])byArray, (int)0, (int)((Object)object).length);
            zzeml2 = new zzeml();
            zzeml2.zza(zzeye2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzeml2;
    }

    private static Map<String, zzema> zza(zzemm[] zzemmArray) {
        HashMap<String, zzema> hashMap = new HashMap<String, zzema>();
        if (zzemmArray == null) {
            return hashMap;
        }
        zzemm[] zzemmArray2 = zzemmArray;
        int n = zzemmArray.length;
        for (int i = 0; i < n; ++i) {
            zzemm zzemm2 = zzemmArray2[i];
            String string = zzemm2.zzjdy;
            int n2 = zzemm2.resourceId;
            long l = zzemm2.zznni;
            hashMap.put(string, new zzema(n2, l));
        }
        return hashMap;
    }

    private static zzemd zza(zzemh zzemh2) {
        Object object;
        if (zzemh2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzemh2.zznmt;
        int n = zzemh2.zznmt.length;
        for (int i = 0; i < n; ++i) {
            zzemk zzemk2 = object2[i];
            String string = zzemk2.zzjdy;
            object = new HashMap();
            zzemi[] zzemiArray = zzemk2.zznnb;
            int n2 = zzemk2.zznnb.length;
            for (int j = 0; j < n2; ++j) {
                zzemi zzemi2 = zzemiArray[j];
                object.put(zzemi2.key, zzemi2.zznmw);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzemh2.zznmu;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzemk[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzemd(hashMap, zzemh2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zznmc.writeLock().lock();
        try {
            if (this.zznly == null) {
                return false;
            }
            if (this.zznlz != null && this.zznlz.getTimestamp() >= this.zznly.getTimestamp()) {
                return false;
            }
            long l = this.zznly.getTimestamp();
            this.zznlz = this.zznly;
            this.zznlz.setTimestamp(System.currentTimeMillis());
            this.zznly = new zzemd(null, l, null);
            long l2 = this.zznmb.zzchs();
            this.zznmb.zzcm(zzdjx.zza(l2, this.zznlz.zzalx()));
            long l3 = l2;
            List<byte[]> list = this.zznlz.zzalx();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzp(new zzemb(context, list, l3));
            this.zzchl();
            return true;
        }
        finally {
            this.zznmc.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zznmc.readLock().lock();
        try {
            if (this.zznmb != null && this.zznmb.zzchq() != null && this.zznmb.zzchq().get(string) != null && n == ((zzema)(object = this.zznmb.zzchq().get(string))).zzchm() && this.zznmb.zzchr() == ((zzema)object).zzchn()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zznmc.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzema zzema2 = new zzema(n, this.zznmb.zzchr());
            this.zznmb.zza(string, zzema2);
            this.zzd((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzd(map, string, true);
    }

    private final void zzd(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzemf.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzemf.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzemf.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzemf.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzemf.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzemf.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zznmc.writeLock().lock();
        try {
            if (bl2) {
                if (this.zznma == null || !this.zznma.zzru(string)) {
                    return;
                }
                this.zznma.zzh(null, string);
                this.zznma.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zznma == null) {
                    this.zznma = new zzemd(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zznma.zzh(hashMap, string);
                this.zznma.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zznmb.zzrv(string);
            }
            this.zzchl();
            return;
        }
        finally {
            this.zznmc.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zznmc.writeLock().lock();
        try {
            boolean bl = this.zznmb.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zznmb.zzcp(bl2);
            if (bl != bl2) {
                this.zzchl();
            }
            return;
        }
        finally {
            this.zznmc.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zznmc.readLock().lock();
        try {
            if (this.zznlz != null && this.zznlz.zzbm(string, string2)) {
                byte[] byArray = this.zznlz.zzbn(string, string2);
                return byArray;
            }
            if (this.zznma != null && this.zznma.zzbm(string, string2)) {
                byte[] byArray = this.zznma.zzbn(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zznmc.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zznmc.readLock().lock();
            try {
                if (this.zznlz == null || !this.zznlz.zzbm(string, string2)) break block5;
                String string3 = new String(this.zznlz.zzbn(string, string2), zzemf.UTF_8);
                this.zznmc.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zznmc.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zznma != null && this.zznma.zzbm(string, string2)) {
            String string4 = new String(this.zznma.zzbn(string, string2), zzemf.UTF_8);
            this.zznmc.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zznmc.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zznmc.readLock().lock();
        try {
            String string3;
            if (this.zznlz != null && this.zznlz.zzbm(string, string2)) {
                string3 = new String(this.zznlz.zzbn(string, string2), zzemf.UTF_8);
                if (zzemf.zzgab.matcher(string3).matches()) {
                    return true;
                }
                if (zzemf.zzgac.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zznma != null && this.zznma.zzbm(string, string2)) {
                string3 = new String(this.zznma.zzbn(string, string2), zzemf.UTF_8);
                if (zzemf.zzgab.matcher(string3).matches()) {
                    return true;
                }
                if (zzemf.zzgac.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zznmc.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzemf(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zznmc.readLock().lock();
        try {
            if (this.zznlz != null && this.zznlz.zzbm(string, string2)) {
                zzemf zzemf2 = new zzemf(this.zznlz.zzbn(string, string2), 2);
                return zzemf2;
            }
            if (this.zznma != null && this.zznma.zzbm(string, string2)) {
                zzemf zzemf3 = new zzemf(this.zznma.zzbn(string, string2), 1);
                return zzemf3;
            }
            zzemf zzemf4 = new zzemf(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzemf4;
        }
        finally {
            this.zznmc.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzeme zzeme2 = new zzeme();
        this.zznmc.readLock().lock();
        try {
            long l = this.zznly == null ? -1L : this.zznly.getTimestamp();
            zzeme2.zzck(l);
            zzeme2.zzhp(this.zznmb.getLastFetchStatus());
            zzeme2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zznmb.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zznmc.readLock().unlock();
        }
        return zzeme2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zznmc.readLock().lock();
        try {
            if (this.zznlz == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zznlz.zzbo(string, string2);
            return set;
        }
        finally {
            this.zznmc.readLock().unlock();
        }
    }

    private static void zzp(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzchl() {
        this.zznmc.readLock().lock();
        try {
            FirebaseRemoteConfig.zzp(new zzemc(this.mContext, this.zznly, this.zznlz, this.zznma, this.zznmb));
            return;
        }
        finally {
            this.zznmc.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zznmc.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbej zzbej2 = new zzbej();
            zzbej2.zzaa(l);
            if (this.zznmb.isDeveloperModeEnabled()) {
                zzbej2.zzy("_rcn_developer", "true");
            }
            zzbej2.zzci(10300);
            if (this.zznlz != null && this.zznlz.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zznlz.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbej2.zzck(n);
            }
            if (this.zznly != null && this.zznly.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zznly.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbej2.zzcj(n);
            }
            zzbei zzbei2 = zzbej2.zzalw();
            zzbev zzbev2 = new zzbev(this.mContext);
            zzbee.zzfzu.zza(zzbev2.zzafl(), zzbei2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zznmc.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbek zzbek2) {
        if (zzbek2 == null || zzbek2.getStatus() == null) {
            this.zznmb.zzhp(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzchl();
            return;
        }
        int n = zzbek2.getStatus().getStatusCode();
        this.zznmc.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zznmb.zzhp(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzchl();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zznmb.zzhp(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbek2.getThrottleEndTimeMillis())));
                    this.zzchl();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zznmb.zzhp(-1);
                    if (this.zznly != null && !this.zznly.zzchp()) {
                        Map<String, Set<String>> map = zzbek2.zzaly();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbek2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zznly = new zzemd(hashMap, this.zznly.getTimestamp(), zzbek2.zzalx());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzchl();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbek2.zzaly();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbek2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zznly = new zzemd(hashMap, System.currentTimeMillis(), zzbek2.zzalx());
                    this.zznmb.zzhp(-1);
                    taskCompletionSource.setResult(null);
                    this.zzchl();
                    return;
                }
                default: {
                    if (zzbek2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zznmb.zzhp(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzchl();
                    return;
                }
            }
        }
        finally {
            this.zznmc.writeLock().unlock();
        }
    }
}

