/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbgd;
import com.google.android.gms.internal.zzbgh;
import com.google.android.gms.internal.zzbgi;
import com.google.android.gms.internal.zzbgj;
import com.google.android.gms.internal.zzbgu;
import com.google.android.gms.internal.zzdtm;
import com.google.android.gms.internal.zzevq;
import com.google.android.gms.internal.zzevr;
import com.google.android.gms.internal.zzevs;
import com.google.android.gms.internal.zzevt;
import com.google.android.gms.internal.zzevu;
import com.google.android.gms.internal.zzevv;
import com.google.android.gms.internal.zzevw;
import com.google.android.gms.internal.zzevx;
import com.google.android.gms.internal.zzevy;
import com.google.android.gms.internal.zzevz;
import com.google.android.gms.internal.zzewa;
import com.google.android.gms.internal.zzewb;
import com.google.android.gms.internal.zzewc;
import com.google.android.gms.internal.zzfhb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzobm;
    private zzevt zzobn;
    private zzevt zzobo;
    private zzevt zzobp;
    private zzevw zzobq;
    private final Context mContext;
    private final ReadWriteLock zzobr = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzevt zzevt2, zzevt zzevt3, zzevt zzevt4, zzevw zzevw2) {
        this.mContext = context;
        this.zzobq = zzevw2 != null ? zzevw2 : new zzevw();
        this.zzobq.zzcm(this.zzfd(this.mContext));
        if (zzevt2 != null) {
            this.zzobn = zzevt2;
        }
        if (zzevt3 != null) {
            this.zzobo = zzevt3;
        }
        if (zzevt4 != null) {
            this.zzobp = zzevt4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzobm == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzobm == null) {
                zzewb zzewb2 = FirebaseRemoteConfig.zzfe(context);
                if (zzewb2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzobm = new FirebaseRemoteConfig(context);
                } else {
                    zzevw zzevw2;
                    zzevw zzevw3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzevt zzevt2 = FirebaseRemoteConfig.zza(zzewb2.zzocr);
                    zzevt zzevt3 = FirebaseRemoteConfig.zza(zzewb2.zzocs);
                    zzevt zzevt4 = FirebaseRemoteConfig.zza(zzewb2.zzoct);
                    zzevz zzevz2 = zzewb2.zzocu;
                    if (zzevz2 == null) {
                        zzevw3 = null;
                    } else {
                        zzevw zzevw4 = new zzevw();
                        zzevw4.zzhy(zzevz2.zzocm);
                        zzevw4.zzcs(zzevz2.zzocn);
                        zzevw4.zzcn(zzevz2.zzoco);
                        zzevw3 = zzevw2 = zzevw4;
                    }
                    if (zzevw3 != null) {
                        zzevw2.zzar(FirebaseRemoteConfig.zza(zzewb2.zzocv));
                    }
                    zzobm = new FirebaseRemoteConfig(context, zzevt2, zzevt3, zzevt4, zzevw2);
                }
            }
            return zzobm;
        }
        return zzobm;
    }

    private final long zzfd(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzewb zzfe(Context context) {
        zzewb zzewb2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzfhb zzfhb2 = zzfhb.zzn((byte[])byArray, (int)0, (int)((Object)object).length);
            zzewb2 = new zzewb();
            zzewb2.zza(zzfhb2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzewb2;
    }

    private static Map<String, zzevq> zza(zzewc[] zzewcArray) {
        HashMap<String, zzevq> hashMap = new HashMap<String, zzevq>();
        if (zzewcArray == null) {
            return hashMap;
        }
        zzewc[] zzewcArray2 = zzewcArray;
        int n = zzewcArray.length;
        for (int i = 0; i < n; ++i) {
            zzewc zzewc2 = zzewcArray2[i];
            String string = zzewc2.zzjon;
            int n2 = zzewc2.resourceId;
            long l = zzewc2.zzocx;
            hashMap.put(string, new zzevq(n2, l));
        }
        return hashMap;
    }

    private static zzevt zza(zzevx zzevx2) {
        Object object;
        if (zzevx2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzevx2.zzoci;
        int n = zzevx2.zzoci.length;
        for (int i = 0; i < n; ++i) {
            zzewa zzewa2 = object2[i];
            String string = zzewa2.zzjon;
            object = new HashMap();
            zzevy[] zzevyArray = zzewa2.zzocq;
            int n2 = zzewa2.zzocq.length;
            for (int j = 0; j < n2; ++j) {
                zzevy zzevy2 = zzevyArray[j];
                object.put(zzevy2.key, zzevy2.zzocl);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzevx2.zzocj;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzewa[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzevt(hashMap, zzevx2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzobr.writeLock().lock();
        try {
            if (this.zzobn == null) {
                return false;
            }
            if (this.zzobo != null && this.zzobo.getTimestamp() >= this.zzobn.getTimestamp()) {
                return false;
            }
            long l = this.zzobn.getTimestamp();
            this.zzobo = this.zzobn;
            this.zzobo.setTimestamp(System.currentTimeMillis());
            this.zzobn = new zzevt(null, l, null);
            long l2 = this.zzobq.zzcji();
            this.zzobq.zzcn(zzdtm.zza(l2, this.zzobo.zzamp()));
            long l3 = l2;
            List<byte[]> list = this.zzobo.zzamp();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzr(new zzevr(context, list, l3));
            this.zzcjc();
            return true;
        }
        finally {
            this.zzobr.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzobr.readLock().lock();
        try {
            if (this.zzobq != null && this.zzobq.zzcjg() != null && this.zzobq.zzcjg().get(string) != null && n == ((zzevq)(object = this.zzobq.zzcjg().get(string))).getResourceId() && this.zzobq.zzcjh() == ((zzevq)object).zzcjd()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzobr.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzevq zzevq2 = new zzevq(n, this.zzobq.zzcjh());
            this.zzobq.zza(string, zzevq2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzevv.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzevv.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzevv.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzevv.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzevv.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzevv.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzobr.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzobp == null || !this.zzobp.zzro(string)) {
                    return;
                }
                this.zzobp.zzi(null, string);
                this.zzobp.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzobp == null) {
                    this.zzobp = new zzevt(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzobp.zzi(hashMap, string);
                this.zzobp.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzobq.zzrp(string);
            }
            this.zzcjc();
            return;
        }
        finally {
            this.zzobr.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzobr.writeLock().lock();
        try {
            boolean bl = this.zzobq.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzobq.zzcs(bl2);
            if (bl != bl2) {
                this.zzcjc();
            }
            return;
        }
        finally {
            this.zzobr.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzobr.readLock().lock();
        try {
            if (this.zzobo != null && this.zzobo.zzbn(string, string2)) {
                byte[] byArray = this.zzobo.zzbo(string, string2);
                return byArray;
            }
            if (this.zzobp != null && this.zzobp.zzbn(string, string2)) {
                byte[] byArray = this.zzobp.zzbo(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzobr.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzobr.readLock().lock();
            try {
                if (this.zzobo == null || !this.zzobo.zzbn(string, string2)) break block5;
                String string3 = new String(this.zzobo.zzbo(string, string2), zzevv.UTF_8);
                this.zzobr.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzobr.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzobp != null && this.zzobp.zzbn(string, string2)) {
            String string4 = new String(this.zzobp.zzbo(string, string2), zzevv.UTF_8);
            this.zzobr.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzobr.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzobr.readLock().lock();
        try {
            String string3;
            if (this.zzobo != null && this.zzobo.zzbn(string, string2)) {
                string3 = new String(this.zzobo.zzbo(string, string2), zzevv.UTF_8);
                if (zzevv.zzgcv.matcher(string3).matches()) {
                    return true;
                }
                if (zzevv.zzgcw.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzobp != null && this.zzobp.zzbn(string, string2)) {
                string3 = new String(this.zzobp.zzbo(string, string2), zzevv.UTF_8);
                if (zzevv.zzgcv.matcher(string3).matches()) {
                    return true;
                }
                if (zzevv.zzgcw.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzobr.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzevv(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzobr.readLock().lock();
        try {
            if (this.zzobo != null && this.zzobo.zzbn(string, string2)) {
                zzevv zzevv2 = new zzevv(this.zzobo.zzbo(string, string2), 2);
                return zzevv2;
            }
            if (this.zzobp != null && this.zzobp.zzbn(string, string2)) {
                zzevv zzevv3 = new zzevv(this.zzobp.zzbo(string, string2), 1);
                return zzevv3;
            }
            zzevv zzevv4 = new zzevv(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzevv4;
        }
        finally {
            this.zzobr.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzevu zzevu2 = new zzevu();
        this.zzobr.readLock().lock();
        try {
            long l = this.zzobn == null ? -1L : this.zzobn.getTimestamp();
            zzevu2.zzcl(l);
            zzevu2.zzhy(this.zzobq.getLastFetchStatus());
            zzevu2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzobq.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzobr.readLock().unlock();
        }
        return zzevu2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzobr.readLock().lock();
        try {
            if (this.zzobo == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzobo.zzbp(string, string2);
            return set;
        }
        finally {
            this.zzobr.readLock().unlock();
        }
    }

    private static void zzr(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzcjc() {
        this.zzobr.readLock().lock();
        try {
            FirebaseRemoteConfig.zzr(new zzevs(this.mContext, this.zzobn, this.zzobo, this.zzobp, this.zzobq));
            return;
        }
        finally {
            this.zzobr.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzobr.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbgi zzbgi2 = new zzbgi();
            zzbgi2.zzz(l);
            if (this.zzobq.isDeveloperModeEnabled()) {
                zzbgi2.zzx("_rcn_developer", "true");
            }
            zzbgi2.zzck(10300);
            if (this.zzobo != null && this.zzobo.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzobo.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbgi2.zzcm(n);
            }
            if (this.zzobn != null && this.zzobn.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzobn.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbgi2.zzcl(n);
            }
            zzbgh zzbgh2 = zzbgi2.zzamo();
            zzbgu zzbgu2 = new zzbgu(this.mContext);
            zzbgd.zzgco.zza(zzbgu2.zzagb(), zzbgh2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzobr.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbgj zzbgj2) {
        if (zzbgj2 == null || zzbgj2.getStatus() == null) {
            this.zzobq.zzhy(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzcjc();
            return;
        }
        int n = zzbgj2.getStatus().getStatusCode();
        this.zzobr.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzobq.zzhy(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcjc();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzobq.zzhy(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbgj2.getThrottleEndTimeMillis())));
                    this.zzcjc();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzobq.zzhy(-1);
                    if (this.zzobn != null && !this.zzobn.zzcjf()) {
                        Map<String, Set<String>> map = zzbgj2.zzamq();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbgj2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzobn = new zzevt(hashMap, this.zzobn.getTimestamp(), zzbgj2.zzamp());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzcjc();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbgj2.zzamq();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbgj2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzobn = new zzevt(hashMap, System.currentTimeMillis(), zzbgj2.zzamp());
                    this.zzobq.zzhy(-1);
                    taskCompletionSource.setResult(null);
                    this.zzcjc();
                    return;
                }
                default: {
                    if (zzbgj2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzobq.zzhy(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcjc();
                    return;
                }
            }
        }
        finally {
            this.zzobr.writeLock().unlock();
        }
    }
}

