/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbii;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzbin;
import com.google.android.gms.internal.zzbio;
import com.google.android.gms.internal.zzbiz;
import com.google.android.gms.internal.zzdyx;
import com.google.android.gms.internal.zzfam;
import com.google.android.gms.internal.zzfan;
import com.google.android.gms.internal.zzfao;
import com.google.android.gms.internal.zzfap;
import com.google.android.gms.internal.zzfaq;
import com.google.android.gms.internal.zzfar;
import com.google.android.gms.internal.zzfas;
import com.google.android.gms.internal.zzfat;
import com.google.android.gms.internal.zzfau;
import com.google.android.gms.internal.zzfav;
import com.google.android.gms.internal.zzfaw;
import com.google.android.gms.internal.zzfax;
import com.google.android.gms.internal.zzfay;
import com.google.android.gms.internal.zzflj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zza;
    private zzfap zzb;
    private zzfap zzc;
    private zzfap zzd;
    private zzfas zze;
    private final Context zzf;
    private final ReadWriteLock zzg = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzfap zzfap2, zzfap zzfap3, zzfap zzfap4, zzfas zzfas2) {
        this.zzf = context;
        this.zze = zzfas2 != null ? zzfas2 : new zzfas();
        this.zze.zza(this.zza(this.zzf));
        if (zzfap2 != null) {
            this.zzb = zzfap2;
        }
        if (zzfap3 != null) {
            this.zzc = zzfap3;
        }
        if (zzfap4 != null) {
            this.zzd = zzfap4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zza == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zza == null) {
                zzfax zzfax2 = FirebaseRemoteConfig.zzb(context);
                if (zzfax2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zza = new FirebaseRemoteConfig(context);
                } else {
                    zzfas zzfas2;
                    zzfas zzfas3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzfap zzfap2 = FirebaseRemoteConfig.zza(zzfax2.zza);
                    zzfap zzfap3 = FirebaseRemoteConfig.zza(zzfax2.zzb);
                    zzfap zzfap4 = FirebaseRemoteConfig.zza(zzfax2.zzc);
                    zzfav zzfav2 = zzfax2.zzd;
                    if (zzfav2 == null) {
                        zzfas3 = null;
                    } else {
                        zzfas zzfas4 = new zzfas();
                        zzfas4.zza(zzfav2.zza);
                        zzfas4.zza(zzfav2.zzb);
                        zzfas4.zzb(zzfav2.zzc);
                        zzfas3 = zzfas2 = zzfas4;
                    }
                    if (zzfas3 != null) {
                        zzfas2.zza(FirebaseRemoteConfig.zza(zzfax2.zze));
                    }
                    zza = new FirebaseRemoteConfig(context, zzfap2, zzfap3, zzfap4, zzfas2);
                }
            }
            return zza;
        }
        return zza;
    }

    private final long zza(Context context) {
        long l = 0L;
        try {
            l = this.zzf.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzfax zzb(Context context) {
        zzfax zzfax2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzflj zzflj2 = zzflj.zza((byte[])byArray, (int)0, (int)((Object)object).length);
            zzfax2 = new zzfax();
            zzfax2.zza(zzflj2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzfax2;
    }

    private static Map<String, zzfam> zza(zzfay[] zzfayArray) {
        HashMap<String, zzfam> hashMap = new HashMap<String, zzfam>();
        if (zzfayArray == null) {
            return hashMap;
        }
        zzfay[] zzfayArray2 = zzfayArray;
        int n = zzfayArray.length;
        for (int i = 0; i < n; ++i) {
            zzfay zzfay2 = zzfayArray2[i];
            String string = zzfay2.zzc;
            int n2 = zzfay2.zza;
            long l = zzfay2.zzb;
            hashMap.put(string, new zzfam(n2, l));
        }
        return hashMap;
    }

    private static zzfap zza(zzfat zzfat2) {
        Object object;
        if (zzfat2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzfat2.zza;
        int n = zzfat2.zza.length;
        for (int i = 0; i < n; ++i) {
            zzfaw zzfaw2 = object2[i];
            String string = zzfaw2.zza;
            object = new HashMap();
            zzfau[] zzfauArray = zzfaw2.zzb;
            int n2 = zzfaw2.zzb.length;
            for (int j = 0; j < n2; ++j) {
                zzfau zzfau2 = zzfauArray[j];
                object.put(zzfau2.zza, zzfau2.zzb);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzfat2.zzc;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzfaw[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzfap(hashMap, zzfat2.zzb, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzg.writeLock().lock();
        try {
            if (this.zzb == null) {
                return false;
            }
            if (this.zzc != null && this.zzc.zzd() >= this.zzb.zzd()) {
                return false;
            }
            long l = this.zzb.zzd();
            this.zzc = this.zzb;
            this.zzc.zza(System.currentTimeMillis());
            this.zzb = new zzfap(null, l, null);
            long l2 = this.zze.zze();
            this.zze.zzb(zzdyx.zza(l2, this.zzc.zzb()));
            long l3 = l2;
            List<byte[]> list = this.zzc.zzb();
            Context context = this.zzf;
            FirebaseRemoteConfig.zza(new zzfan(context, list, l3));
            this.zza();
            return true;
        }
        finally {
            this.zzg.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzg.readLock().lock();
        try {
            if (this.zze != null && this.zze.zzc() != null && this.zze.zzc().get(string) != null && n == ((zzfam)(object = this.zze.zzc().get(string))).zza() && this.zze.zzd() == ((zzfam)object).zzb()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzg.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.zzf.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzfam zzfam2 = new zzfam(n, this.zze.zzd());
            this.zze.zza(string, zzfam2);
            this.zza((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zza(map, string, true);
    }

    private final void zza(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzfar.zza));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzfar.zza));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzfar.zza));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzfar.zza));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzfar.zza));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzfar.zza));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzg.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzd == null || !this.zzd.zza(string)) {
                    return;
                }
                this.zzd.zza((Map<String, byte[]>)null, string);
                this.zzd.zza(System.currentTimeMillis());
            } else {
                if (this.zzd == null) {
                    this.zzd = new zzfap(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzd.zza(hashMap, string);
                this.zzd.zza(System.currentTimeMillis());
            }
            if (bl) {
                this.zze.zza(string);
            }
            this.zza();
            return;
        }
        finally {
            this.zzg.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzg.writeLock().lock();
        try {
            boolean bl = this.zze.zzb();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zze.zza(bl2);
            if (bl != bl2) {
                this.zza();
            }
            return;
        }
        finally {
            this.zzg.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzg.readLock().lock();
        try {
            if (this.zzc != null && this.zzc.zza(string, string2)) {
                byte[] byArray = this.zzc.zzb(string, string2);
                return byArray;
            }
            if (this.zzd != null && this.zzd.zza(string, string2)) {
                byte[] byArray = this.zzd.zzb(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzg.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzg.readLock().lock();
            try {
                if (this.zzc == null || !this.zzc.zza(string, string2)) break block5;
                String string3 = new String(this.zzc.zzb(string, string2), zzfar.zza);
                this.zzg.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzg.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzd != null && this.zzd.zza(string, string2)) {
            String string4 = new String(this.zzd.zzb(string, string2), zzfar.zza);
            this.zzg.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzg.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzg.readLock().lock();
        try {
            String string3;
            if (this.zzc != null && this.zzc.zza(string, string2)) {
                string3 = new String(this.zzc.zzb(string, string2), zzfar.zza);
                if (zzfar.zzb.matcher(string3).matches()) {
                    return true;
                }
                if (zzfar.zzc.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzd != null && this.zzd.zza(string, string2)) {
                string3 = new String(this.zzd.zzb(string, string2), zzfar.zza);
                if (zzfar.zzb.matcher(string3).matches()) {
                    return true;
                }
                if (zzfar.zzc.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzg.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzfar(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzg.readLock().lock();
        try {
            if (this.zzc != null && this.zzc.zza(string, string2)) {
                zzfar zzfar2 = new zzfar(this.zzc.zzb(string, string2), 2);
                return zzfar2;
            }
            if (this.zzd != null && this.zzd.zza(string, string2)) {
                zzfar zzfar3 = new zzfar(this.zzd.zzb(string, string2), 1);
                return zzfar3;
            }
            zzfar zzfar4 = new zzfar(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzfar4;
        }
        finally {
            this.zzg.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzfaq zzfaq2 = new zzfaq();
        this.zzg.readLock().lock();
        try {
            long l = this.zzb == null ? -1L : this.zzb.zzd();
            zzfaq2.zza(l);
            zzfaq2.zza(this.zze.zza());
            zzfaq2.zza(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zze.zzb()).build());
        }
        finally {
            this.zzg.readLock().unlock();
        }
        return zzfaq2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzg.readLock().lock();
        try {
            if (this.zzc == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzc.zzc(string, string2);
            return set;
        }
        finally {
            this.zzg.readLock().unlock();
        }
    }

    private static void zza(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zza() {
        this.zzg.readLock().lock();
        try {
            FirebaseRemoteConfig.zza(new zzfao(this.zzf, this.zzb, this.zzc, this.zzd, this.zze));
            return;
        }
        finally {
            this.zzg.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzg.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbin zzbin2 = new zzbin();
            zzbin2.zza(l);
            if (this.zze.zzb()) {
                zzbin2.zza("_rcn_developer", "true");
            }
            zzbin2.zza(10300);
            if (this.zzc != null && this.zzc.zzd() != -1L) {
                l3 = System.currentTimeMillis() - this.zzc.zzd();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbin2.zzc(n);
            }
            if (this.zzb != null && this.zzb.zzd() != -1L) {
                l3 = System.currentTimeMillis() - this.zzb.zzd();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbin2.zzb(n);
            }
            zzbim zzbim2 = zzbin2.zza();
            zzbiz zzbiz2 = new zzbiz(this.zzf);
            zzbii.zzb.zza(zzbiz2.zze(), zzbim2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzg.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbio zzbio2) {
        if (zzbio2 == null || zzbio2.getStatus() == null) {
            this.zze.zza(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zza();
            return;
        }
        int n = zzbio2.getStatus().getStatusCode();
        this.zzg.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zze.zza(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zza();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zze.zza(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbio2.zza())));
                    this.zza();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zze.zza(-1);
                    if (this.zzb != null && !this.zzb.zzc()) {
                        Map<String, Set<String>> map = zzbio2.zzc();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbio2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzb = new zzfap(hashMap, this.zzb.zzd(), zzbio2.zzb());
                    }
                    taskCompletionSource.setResult(null);
                    this.zza();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbio2.zzc();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbio2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzb = new zzfap(hashMap, System.currentTimeMillis(), zzbio2.zzb());
                    this.zze.zza(-1);
                    taskCompletionSource.setResult(null);
                    this.zza();
                    return;
                }
                default: {
                    if (zzbio2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zze.zza(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zza();
                    return;
                }
            }
        }
        finally {
            this.zzg.writeLock().unlock();
        }
    }
}

