/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal.rollouts;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigClientException;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import com.google.firebase.remoteconfig.internal.ConfigGetParameterHandler;
import com.google.firebase.remoteconfig.interop.rollouts.RolloutAssignment;
import com.google.firebase.remoteconfig.interop.rollouts.RolloutsState;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RolloutsStateFactory {
    ConfigGetParameterHandler getParameterHandler;

    RolloutsStateFactory(ConfigGetParameterHandler getParameterHandler) {
        this.getParameterHandler = getParameterHandler;
    }

    @NonNull
    RolloutsState getActiveRolloutsState(@NonNull ConfigContainer configContainer) throws FirebaseRemoteConfigClientException {
        JSONArray rolloutMetadata = configContainer.getRolloutMetadata();
        long templateVersion = configContainer.getTemplateVersionNumber();
        HashSet<RolloutAssignment> rolloutAssignments = new HashSet<RolloutAssignment>();
        for (int i = 0; i < rolloutMetadata.length(); ++i) {
            try {
                JSONObject rollout = rolloutMetadata.getJSONObject(i);
                String rolloutId = rollout.getString("rolloutId");
                JSONArray affectedParameterKeys = rollout.getJSONArray("affectedParameterKeys");
                if (affectedParameterKeys.length() > 1) {
                    Log.w((String)"FirebaseRemoteConfig", (String)String.format("Rollout has multiple affected parameter keys.Only the first key will be included in RolloutsState. rolloutId: %s, affectedParameterKeys: %s", rolloutId, affectedParameterKeys));
                }
                String parameterKey = affectedParameterKeys.optString(0, "");
                String parameterValue = this.getParameterHandler.getString(parameterKey);
                rolloutAssignments.add(RolloutAssignment.builder().setRolloutId(rolloutId).setVariantId(rollout.getString("variantId")).setParameterKey(parameterKey).setParameterValue(parameterValue).setTemplateVersion(templateVersion).build());
                continue;
            }
            catch (JSONException e) {
                throw new FirebaseRemoteConfigClientException("Exception parsing rollouts metadata to create RolloutsState.", e);
            }
        }
        return RolloutsState.create(rolloutAssignments);
    }

    @NonNull
    public static RolloutsStateFactory create(@NonNull ConfigGetParameterHandler configGetParameterHandler) {
        return new RolloutsStateFactory(configGetParameterHandler);
    }
}

