/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.config.internal.zzd;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzanf;
import com.google.android.gms.internal.zzang;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzani;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzarc;
import com.google.android.gms.internal.zzsk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig bhU;
    private zzang bhV;
    private zzang bhW;
    private zzang bhX;
    private zzanj bhY;
    private final Context mContext;
    private final ReadWriteLock bhZ = new ReentrantReadWriteLock(true);

    FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzang zzang2, zzang zzang3, zzang zzang4, zzanj zzanj2) {
        this.mContext = context;
        this.bhY = zzanj2 != null ? zzanj2 : new zzanj();
        this.bhY.zzcs(this.zzez(this.mContext));
        if (zzang2 != null) {
            this.bhV = zzang2;
        }
        if (zzang3 != null) {
            this.bhW = zzang3;
        }
        if (zzang4 != null) {
            this.bhX = zzang4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (bhU == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            return FirebaseRemoteConfig.zzey(context);
        }
        return bhU;
    }

    public static FirebaseRemoteConfig zzey(Context context) {
        if (bhU == null) {
            zzank.zze zze2 = FirebaseRemoteConfig.zzfa(context);
            if (zze2 == null) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                }
                bhU = new FirebaseRemoteConfig(context);
            } else {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                }
                zzang zzang2 = FirebaseRemoteConfig.zza(zze2.biw);
                zzang zzang3 = FirebaseRemoteConfig.zza(zze2.bix);
                zzang zzang4 = FirebaseRemoteConfig.zza(zze2.biy);
                zzanj zzanj2 = FirebaseRemoteConfig.zza(zze2.biz);
                if (zzanj2 != null) {
                    zzanj2.zzcf(FirebaseRemoteConfig.zza(zze2.biA));
                }
                bhU = new FirebaseRemoteConfig(context, zzang2, zzang3, zzang4, zzanj2);
            }
        }
        return bhU;
    }

    private long zzez(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzank.zze zzfa(Context context) {
        if (context == null) {
            return null;
        }
        zzank.zze zze2 = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            zzarc zzarc2 = zzarc.zzbd((byte[])FirebaseRemoteConfig.zzm(fileInputStream));
            zze2 = new zzank.zze();
            zzank.zze cfr_ignored_0 = (zzank.zze)zze2.zzb(zzarc2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            Object var4_7 = null;
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            Object var4_8 = null;
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zze2;
    }

    private static Map<String, zzane> zza(zzank.zzf[] zzfArray) {
        HashMap<String, zzane> hashMap = new HashMap<String, zzane>();
        if (zzfArray == null) {
            return hashMap;
        }
        for (zzank.zzf zzf2 : zzfArray) {
            String string = zzf2.Dl;
            int n = zzf2.resourceId;
            long l = zzf2.biC;
            hashMap.put(string, new zzane(n, l));
        }
        return hashMap;
    }

    private static zzanj zza(zzank.zzc zzc2) {
        if (zzc2 == null) {
            return null;
        }
        zzanj zzanj2 = new zzanj();
        zzanj2.zzago(zzc2.bis);
        zzanj2.zzdb(zzc2.bit);
        return zzanj2;
    }

    private static zzang zza(zzank.zza zza2) {
        zzank.zzd[] zzdArray;
        if (zza2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        for (zzank.zzd zzd2 : zzdArray = zza2.bip) {
            String string = zzd2.Dl;
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            for (zzank.zzb zzb2 : zzd2.biv) {
                hashMap2.put(zzb2.zzcb, zzb2.bir);
            }
            hashMap.put(string, hashMap2);
        }
        return new zzang(hashMap, zza2.timestamp);
    }

    private static byte[] zzm(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FirebaseRemoteConfig.zzb(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zzb(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFetched() {
        this.bhZ.writeLock().lock();
        try {
            if (this.bhV == null) {
                boolean bl = false;
                return false;
            }
            if (this.bhW != null && this.bhW.getTimestamp() >= this.bhV.getTimestamp()) {
                boolean bl = false;
                return false;
            }
            long l = this.bhV.getTimestamp();
            this.bhW = this.bhV;
            this.bhW.setTimestamp(System.currentTimeMillis());
            this.bhV = new zzang(null, l);
            this.P();
            boolean bl = true;
            return true;
        }
        finally {
            this.bhZ.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.bhZ.readLock().lock();
        try {
            if (this.bhY != null && this.bhY.W() != null && this.bhY.W().get(string) != null && n == ((zzane)(object = this.bhY.W().get(string))).R() && this.bhY.X() == ((zzane)object).S()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.bhZ.readLock().unlock();
        }
        object = new HashMap();
        try {
            Resources resources = this.mContext.getResources();
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzane zzane2 = new zzane(n, this.bhY.X());
            this.bhY.zza(string, zzane2);
            this.zzc((Map<String, Object>)object, string, false);
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzani.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzani.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzani.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzani.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzani.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzani.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.bhZ.writeLock().lock();
        try {
            if (bl2) {
                if (this.bhX == null || !this.bhX.zzuc(string)) {
                    return;
                }
                this.bhX.zzk(null, string);
                this.bhX.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.bhX == null) {
                    this.bhX = new zzang(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis());
                }
                this.bhX.zzk(hashMap, string);
                this.bhX.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.bhY.zzud(string);
            }
            this.P();
        }
        finally {
            this.bhZ.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.bhZ.writeLock().lock();
        try {
            boolean bl = this.bhY.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.bhY.zzdb(bl2);
            if (bl != bl2) {
                this.P();
            }
        }
        finally {
            this.bhZ.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.bhZ.readLock().lock();
        try {
            if (this.bhW != null && this.bhW.zzbv(string, string2)) {
                byte[] byArray = this.bhW.zzbw(string, string2);
                return byArray;
            }
            if (this.bhX != null && this.bhX.zzbv(string, string2)) {
                byte[] byArray = this.bhX.zzbw(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.bhZ.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.bhZ.readLock().lock();
        try {
            if (this.bhW != null && this.bhW.zzbv(string, string2)) {
                String string3 = new String(this.bhW.zzbw(string, string2), zzani.UTF_8);
                return string3;
            }
            if (this.bhX != null && this.bhX.zzbv(string, string2)) {
                String string4 = new String(this.bhX.zzbw(string, string2), zzani.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.bhZ.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.bhZ.readLock().lock();
        try {
            String string3;
            if (this.bhW != null && this.bhW.zzbv(string, string2)) {
                string3 = new String(this.bhW.zzbw(string, string2), zzani.UTF_8);
                if (zzani.Fp.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzani.Fq.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            if (this.bhX != null && this.bhX.zzbv(string, string2)) {
                string3 = new String(this.bhX.zzbw(string, string2), zzani.UTF_8);
                if (zzani.Fp.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzani.Fq.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            boolean bl = false;
            return false;
        }
        finally {
            this.bhZ.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzani(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.bhZ.readLock().lock();
        try {
            if (this.bhW != null && this.bhW.zzbv(string, string2)) {
                zzani zzani2 = new zzani(this.bhW.zzbw(string, string2), 2);
                return zzani2;
            }
            if (this.bhX != null && this.bhX.zzbv(string, string2)) {
                zzani zzani3 = new zzani(this.bhX.zzbw(string, string2), 1);
                return zzani3;
            }
            zzani zzani4 = new zzani(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzani4;
        }
        finally {
            this.bhZ.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        zzanh zzanh2 = new zzanh();
        this.bhZ.readLock().lock();
        try {
            long l = this.bhV == null ? -1L : this.bhV.getTimestamp();
            zzanh2.zzcr(l);
            zzanh2.zzago(this.bhY.getLastFetchStatus());
            zzanh2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.bhY.isDeveloperModeEnabled()).build());
        }
        finally {
            this.bhZ.readLock().unlock();
        }
        return zzanh2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeysByPrefix(String string, String string2) {
        this.bhZ.readLock().lock();
        try {
            if (this.bhW == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.bhW.zzbx(string, string2);
            return set;
        }
        finally {
            this.bhZ.readLock().unlock();
        }
    }

    private void P() {
        this.bhZ.readLock().lock();
        try {
            zzanf zzanf2 = new zzanf(this.mContext, this.bhV, this.bhW, this.bhX, this.bhY);
            if (Build.VERSION.SDK_INT >= 11) {
                AsyncTask.SERIAL_EXECUTOR.execute(zzanf2);
            } else {
                new zza().execute(zzanf2);
            }
        }
        finally {
            this.bhZ.readLock().unlock();
        }
    }

    int Q() {
        return 10200;
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> fetch(long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.bhZ.readLock().lock();
        try {
            zzsk.zza.zza zza2 = new zzsk.zza.zza();
            zza2.zzaj(l);
            if (this.bhY.isDeveloperModeEnabled()) {
                zza2.zzah("_rcn_developer", "true");
            }
            zza2.zzhm(this.Q());
            PendingResult<zzsk.zzb> pendingResult = new zzd(this.mContext).zza(zza2.zzayi());
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<zzsk.zzb>(){

                public void zza(@NonNull zzsk.zzb zzb2) {
                    FirebaseRemoteConfig.this.zza((TaskCompletionSource<Void>)taskCompletionSource, zzb2);
                }

                public /* synthetic */ void onResult(@NonNull Result result) {
                    this.zza((zzsk.zzb)result);
                }
            });
        }
        finally {
            this.bhZ.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void zza(TaskCompletionSource<Void> taskCompletionSource, zzsk.zzb zzb2) {
        if (zzb2 == null || zzb2.getStatus() == null) {
            this.bhY.zzago(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.P();
            return;
        }
        int n = zzb2.getStatus().getStatusCode();
        this.bhZ.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.bhY.zzago(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.P();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.bhY.zzago(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzb2.getThrottleEndTimeMillis())));
                    this.P();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.bhY.zzago(-1);
                    if (this.bhV != null && !this.bhV.U()) {
                        Map<String, Set<String>> map = zzb2.zzayj();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzb2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.bhV = new zzang(hashMap, this.bhV.getTimestamp());
                    }
                    taskCompletionSource.setResult(null);
                    this.P();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzb2.zzayj();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzb2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.bhV = new zzang(hashMap, System.currentTimeMillis());
                    this.bhY.zzago(-1);
                    taskCompletionSource.setResult(null);
                    this.P();
                    return;
                }
                default: {
                    if (zzb2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.bhY.zzago(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.P();
                    return;
                }
            }
        }
        finally {
            this.bhZ.writeLock().unlock();
        }
    }

    static class zza
    implements Executor {
        zza() {
        }

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    }
}

