/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzbnl;
import com.google.android.gms.internal.zzbnm;
import com.google.android.gms.internal.zzbnn;
import com.google.android.gms.internal.zzbnp;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzbnr;
import com.google.android.gms.internal.zzbns;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzc;

public class FirebaseCrash {
    private static final String LOG_TAG = FirebaseCrash.class.getSimpleName();
    private boolean zzbrt;
    private zzbnp zzbZe;
    private zzbnl zzbZf;
    private static volatile FirebaseCrash zzbZg;

    FirebaseCrash(FirebaseApp firebaseApp, boolean bl) {
        this.zzbrt = bl;
        Context context = firebaseApp.getApplicationContext();
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Application context is missing, disabling api");
            this.zzbrt = false;
        }
        if (this.zzbrt) {
            try {
                String string = firebaseApp.getOptions().getApiKey();
                String string2 = firebaseApp.getOptions().getApplicationId();
                zzbnn zzbnn2 = new zzbnn(string2, string);
                zzbnq.zzWD().zzaG(context);
                this.zzbZe = zzbnq.zzWD().zzWE();
                this.zzbZe.zza(zzd.zzA((Object)context), zzbnn2);
                this.zzbZf = new zzbnl(context);
                this.zzWz();
                String string3 = String.valueOf(zzbnq.zzWD().toString());
                Log.i((String)LOG_TAG, (String)(string3.length() != 0 ? "FirebaseCrash reporting initialized ".concat(string3) : new String("FirebaseCrash reporting initialized ")));
            }
            catch (Exception exception) {
                String string = String.valueOf(exception.getMessage());
                Log.e((String)LOG_TAG, (String)(string.length() != 0 ? "Failed to initialize crash reporting: ".concat(string) : new String("Failed to initialize crash reporting: ")));
                this.zzbrt = false;
            }
        } else {
            Log.i((String)LOG_TAG, (String)"Crash reporting is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebaseCrash zzWv() {
        if (zzbZg != null) return zzbZg;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbZg != null) return zzbZg;
            zzbZg = FirebaseCrash.getInstance(FirebaseApp.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzbZg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Keep
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        zzbns.initialize(firebaseApp.getApplicationContext());
        boolean bl = (Boolean)zzbns.zzbZp.get();
        FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, bl);
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbZg == null) {
                zzbZg = firebaseCrash;
                try {
                    zzbZg.zzWw();
                }
                catch (zzbnm zzbnm2) {
                    Log.d((String)LOG_TAG, (String)"Cannot register Firebase Analytics listener since Firebase Crash Reporting is not enabled");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return firebaseCrash;
        }
    }

    private void zzWw() throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        this.zzbZf.zzWB();
    }

    private zzbnp zzWx() {
        return this.zzbZe;
    }

    private boolean isEnabled() {
        return this.zzbrt;
    }

    public static void log(String string) {
        try {
            FirebaseCrash.zzWv().zziB(string);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public static void logcat(int n, String string, String string2) {
        try {
            FirebaseCrash.zzWv().zze(n, string, string2);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public static void zza(String string, long l, Bundle bundle) {
        try {
            FirebaseCrash.zzWv().zzb(string, l, bundle);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public static void report(Throwable throwable) {
        try {
            FirebaseCrash.zzWv().zzh(throwable);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public void zze(int n, String string, String string2) throws zzbnm {
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            Log.println((int)n, (String)string, (String)string2);
            this.zziB(string2);
        }
    }

    public void zziB(String string) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWx();
        if (zzbnp2 != null && string != null) {
            try {
                zzbnp2.log(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzb(String string, long l, Bundle bundle) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWx();
        if (zzbnp2 != null && string != null) {
            try {
                zzbnp2.zzb(string, l, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzh(Throwable throwable) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWx();
        if (zzbnp2 != null && throwable != null) {
            this.zzbZf.zza(false, System.currentTimeMillis());
            try {
                zzbnp2.zziC(this.zzWA());
                zzbnp2.zzN(zzd.zzA((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzi(Throwable throwable) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWx();
        if (zzbnp2 != null && throwable != null) {
            try {
                this.zzbZf.zza(true, System.currentTimeMillis());
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                zzbnp2.zziC(this.zzWA());
                zzbnp2.zzO(zzd.zzA((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    private static boolean zzWy() {
        long l;
        long l2 = Looper.getMainLooper().getThread().getId();
        return l2 == (l = Thread.currentThread().getId());
    }

    private void zzWz() {
        if (!FirebaseCrash.zzWy()) {
            throw new RuntimeException("FirebaseCrash reporting may only be initialized on the main thread (preferably in your app's Application.onCreate)");
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        zzbnr zzbnr2 = new zzbnr(uncaughtExceptionHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(zzbnr2);
    }

    private String zzWA() {
        return zzc.zzabL().getId();
    }
}

