/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.rb;
import com.google.android.gms.internal.rc;
import com.google.android.gms.internal.rd;
import com.google.android.gms.internal.re;
import com.google.android.gms.internal.rh;
import com.google.android.gms.internal.rn;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import com.google.firebase.iid.FirebaseInstanceId;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection
public class FirebaseCrash {
    private static volatile FirebaseCrash zzcaQ;
    private final Context mContext;
    private final ExecutorService zzcaR;
    private final FirebaseApp zzbXX;
    private final zzb zzcaS;
    private final CountDownLatch zzcaT = new CountDownLatch(1);
    private rn zzcaU;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzbXX = firebaseApp;
        this.zzcaR = executorService;
        this.mContext = this.zzbXX.getApplicationContext();
        this.zzcaS = new zzb(null);
    }

    final void zza(@Nullable rh rh2) {
        if (rh2 == null) {
            this.zzcaR.shutdownNow();
        } else {
            this.zzcaU = rn.zzbE(this.mContext);
            this.zzcaS.zzb(rh2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzcaU != null && !firebaseCrash.zzFv()) {
                firebaseCrash.zzcaU.zza(firebaseCrash.mContext, firebaseCrash.zzcaR, firebaseCrash.zzcaS);
            }
        }
        this.zzcaT.countDown();
    }

    private final void zzFt() {
        try {
            this.zzcaT.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzFu() {
        if (zzcaQ != null) {
            return zzcaQ;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzcaQ != null) return zzcaQ;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzcaQ != null) return zzcaQ;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, FirebaseInstanceId.getInstance().getId());
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<rh> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzcaR.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzcaQ = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzcaQ;
        }
    }

    public final boolean zzFv() {
        return this.zzcaR.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzFu().zzgX(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFu();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzgX(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFu();
        if (throwable2 == null || firebaseCrash.zzFv()) {
            return;
        }
        firebaseCrash.zzcaR.submit(new rb(firebaseCrash.mContext, firebaseCrash.zzcaS, throwable2, firebaseCrash.zzcaU));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFu();
        if (!firebaseCrash.zzFv()) {
            firebaseCrash.zzcaR.submit(new re(firebaseCrash.mContext, firebaseCrash.zzcaS, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzFu().zzFw();
    }

    private final boolean zzFw() {
        if (this.zzFv()) {
            return false;
        }
        this.zzFt();
        rh rh2 = this.zzcaS.zzFx();
        if (rh2 != null) {
            try {
                return rh2.zzFw();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzgX(String string) {
        if (string == null || this.zzFv()) {
            return;
        }
        this.zzcaR.submit(new rc(this.mContext, this.zzcaS, string));
    }

    @Nullable
    final Future<?> zzg(Throwable throwable) {
        if (throwable == null || this.zzFv()) {
            return null;
        }
        return this.zzcaR.submit(new rd(this.mContext, this.zzcaS, throwable, this.zzcaU));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzFt();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzcaY;
        private /* synthetic */ FirebaseCrash zzcaV;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzcaV = firebaseCrash;
            this.zzcaY = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzcaV.zzFv()) {
                try {
                    Future<?> future = this.zzcaV.zzg(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzcaY != null) {
                this.zzcaY.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzcaW = new Object();
        private rh zzcaX;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final rh zzFx() {
            Object object = this.zzcaW;
            synchronized (object) {
                return this.zzcaX;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable rh rh2) {
            Object object = this.zzcaW;
            synchronized (object) {
                this.zzcaX = rh2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public rh zzFx();
    }
}

