/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.md;
import com.google.android.gms.internal.me;
import com.google.android.gms.internal.mf;
import com.google.android.gms.internal.mg;
import com.google.android.gms.internal.mj;
import com.google.android.gms.internal.mp;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzbXS;
    private final Context mContext;
    private final ExecutorService zzbXT;
    private final FirebaseApp zzbVZ;
    private final zzb zzbXU;
    private final CountDownLatch zzbXV = new CountDownLatch(1);
    private mp zzbXW;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzbVZ = firebaseApp;
        this.zzbXT = executorService;
        this.mContext = this.zzbVZ.getApplicationContext();
        this.zzbXU = new zzb(null);
    }

    final void zza(@Nullable mj mj2) {
        if (mj2 == null) {
            this.zzbXT.shutdownNow();
        } else {
            this.zzbXW = mp.zzbE(this.mContext);
            this.zzbXU.zzb(mj2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzbXW != null && !firebaseCrash.zzFe()) {
                firebaseCrash.zzbXW.zza(firebaseCrash.mContext, firebaseCrash.zzbXT, firebaseCrash.zzbXU);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzbXV.countDown();
    }

    private final void zzFc() {
        try {
            this.zzbXV.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzFd() {
        if (zzbXS != null) {
            return zzbXS;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzbXS != null) return zzbXS;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzbXS != null) return zzbXS;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<mj> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzbXT.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzbXS = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbXS;
        }
    }

    public final boolean zzFe() {
        return this.zzbXT.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzFd().zzgy(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFd();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzgy(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFd();
        if (throwable2 == null || firebaseCrash.zzFe()) {
            return;
        }
        firebaseCrash.zzbXT.submit(new md(firebaseCrash.mContext, firebaseCrash.zzbXU, throwable2, firebaseCrash.zzbXW));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFd();
        if (!firebaseCrash.zzFe()) {
            firebaseCrash.zzbXT.submit(new mg(firebaseCrash.mContext, firebaseCrash.zzbXU, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzFd().zzFf();
    }

    private final boolean zzFf() {
        if (this.zzFe()) {
            return false;
        }
        this.zzFc();
        mj mj2 = this.zzbXU.zzFg();
        if (mj2 != null) {
            try {
                return mj2.zzFf();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzgy(String string) {
        if (string == null || this.zzFe()) {
            return;
        }
        this.zzbXT.submit(new me(this.mContext, this.zzbXU, string));
    }

    @Nullable
    final Future<?> zze(Throwable throwable) {
        if (throwable == null || this.zzFe()) {
            return null;
        }
        return this.zzbXT.submit(new mf(this.mContext, this.zzbXU, throwable, this.zzbXW));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzFc();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzbYa;
        private /* synthetic */ FirebaseCrash zzbXX;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzbXX = firebaseCrash;
            this.zzbYa = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzbXX.zzFe()) {
                try {
                    Future<?> future = this.zzbXX.zze(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzbYa != null) {
                this.zzbYa.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzbXY = new Object();
        private mj zzbXZ;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final mj zzFg() {
            Object object = this.zzbXY;
            synchronized (object) {
                return this.zzbXZ;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable mj mj2) {
            Object object = this.zzbXY;
            synchronized (object) {
                this.zzbXZ = mj2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public mj zzFg();
    }
}

