/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.zzdmo;
import com.google.android.gms.internal.zzdmp;
import com.google.android.gms.internal.zzdmq;
import com.google.android.gms.internal.zzdmr;
import com.google.android.gms.internal.zzdmu;
import com.google.android.gms.internal.zzdna;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzlmg;
    private final Context mContext;
    private final ExecutorService zzlmh;
    private final FirebaseApp zzlii;
    private final zzb zzlmi;
    private final CountDownLatch zzlmj = new CountDownLatch(1);
    private zzdna zzlmk;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzlii = firebaseApp;
        this.zzlmh = executorService;
        this.mContext = this.zzlii.getApplicationContext();
        this.zzlmi = new zzb(null);
    }

    final void zza(@Nullable zzdmu zzdmu2) {
        if (zzdmu2 == null) {
            this.zzlmh.shutdownNow();
        } else {
            this.zzlmk = zzdna.zzei(this.mContext);
            this.zzlmi.zzb(zzdmu2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzlmk != null && !firebaseCrash.zzbpb()) {
                firebaseCrash.zzlmk.zza(firebaseCrash.mContext, firebaseCrash.zzlmh, firebaseCrash.zzlmi);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzlmj.countDown();
    }

    private final void zzboz() {
        try {
            this.zzlmj.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzbpa() {
        if (zzlmg != null) {
            return zzlmg;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzlmg != null) return zzlmg;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzlmg != null) return zzlmg;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzdmu> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzlmh.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzlmg = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzlmg;
        }
    }

    public final boolean zzbpb() {
        return this.zzlmh.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzbpa().zzot(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbpa();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzot(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbpa();
        if (throwable2 == null || firebaseCrash.zzbpb()) {
            return;
        }
        firebaseCrash.zzlmh.submit(new zzdmo(firebaseCrash.mContext, firebaseCrash.zzlmi, throwable2, firebaseCrash.zzlmk));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbpa();
        if (!firebaseCrash.zzbpb()) {
            firebaseCrash.zzlmh.submit(new zzdmr(firebaseCrash.mContext, firebaseCrash.zzlmi, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzbpa().zzbpc();
    }

    private final boolean zzbpc() {
        if (this.zzbpb()) {
            return false;
        }
        this.zzboz();
        zzdmu zzdmu2 = this.zzlmi.zzbpd();
        if (zzdmu2 != null) {
            try {
                return zzdmu2.zzbpc();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzot(String string) {
        if (string == null || this.zzbpb()) {
            return;
        }
        this.zzlmh.submit(new zzdmp(this.mContext, this.zzlmi, string));
    }

    @Nullable
    final Future<?> zzd(Throwable throwable) {
        if (throwable == null || this.zzbpb()) {
            return null;
        }
        return this.zzlmh.submit(new zzdmq(this.mContext, this.zzlmi, throwable, this.zzlmk));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzboz();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzlmo;
        private /* synthetic */ FirebaseCrash zzlml;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzlml = firebaseCrash;
            this.zzlmo = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzlml.zzbpb()) {
                try {
                    Future<?> future = this.zzlml.zzd(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzlmo != null) {
                this.zzlmo.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzlmm = new Object();
        private zzdmu zzlmn;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzdmu zzbpd() {
            Object object = this.zzlmm;
            synchronized (object) {
                return this.zzlmn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzdmu zzdmu2) {
            Object object = this.zzlmm;
            synchronized (object) {
                this.zzlmn = zzdmu2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public zzdmu zzbpd();
    }
}

