/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.zzdxn;
import com.google.android.gms.internal.zzdxo;
import com.google.android.gms.internal.zzdxp;
import com.google.android.gms.internal.zzdxq;
import com.google.android.gms.internal.zzdxt;
import com.google.android.gms.internal.zzdxz;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzmdi;
    private final Context mContext;
    private final ExecutorService zzmdj;
    private final FirebaseApp zzlyo;
    private final zzb zzmdk;
    private final CountDownLatch zzmdl = new CountDownLatch(1);
    private zzdxz zzmdm;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzlyo = firebaseApp;
        this.zzmdj = executorService;
        this.mContext = this.zzlyo.getApplicationContext();
        this.zzmdk = new zzb(null);
    }

    final void zza(@Nullable zzdxt zzdxt2) {
        if (zzdxt2 == null) {
            this.zzmdj.shutdownNow();
        } else {
            this.zzmdm = zzdxz.zzer(this.mContext);
            this.zzmdk.zzb(zzdxt2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzmdm != null && !firebaseCrash.zzbqo()) {
                firebaseCrash.zzmdm.zza(firebaseCrash.mContext, firebaseCrash.zzmdj, firebaseCrash.zzmdk);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzmdl.countDown();
    }

    private final void zzbqm() {
        try {
            this.zzmdl.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzbqn() {
        if (zzmdi != null) {
            return zzmdi;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzmdi != null) return zzmdi;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzmdi != null) return zzmdi;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzdxt> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzmdj.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzmdi = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzmdi;
        }
    }

    public final boolean zzbqo() {
        return this.zzmdj.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzbqn().zzoo(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbqn();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzoo(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbqn();
        if (throwable2 == null || firebaseCrash.zzbqo()) {
            return;
        }
        firebaseCrash.zzmdj.submit(new zzdxn(firebaseCrash.mContext, firebaseCrash.zzmdk, throwable2, firebaseCrash.zzmdm));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbqn();
        if (!firebaseCrash.zzbqo()) {
            firebaseCrash.zzmdj.submit(new zzdxq(firebaseCrash.mContext, firebaseCrash.zzmdk, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzbqn().zzbqp();
    }

    private final boolean zzbqp() {
        if (this.zzbqo()) {
            return false;
        }
        this.zzbqm();
        zzdxt zzdxt2 = this.zzmdk.zzbqq();
        if (zzdxt2 != null) {
            try {
                return zzdxt2.zzbqp();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzoo(String string) {
        if (string == null || this.zzbqo()) {
            return;
        }
        this.zzmdj.submit(new zzdxo(this.mContext, this.zzmdk, string));
    }

    @Nullable
    final Future<?> zzh(Throwable throwable) {
        if (throwable == null || this.zzbqo()) {
            return null;
        }
        return this.zzmdj.submit(new zzdxp(this.mContext, this.zzmdk, throwable, this.zzmdm));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzbqm();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzmdq;
        private /* synthetic */ FirebaseCrash zzmdn;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzmdn = firebaseCrash;
            this.zzmdq = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzmdn.zzbqo()) {
                try {
                    Future<?> future = this.zzmdn.zzh(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzmdq != null) {
                this.zzmdq.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzmdo = new Object();
        private zzdxt zzmdp;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzdxt zzbqq() {
            Object object = this.zzmdo;
            synchronized (object) {
                return this.zzmdp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzdxt zzdxt2) {
            Object object = this.zzmdo;
            synchronized (object) {
                this.zzmdp = zzdxt2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public zzdxt zzbqq();
    }
}

