/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.zzdzc;
import com.google.android.gms.internal.zzdzd;
import com.google.android.gms.internal.zzdze;
import com.google.android.gms.internal.zzdzf;
import com.google.android.gms.internal.zzdzi;
import com.google.android.gms.internal.zzdzo;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzmif;
    private final Context mContext;
    private final ExecutorService zzmig;
    private final FirebaseApp zzmcx;
    private final zzb zzmih;
    private final CountDownLatch zzmii = new CountDownLatch(1);
    private zzdzo zzmij;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzmcx = firebaseApp;
        this.zzmig = executorService;
        this.mContext = this.zzmcx.getApplicationContext();
        this.zzmih = new zzb(null);
    }

    final void zza(@Nullable zzdzi zzdzi2) {
        if (zzdzi2 == null) {
            this.zzmig.shutdownNow();
        } else {
            this.zzmij = zzdzo.zzeu(this.mContext);
            this.zzmih.zzb(zzdzi2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzmij != null && !firebaseCrash.zzbsm()) {
                firebaseCrash.zzmij.zza(firebaseCrash.mContext, firebaseCrash.zzmig, firebaseCrash.zzmih);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzmii.countDown();
    }

    private final void zzbsk() {
        try {
            this.zzmii.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzbsl() {
        if (zzmif != null) {
            return zzmif;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzmif != null) return zzmif;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzmif != null) return zzmif;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzdzi> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzmig.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzmif = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzmif;
        }
    }

    public final boolean zzbsm() {
        return this.zzmig.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzbsl().zzpe(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbsl();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzpe(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbsl();
        if (throwable2 == null || firebaseCrash.zzbsm()) {
            return;
        }
        firebaseCrash.zzmig.submit(new zzdzc(firebaseCrash.mContext, firebaseCrash.zzmih, throwable2, firebaseCrash.zzmij));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbsl();
        if (!firebaseCrash.zzbsm()) {
            firebaseCrash.zzmig.submit(new zzdzf(firebaseCrash.mContext, firebaseCrash.zzmih, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzbsl().zzbsn();
    }

    private final boolean zzbsn() {
        if (this.zzbsm()) {
            return false;
        }
        this.zzbsk();
        zzdzi zzdzi2 = this.zzmih.zzbso();
        if (zzdzi2 != null) {
            try {
                return zzdzi2.zzbsn();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzpe(String string) {
        if (string == null || this.zzbsm()) {
            return;
        }
        this.zzmig.submit(new zzdzd(this.mContext, this.zzmih, string));
    }

    @Nullable
    final Future<?> zzh(Throwable throwable) {
        if (throwable == null || this.zzbsm()) {
            return null;
        }
        return this.zzmig.submit(new zzdze(this.mContext, this.zzmih, throwable, this.zzmij));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzbsk();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzmin;
        private /* synthetic */ FirebaseCrash zzmik;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzmik = firebaseCrash;
            this.zzmin = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzmik.zzbsm()) {
                try {
                    Future<?> future = this.zzmik.zzh(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzmin != null) {
                this.zzmin.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzmil = new Object();
        private zzdzi zzmim;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzdzi zzbso() {
            Object object = this.zzmil;
            synchronized (object) {
                return this.zzmim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzdzi zzdzi2) {
            Object object = this.zzmil;
            synchronized (object) {
                this.zzmim = zzdzi2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public zzdzi zzbso();
    }
}

