/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzecm;
import com.google.android.gms.internal.zzecn;
import com.google.android.gms.internal.zzeco;
import com.google.android.gms.internal.zzecp;
import com.google.android.gms.internal.zzecq;
import com.google.android.gms.internal.zzect;
import com.google.android.gms.internal.zzecy;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zza;
    private final Context zzb;
    private final ExecutorService zzc;
    private final FirebaseApp zzd;
    private final zzb zze;
    private final CountDownLatch zzf = new CountDownLatch(1);
    private zzecy zzg;

    @Hide
    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzd = firebaseApp;
        this.zzc = executorService;
        this.zzb = this.zzd.getApplicationContext();
        this.zze = new zzb(null);
    }

    final void zza(@Nullable zzect zzect2) {
        if (zzect2 == null) {
            this.zzc.shutdownNow();
        } else {
            this.zzg = zzecy.zza(this.zzb);
            this.zze.zza(zzect2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzg != null && !firebaseCrash.zzb()) {
                firebaseCrash.zzg.zza(firebaseCrash.zzb, firebaseCrash.zzc, firebaseCrash.zze);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzf.countDown();
    }

    private final void zzc() {
        try {
            this.zzf.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    @Hide
    public static FirebaseCrash zza() {
        if (zza != null) {
            return zza;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Hide
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zza != null) return zza;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zza != null) return zza;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzect> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzc.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zza = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    @Hide
    public final boolean zzb() {
        return this.zzc.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zza().zza(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zza();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zza(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zza();
        if (throwable2 == null || firebaseCrash.zzb()) {
            return;
        }
        firebaseCrash.zzc.submit(new zzecm(firebaseCrash.zzb, firebaseCrash.zze, throwable2, firebaseCrash.zzg));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zza();
        if (!firebaseCrash.zzb()) {
            firebaseCrash.zzc.submit(new zzecq(firebaseCrash.zzb, firebaseCrash.zze, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zza().zzd();
    }

    private final boolean zzd() {
        if (this.zzb()) {
            return false;
        }
        this.zzc();
        zzect zzect2 = this.zze.zza();
        if (zzect2 != null) {
            try {
                return zzect2.zza();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zza(String string) {
        if (string == null || this.zzb()) {
            return;
        }
        this.zzc.submit(new zzecn(this.zzb, this.zze, string));
    }

    @Nullable
    final Future<?> zza(Throwable throwable) {
        if (throwable == null || this.zzb()) {
            return null;
        }
        return this.zzc.submit(new zzeco(this.zzb, this.zze, throwable, this.zzg));
    }

    @Hide
    final void zza(boolean bl) {
        if (this.zzb()) {
            return;
        }
        this.zzc.submit(new zzecp(this.zzb, this.zze, bl));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzc();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zza;
        private /* synthetic */ FirebaseCrash zzb;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzb = firebaseCrash;
            this.zza = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzb.zzb()) {
                try {
                    Future<?> future = this.zzb.zza(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zza != null) {
                this.zza.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zza = new Object();
        private zzect zzb;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzect zza() {
            Object object = this.zza;
            synchronized (object) {
                return this.zzb;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zza(@Nullable zzect zzect2) {
            Object object = this.zza;
            synchronized (object) {
                this.zzb = zzect2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    @Hide
    public static interface zza {
        @Nullable
        public zzect zza();
    }
}

