/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.api;

import com.google.firebase.crashlytics.buildtools.AppBuildInfo;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.Obfuscator;
import com.google.firebase.crashlytics.buildtools.api.CodeMappingService;
import com.google.firebase.crashlytics.buildtools.api.WebApi;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FirebaseCodeMappingService
implements CodeMappingService {
    private static final String MAPPING_UPLOAD_REQUEST_FORMAT = "%s/v1/project/-/app/%s/upload/java/%s";
    private static final String SYMBOL_UPLOAD_REQUEST_FORMAT = "%s/v1/project/-/app/%s/upload/native/%s";
    private static final String GZIPPED_FILE_SUFFIX = ".gz";
    private final WebApi webApi;

    public FirebaseCodeMappingService(WebApi webApi) {
        this.webApi = webApi;
    }

    @Override
    public void uploadObfuscatorMappingFile(File mappingFile, String mappingFileId, AppBuildInfo appBuildInfo, Obfuscator obfuscator) throws IOException {
        File gZippedMappingFile = new File(FirebaseCodeMappingService.getMappingBuildDir(appBuildInfo.getBuildDir()), mappingFileId + GZIPPED_FILE_SUFFIX);
        Buildtools.logD("Zipping mapping file: " + mappingFile + " -> " + gZippedMappingFile);
        FirebaseCodeMappingService.gZipFile(mappingFile, gZippedMappingFile);
        URL url = new URL(String.format(MAPPING_UPLOAD_REQUEST_FORMAT, this.webApi.getCodeMappingApiUrl(), appBuildInfo.getGoogleAppId(), mappingFileId));
        this.webApi.uploadFile(url, gZippedMappingFile);
        gZippedMappingFile.delete();
    }

    private static File getMappingBuildDir(File buildDir) throws IOException {
        File workingDir = new File(buildDir, "mappings");
        FileUtils.verifyDirectory(workingDir);
        return workingDir;
    }

    @Override
    public void uploadNativeSymbolFile(File symbolFile, AppBuildInfo appBuildInfo) throws IOException {
        File parent = symbolFile.getParentFile();
        File gZippedSymbolFile = parent == null ? new File(FilenameUtils.removeExtension((String)symbolFile.getName()) + GZIPPED_FILE_SUFFIX) : new File(parent, FilenameUtils.removeExtension((String)symbolFile.getName()) + GZIPPED_FILE_SUFFIX);
        FirebaseCodeMappingService.gZipFile(symbolFile, gZippedSymbolFile);
        URL url = new URL(String.format(SYMBOL_UPLOAD_REQUEST_FORMAT, this.webApi.getCodeMappingApiUrl(), appBuildInfo.getGoogleAppId(), FirebaseCodeMappingService.getUuid(symbolFile)));
        this.webApi.uploadFile(url, gZippedSymbolFile);
        gZippedSymbolFile.delete();
    }

    private static void gZipFile(File inputFile, File gZipOutputFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
             GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(gZipOutputFile));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private static String getUuid(File cSymFile) throws IOException {
        String cSymHeader = FirebaseCodeMappingService.readCSymHeader(cSymFile);
        String[] headerTokens = cSymHeader.split("\t");
        if (headerTokens.length != 8 || !headerTokens[0].equals("code_mapping")) {
            throw new IOException("Invalid cSYM header for " + cSymFile.getAbsolutePath());
        }
        return headerTokens[3];
    }

    private static String readCSymHeader(File cSymFile) throws IOException {
        String cSymHeader;
        try (BufferedReader reader = new BufferedReader(new FileReader(cSymFile));){
            cSymHeader = reader.readLine();
        }
        if (cSymHeader == null || cSymHeader.length() == 0) {
            throw new IOException("Could not read cSYM header for " + cSymFile.getPath());
        }
        return cSymHeader;
    }
}

