/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWTag;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugAbbrevEntry;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineEntry;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugLineStateMachine;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DwarfException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRange;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRanges;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.CompilationUnitContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.CompileUnitAttributeProcessor;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.DefaultAttributesReader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.DefaultNamedRangesResolver;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.FileContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.MissingSectionNamedRangesResolver;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.NamedRangesAttributeProcessor;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.NamedRangesResolver;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.ReferenceBytesConverter;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.SkipAttributesReader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.DebugElfSectionHeaders;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfDataParser;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSectionHeader;
import com.google.firebase.crashlytics.buildtools.utils.io.ByteReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DwarfDataParser {
    private static final NamedRangesResolver MISSING_SECTION_RESOLVER = new MissingSectionNamedRangesResolver();
    private static final Set<DWTag> RELEVANT_TAGS = Sets.newHashSet((Object[])new DWTag[]{DWTag.SUBPROGRAM, DWTag.INLINED_SUBROUTINE});
    private final ByteReader byteReader;
    private final ByteOrder byteOrder;
    private final DebugElfSectionHeaders debugHeaders;
    private final boolean isDebugFeatureFlagEnabled;

    public DwarfDataParser(ByteReader byteReader, ByteOrder byteOrder, DebugElfSectionHeaders debugHeaders, boolean isDebugFeatureFlagEnabled) {
        this.byteReader = byteReader;
        this.byteOrder = byteOrder;
        this.debugHeaders = debugHeaders;
        this.isDebugFeatureFlagEnabled = isDebugFeatureFlagEnabled;
    }

    public void parse(ElfDataParser.ContentHandler handler) throws IOException {
        this.byteReader.seek(this.debugHeaders.debugInfo.shOffset);
        long sectionEnd = this.debugHeaders.debugInfo.shOffset + this.debugHeaders.debugInfo.shSize;
        int index = 0;
        ReferenceBytesConverter referenceBytesConverter = new ReferenceBytesConverter(this.byteOrder);
        TreeMap specificationMap = Maps.newTreeMap();
        TreeMap abstractOriginMap = Maps.newTreeMap();
        FileContext fileContext = new FileContext(this.debugHeaders, referenceBytesConverter, specificationMap, abstractOriginMap);
        while (this.byteReader.getCurrentOffset() != sectionEnd) {
            Optional<Long> debugLineOffset;
            CompilationUnitContext cuContext = DwarfDataParser.readCompilationUnit(this.byteReader, fileContext, this.isDebugFeatureFlagEnabled);
            int cuAddressSize = cuContext.header.addressSize;
            NamedRanges namedRanges = new NamedRanges(cuContext.namedRanges);
            long nextOffset = this.byteReader.getCurrentOffset();
            List<DebugLineEntry> lineEntries = this.isDebugFeatureFlagEnabled ? ((debugLineOffset = cuContext.getDebugLineOffset()).isPresent() ? DwarfDataParser.readDebugLineData(this.byteReader, this.debugHeaders.debugLine.shOffset + (Long)debugLineOffset.get(), cuAddressSize) : Collections.emptyList()) : DwarfDataParser.readDebugLineDataAtIndex(this.byteReader, index, this.debugHeaders.debugLine, cuAddressSize);
            handler.processDebugInfoCompilationUnit(namedRanges, lineEntries);
            this.byteReader.seek(nextOffset);
            ++index;
        }
    }

    private static List<DebugLineEntry> readDebugLineData(ByteReader fileReader, long debugLineOffset, int pointerSize) throws IOException {
        DebugLineStateMachine stateMachine = new DebugLineStateMachine();
        try {
            fileReader.seek(debugLineOffset);
            return stateMachine.runFromCurrentOffset(fileReader, pointerSize);
        }
        catch (DwarfException de) {
            Buildtools.logE("Could not parse debug data.", de);
            return Collections.emptyList();
        }
    }

    private static List<DebugLineEntry> readDebugLineDataAtIndex(ByteReader fileReader, int index, ElfSectionHeader debugLineSectionHeader, int pointerSize) throws IOException {
        DebugLineStateMachine stateMachine = new DebugLineStateMachine();
        long debugLineEndOffset = debugLineSectionHeader.shOffset + debugLineSectionHeader.shSize;
        try {
            fileReader.seek(debugLineSectionHeader.shOffset);
            return stateMachine.runForIndex(fileReader, index, debugLineEndOffset, pointerSize);
        }
        catch (DwarfException de) {
            Buildtools.logE("Could not parse debug data.", de);
            return Collections.emptyList();
        }
    }

    private static CompilationUnitContext readCompilationUnit(ByteReader reader, FileContext fileContext, boolean isDebugFeatureFlagEnabled) throws IOException {
        long debugInfoOffset = fileContext.debugSectionHeaders.debugInfo.shOffset;
        long offset = reader.getCurrentOffset() - debugInfoOffset;
        int referenceSize = 4;
        long length = reader.readLong(4);
        if (length == -1L) {
            referenceSize = 8;
            length = reader.readLong(8);
        }
        return DwarfDataParser.readCompilationUnit(reader, offset, length, referenceSize, fileContext, isDebugFeatureFlagEnabled);
    }

    private static CompilationUnitContext readCompilationUnit(ByteReader reader, long offset, long length, int referenceSize, FileContext fileContext, boolean isDebugFeatureFlagEnabled) throws IOException {
        CompilationUnitContext cuContext;
        long endOffset = reader.getCurrentOffset() + length;
        int version = reader.readInt(2);
        long abbrevOffset = reader.readLong(referenceSize);
        int addressSize = reader.readInt(1);
        long entriesOffset = reader.getCurrentOffset();
        CompilationUnitContext.Header cuHeader = new CompilationUnitContext.Header(offset, length, version, abbrevOffset, addressSize, referenceSize);
        if (isDebugFeatureFlagEnabled) {
            long debugAbbrevSectionOffset = fileContext.debugSectionHeaders.debugAbbrev.shOffset;
            HashMap<Integer, DebugAbbrevEntry> debugAbbrevEntries = DwarfDataParser.readDebugAbbrevEntries(reader, debugAbbrevSectionOffset + abbrevOffset);
            reader.seek(entriesOffset);
            cuContext = DwarfDataParser.processCompilationUnit(reader, fileContext, cuHeader, debugAbbrevEntries);
        } else {
            cuContext = new CompilationUnitContext(fileContext, cuHeader);
            reader.seek(endOffset);
        }
        return cuContext;
    }

    private static CompilationUnitContext processCompilationUnit(ByteReader reader, FileContext fileContext, CompilationUnitContext.Header cuHeader, Map<Integer, DebugAbbrevEntry> abbrevEntries) throws IOException {
        int abbrevCode = reader.readULEB128();
        DebugAbbrevEntry abbrevEntry = abbrevEntries.get(abbrevCode);
        CompilationUnitContext cuContext = DwarfDataParser.processCompilationUnitEntry(reader, fileContext, cuHeader, abbrevEntry.attributes);
        if (abbrevEntry.hasChildren) {
            cuContext.namedRanges.addAll(DwarfDataParser.processChildDebugInfoEntries(reader, cuContext, abbrevEntries));
        }
        return cuContext;
    }

    private static CompilationUnitContext processCompilationUnitEntry(ByteReader reader, FileContext fileContext, CompilationUnitContext.Header cuHeader, List<DebugAbbrevEntry.Attribute> attributes) throws IOException {
        CompileUnitAttributeProcessor attributeProcessor = new CompileUnitAttributeProcessor(fileContext.referenceBytesConverter);
        DefaultAttributesReader<CompilationUnitContext.EntryData> attributesReader = new DefaultAttributesReader<CompilationUnitContext.EntryData>(reader, cuHeader, fileContext.referenceBytesConverter, attributeProcessor, fileContext.debugSectionHeaders.debugStr.shOffset);
        CompilationUnitContext.EntryData entryData = attributesReader.readAttributes(attributes);
        return new CompilationUnitContext(fileContext, cuHeader, entryData);
    }

    private static HashMap<Integer, DebugAbbrevEntry> readDebugAbbrevEntries(ByteReader reader, long offset) throws IOException {
        int number;
        reader.seek(offset);
        HashMap entries = Maps.newHashMap();
        while ((number = reader.readULEB128()) != 0) {
            int tag = reader.readULEB128();
            boolean hasChildren = reader.readByte() != 0;
            entries.put(number, new DebugAbbrevEntry(number, tag, hasChildren, DwarfDataParser.readDebugAbbrevEntryAttributes(reader)));
        }
        return entries;
    }

    private static List<DebugAbbrevEntry.Attribute> readDebugAbbrevEntryAttributes(ByteReader reader) throws IOException {
        LinkedList attributes = Lists.newLinkedList();
        while (true) {
            int name = reader.readULEB128();
            int form = reader.readULEB128();
            if (name == 0 && form == 0) break;
            attributes.add(new DebugAbbrevEntry.Attribute(name, form));
        }
        return attributes;
    }

    private static List<NamedRange> processChildDebugInfoEntries(ByteReader reader, CompilationUnitContext cuContext, Map<Integer, DebugAbbrevEntry> abbrevEntries) throws IOException {
        LinkedList allNamedRanges = Lists.newLinkedList();
        long debugInfoOffset = cuContext.fileContext.debugSectionHeaders.debugInfo.shOffset;
        long entryOffset = reader.getCurrentOffset() - debugInfoOffset;
        int abbrevCode = reader.readULEB128();
        while (abbrevCode > 0) {
            DebugAbbrevEntry abbrevEntry = abbrevEntries.get(abbrevCode);
            List<NamedRange> namedRanges = DwarfDataParser.processDebugInfoEntry(reader, cuContext, entryOffset, abbrevEntry.tag, abbrevEntry.attributes);
            if (abbrevEntry.hasChildren) {
                namedRanges = DwarfDataParser.interleaveRanges(namedRanges, DwarfDataParser.processChildDebugInfoEntries(reader, cuContext, abbrevEntries));
            }
            allNamedRanges.addAll(namedRanges);
            entryOffset = reader.getCurrentOffset() - debugInfoOffset;
            abbrevCode = reader.readULEB128();
        }
        return allNamedRanges;
    }

    private static List<NamedRange> processDebugInfoEntry(ByteReader reader, CompilationUnitContext cuContext, long entryOffset, DWTag entryTag, List<DebugAbbrevEntry.Attribute> attributes) throws IOException {
        if (!RELEVANT_TAGS.contains((Object)entryTag)) {
            new SkipAttributesReader(reader, cuContext.header).readAttributes((List)attributes);
            return Collections.emptyList();
        }
        ElfSectionHeader debugRanges = cuContext.fileContext.debugSectionHeaders.debugRanges;
        NamedRangesResolver namedRangesResolver = debugRanges != null ? new DefaultNamedRangesResolver(reader, cuContext.header.addressSize, debugRanges.shOffset) : MISSING_SECTION_RESOLVER;
        NamedRangesAttributeProcessor attributeProcessor = new NamedRangesAttributeProcessor(entryOffset, cuContext, namedRangesResolver);
        return new DefaultAttributesReader<List<NamedRange>>(reader, cuContext.header, cuContext.fileContext.referenceBytesConverter, attributeProcessor, cuContext.fileContext.debugSectionHeaders.debugStr.shOffset).readAttributes(attributes);
    }

    private static List<NamedRange> interleaveRanges(List<NamedRange> context, List<NamedRange> incoming) {
        if (context.isEmpty()) {
            return incoming;
        }
        LinkedList result = Lists.newLinkedList();
        for (NamedRange contextRange : context) {
            Collection children = Collections2.filter(incoming, DwarfDataParser.isChildOf(contextRange));
            result.addAll(DwarfDataParser.interleave(contextRange, children));
        }
        return result;
    }

    private static List<NamedRange> interleave(NamedRange parent, Collection<NamedRange> incoming) {
        if (incoming.isEmpty()) {
            return Lists.newArrayList((Object[])new NamedRange[]{parent});
        }
        ArrayList result = Lists.newArrayList();
        long start = parent.start;
        long end = parent.end;
        ImmutableList incomingSortedByAddress = Ordering.natural().immutableSortedCopy(incoming);
        for (NamedRange incomingRange : incomingSortedByAddress) {
            end = incomingRange.end;
            if (incomingRange.start > start) {
                result.add(new NamedRange(parent.nameProvider, start, incomingRange.start));
            }
            result.add(incomingRange);
            start = incomingRange.end;
        }
        if (end < parent.end) {
            result.add(new NamedRange(parent.nameProvider, end, parent.end));
        }
        return result;
    }

    private static Predicate<NamedRange> isChildOf(final NamedRange parent) {
        return new Predicate<NamedRange>(){

            public boolean apply(NamedRange incoming) {
                return incoming != null && parent.contains(incoming);
            }
        };
    }
}

