/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf;

import com.google.common.base.Objects;
import com.google.firebase.crashlytics.buildtools.ndk.internal.SymbolNameProvider;

public class NamedRange
implements Comparable<NamedRange> {
    public final SymbolNameProvider nameProvider;
    public final Long start;
    public final Long end;

    public NamedRange(SymbolNameProvider nameProvider, Long start, Long end) {
        this.nameProvider = nameProvider;
        this.start = start;
        this.end = end;
    }

    public boolean contains(NamedRange r) {
        return r.start >= this.start && r.end <= this.end;
    }

    public boolean contains(long address) {
        return address >= this.start && address <= this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedRange that = (NamedRange)o;
        return Objects.equal((Object)this.start, (Object)that.start) && Objects.equal((Object)this.end, (Object)that.end);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end});
    }

    @Override
    public int compareTo(NamedRange o) {
        return this.start.compareTo(o.start);
    }
}

