/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import com.google.common.base.Optional;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.internal.SimpleSymbolNameProvider;
import com.google.firebase.crashlytics.buildtools.ndk.internal.SymbolNameProvider;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWAttribute;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWForm;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRange;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.AttributeProcessor;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.CompilationUnitContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.NamedRangesResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NamedRangesAttributeProcessor
implements AttributeProcessor<List<NamedRange>> {
    private final long offset;
    private final CompilationUnitContext cuContext;
    private final NamedRangesResolver namedRangesResolver;
    private String name;
    private String linkageName;
    private boolean isDeclaration;
    private boolean isInline;
    private long specification = -1L;
    private long abstractOrigin = -1L;
    private long highPc = -1L;
    private boolean isHighPcAddress;
    private long lowPc = -1L;
    private long rangesOffset = -1L;

    public NamedRangesAttributeProcessor(long offset, CompilationUnitContext cuContext, NamedRangesResolver namedRangesResolver) {
        this.offset = offset;
        this.cuContext = cuContext;
        this.namedRangesResolver = namedRangesResolver;
    }

    @Override
    public void processAttribute(DWAttribute attribute, DWForm form, byte[] value) {
        switch (attribute) {
            case HIGH_PC: {
                this.highPc = this.cuContext.fileContext.referenceBytesConverter.asLongValue(value);
                this.isHighPcAddress = false;
                break;
            }
            case INLINE: {
                this.isInline = true;
                break;
            }
        }
    }

    @Override
    public void processAttribute(DWAttribute attribute, long value) {
        switch (attribute) {
            case DECLARATION: {
                this.isDeclaration = value == 1L;
                break;
            }
            case SPECIFICATION: {
                this.specification = value;
                break;
            }
            case ABSTRACT_ORIGIN: {
                this.abstractOrigin = value;
                break;
            }
            case LOW_PC: {
                this.lowPc = value;
                break;
            }
            case HIGH_PC: {
                this.highPc = value;
                this.isHighPcAddress = true;
                break;
            }
            case RANGES: {
                this.rangesOffset = value;
                break;
            }
        }
    }

    @Override
    public void processAttribute(DWAttribute attribute, String value) {
        switch (attribute) {
            case NAME: {
                this.name = value;
                break;
            }
            case LINKAGE_NAME: {
                this.linkageName = value;
                break;
            }
        }
    }

    @Override
    public List<NamedRange> finishProcessingAttributes() {
        SymbolNameProvider nameProvider;
        String resolvedName = (String)Optional.fromNullable((Object)this.linkageName).or(Optional.fromNullable((Object)this.name)).orNull();
        if (resolvedName != null) {
            nameProvider = SimpleSymbolNameProvider.of(resolvedName);
            if (this.isDeclaration) {
                this.cuContext.fileContext.specificationMap.put(this.offset, resolvedName);
            }
            if (this.isInline) {
                this.cuContext.fileContext.abstractOriginMap.put(this.offset, nameProvider);
            }
        } else {
            SpecificationNameProvider specificationNameProvider = new SpecificationNameProvider(this.cuContext.fileContext.specificationMap, this.specification);
            AbstractOriginNameProvider abstractOriginNameProvider = new AbstractOriginNameProvider(this.cuContext.fileContext.abstractOriginMap, this.abstractOrigin);
            nameProvider = new ChainedNameProvider(specificationNameProvider, abstractOriginNameProvider);
            if (this.isInline) {
                this.cuContext.fileContext.abstractOriginMap.put(this.offset, specificationNameProvider);
            }
        }
        if (this.lowPc >= 0L && this.highPc >= 0L) {
            if (!this.isHighPcAddress) {
                this.highPc += this.lowPc;
            }
            return Collections.singletonList(new NamedRange(nameProvider, this.lowPc, this.highPc));
        }
        if (this.rangesOffset >= 0L) {
            return this.namedRangesResolver.resolveNamedRanges(this.rangesOffset, nameProvider, this.cuContext.getLowPc());
        }
        return Collections.emptyList();
    }

    private static class ChainedNameProvider
    implements SymbolNameProvider {
        private final SpecificationNameProvider specificationNameProvider;
        private final AbstractOriginNameProvider abstractOriginNameProvider;
        private String symbolName;

        public ChainedNameProvider(SpecificationNameProvider specificationNameProvider, AbstractOriginNameProvider abstractOriginNameProvider) {
            this.specificationNameProvider = specificationNameProvider;
            this.abstractOriginNameProvider = abstractOriginNameProvider;
        }

        @Override
        public Optional<String> getSymbolName() {
            if (this.symbolName != null) {
                return Optional.of((Object)this.symbolName);
            }
            Optional<String> resolvedSymbolName = this.resolveSymbolName();
            if (resolvedSymbolName.isPresent()) {
                this.symbolName = (String)resolvedSymbolName.get();
            }
            return Optional.fromNullable((Object)this.symbolName);
        }

        private Optional<String> resolveSymbolName() {
            Optional<String> specificationName = this.specificationNameProvider.getSymbolName();
            return specificationName.isPresent() ? specificationName : this.abstractOriginNameProvider.getSymbolName();
        }
    }

    private static class AbstractOriginNameProvider
    implements SymbolNameProvider {
        private final Map<Long, SymbolNameProvider> abstractOriginMap;
        private final long abstractOrigin;
        private String abstractOriginName;
        private static long unresolvedSymbolCount = 0L;
        private static final long MAX_UNRESOLVED_LOG_MESSAGES = 10L;

        public AbstractOriginNameProvider(Map<Long, SymbolNameProvider> abstractOriginMap, long abstractOrigin) {
            this.abstractOriginMap = abstractOriginMap;
            this.abstractOrigin = abstractOrigin;
        }

        @Override
        public Optional<String> getSymbolName() {
            if (this.abstractOriginName != null) {
                return Optional.of((Object)this.abstractOriginName);
            }
            Optional<String> resolvedSymbolName = this.resolveSymbolName();
            if (resolvedSymbolName.isPresent()) {
                this.abstractOriginName = (String)resolvedSymbolName.get();
            }
            return Optional.fromNullable((Object)this.abstractOriginName);
        }

        private Optional<String> resolveSymbolName() {
            if (this.abstractOrigin >= 0L && this.abstractOriginMap.containsKey(this.abstractOrigin)) {
                return this.abstractOriginMap.get(this.abstractOrigin).getSymbolName();
            }
            if (++unresolvedSymbolCount < 10L) {
                String msg = "Symbol name not found for address " + this.abstractOrigin + " while generating CSym";
                if (unresolvedSymbolCount == 9L) {
                    msg = msg + " [log count exceeded; suppressing future messages for this issue]";
                }
                Buildtools.logD(msg);
            }
            return Optional.of((Object)"--UNRESOLVED--");
        }
    }

    private static class SpecificationNameProvider
    implements SymbolNameProvider {
        private final Map<Long, String> specificationMap;
        private final long specification;
        private String specificationName;

        public SpecificationNameProvider(Map<Long, String> specificationMap, long specification) {
            this.specificationMap = specificationMap;
            this.specification = specification;
        }

        @Override
        public Optional<String> getSymbolName() {
            if (this.specificationName != null) {
                return Optional.of((Object)this.specificationName);
            }
            Optional<String> resolvedSymbolName = this.resolveSymbolName();
            if (resolvedSymbolName.isPresent()) {
                this.specificationName = (String)resolvedSymbolName.get();
            }
            return Optional.fromNullable((Object)this.specificationName);
        }

        private Optional<String> resolveSymbolName() {
            return this.specification >= 0L ? Optional.fromNullable((Object)this.specificationMap.get(this.specification)) : Optional.absent();
        }
    }
}

