/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public final class CrashlyticsOptions {
    public static final String OPT_INJECT_MAPPING_FILE_ID = "injectMappingFileIdIntoResource";
    public static final String OPT_UPLOAD_MAPPING_FILE = "uploadMappingFile";
    public static final String OPT_MAPPING_FILE_ID = "mappingFileId";
    public static final String OPT_OBFUSCATOR_NAME = "obfuscatorName";
    public static final String OPT_OBFUSCATOR_VERSION = "obfuscationVersion";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_QUIET = "quiet";
    public static final String OPT_GENERATE_NATIVE_SYMBOLS = "generateNativeSymbols";
    public static final String OPT_UPLOAD_NATIVE_SYMBOLS = "uploadNativeSymbols";
    public static final String OPT_NATIVE_UNSTRIPPED_LIB = "unstrippedLibrary";
    public static final String OPT_NATIVE_STRIPPED_LIB = "strippedLibrary";
    public static final String OPT_NATIVE_UNSTRIPPED_LIBS_DIR = "unstrippedLibrariesDir";
    public static final String OPT_NATIVE_STRIPPED_LIBS_DIR = "strippedLibrariesDir";
    public static final String OPT_CSYM_CACHE_DIR = "symbolFileCacheDir";
    public static final String OPT_GOOGLE_APP_ID = "googleAppId";
    public static final String OPT_ANDROID_APPLICATION_ID = "androidApplicationId";
    public static final String OPT_HELP = "help";

    protected static Options createOptions() {
        Options options = new Options();
        options.addOption(new Option(OPT_VERBOSE, "Verbose command line output"));
        options.addOption(new Option(OPT_QUIET, "Silent command line output"));
        options.addOption(new Option(OPT_HELP, "Display command help."));
        OptionBuilder.withArgName((String)"resourceFile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Inject the provided mappingFileId as an Android resource into resourceFile.");
        options.addOption(OptionBuilder.create((String)OPT_INJECT_MAPPING_FILE_ID));
        OptionBuilder.withArgName((String)OPT_MAPPING_FILE_ID);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"ID to uniquely identifying the mapping file associated with this build.");
        options.addOption(OptionBuilder.create((String)OPT_MAPPING_FILE_ID));
        OptionBuilder.withArgName((String)"mappingFile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Upload mappingFile with the associated mappingFileId.");
        options.addOption(OptionBuilder.create((String)OPT_UPLOAD_MAPPING_FILE));
        OptionBuilder.withArgName((String)OPT_OBFUSCATOR_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optionally specify an obfuscator vendor identifier for use with obfuscationVersion");
        options.addOption(OptionBuilder.create((String)OPT_OBFUSCATOR_NAME));
        OptionBuilder.withArgName((String)"obfuscatorVersion");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optionally specify an obfuscator version for use with obfuscatorName");
        options.addOption(OptionBuilder.create((String)OPT_OBFUSCATOR_VERSION));
        OptionBuilder.withDescription((String)"Generate native symbol mappings to be later uploaded with uploadNativeSymbols");
        options.addOption(OptionBuilder.create((String)OPT_GENERATE_NATIVE_SYMBOLS));
        OptionBuilder.withDescription((String)"Upload native symbol files generated with generateNativeSymbols to Crashlytics.");
        options.addOption(OptionBuilder.create((String)OPT_UPLOAD_NATIVE_SYMBOLS));
        OptionBuilder.withArgName((String)"unstrippedNativeLib");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Unstripped native library file containing debug symbols");
        options.addOption(OptionBuilder.create((String)OPT_NATIVE_UNSTRIPPED_LIB));
        OptionBuilder.withArgName((String)"strippedNativeLib");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Stripped native library file corresponding with the library specified in unstrippedLibrary");
        options.addOption(OptionBuilder.create((String)OPT_NATIVE_STRIPPED_LIB));
        OptionBuilder.withArgName((String)"unstrippedNativeLibsDir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Directory path containing subdirs with unstripped native libraries.");
        options.addOption(OptionBuilder.create((String)OPT_NATIVE_UNSTRIPPED_LIBS_DIR));
        OptionBuilder.withArgName((String)"strippedNativeLibsDir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Directory path containing subdirs with stripped library corresponding with path specified in unstrippedLibrariesDir");
        options.addOption(OptionBuilder.create((String)OPT_NATIVE_STRIPPED_LIBS_DIR));
        OptionBuilder.withArgName((String)OPT_CSYM_CACHE_DIR);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Directory to store Crashlytics symbol files generated from unstripped NDK libraries.");
        options.addOption(OptionBuilder.create((String)OPT_CSYM_CACHE_DIR));
        OptionBuilder.withArgName((String)OPT_GOOGLE_APP_ID);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Google App Id, generally found in google-services.json");
        options.addOption(OptionBuilder.create((String)OPT_GOOGLE_APP_ID));
        OptionBuilder.withArgName((String)OPT_ANDROID_APPLICATION_ID);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Android application id as declared in the Android Manifest.");
        options.addOption(OptionBuilder.create((String)OPT_ANDROID_APPLICATION_ID));
        return options;
    }

    private CrashlyticsOptions() {
    }
}

