/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools;

import com.google.firebase.crashlytics.buildtools.AppBuildInfo;
import com.google.firebase.crashlytics.buildtools.CommandLineHelper;
import com.google.firebase.crashlytics.buildtools.Obfuscator;
import com.google.firebase.crashlytics.buildtools.android.project.XmlBuildIdReader;
import com.google.firebase.crashlytics.buildtools.android.project.XmlBuildIdWriter;
import com.google.firebase.crashlytics.buildtools.api.FirebaseMappingFileService;
import com.google.firebase.crashlytics.buildtools.api.RestfulWebApi;
import com.google.firebase.crashlytics.buildtools.api.SymbolFileService;
import com.google.firebase.crashlytics.buildtools.api.WebApi;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.DefaultProxyFactory;
import com.google.firebase.crashlytics.buildtools.log.ConsoleLogger;
import com.google.firebase.crashlytics.buildtools.log.CrashlyticsLogger;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.CodeMappingException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CsymSymbolFileService;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.NdkCSymGenerator;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class Buildtools {
    protected static final String BASE_API_URL_PROP = "crashlytics.webApiUrl";
    protected static final String CODEMAPPING_API_URL_PROP = "crashlytics.cmApiUrl";
    private static final String UNSTRIPPED_NATIVE_LIBS_DIR_ERR_MSG = "Either specify the correct unstrippedNativeLibsDir or disable Crashlytics symbol uploading.";
    private static Buildtools instance = null;
    private static CrashlyticsLogger logger = new ConsoleLogger(CrashlyticsLogger.Level.INFO);
    private static WebApi sharedWebApi;
    public static final String DUMMY_MAPPING_ID = "00000000000000000000000000000000";

    static WebApi getWebApi() {
        return sharedWebApi;
    }

    static void setWebApi(WebApi api) {
        if (!"https://api.crashlytics.com".equals(api.getBaseApiUrl())) {
            Buildtools.logW("Crashlytics API host: " + api.getBaseApiUrl(), null);
        }
        sharedWebApi = api;
    }

    public static WebApi createWebApi() {
        String baseApiUrl = System.getProperty(BASE_API_URL_PROP, "https://api.crashlytics.com");
        String codeMappingApiUrl = System.getProperty(CODEMAPPING_API_URL_PROP, "https://firebasecrashlyticssymbols.googleapis.com");
        return new RestfulWebApi(baseApiUrl, codeMappingApiUrl, new DefaultProxyFactory());
    }

    public static void setLogger(CrashlyticsLogger logger) {
        Buildtools.logger = logger;
    }

    public static CrashlyticsLogger getLogger() {
        return logger;
    }

    public static void logV(String msg) {
        logger.logV(msg);
    }

    public static void logD(String msg) {
        logger.logD(msg);
    }

    public static void logI(String msg) {
        logger.logI(msg);
    }

    public static void logW(String msg) {
        logger.logW(msg, null);
    }

    public static void logW(String msg, Throwable t) {
        logger.logW(msg, t);
    }

    public static void logE(String msg, Throwable t) {
        logger.logE(msg, t);
    }

    public static synchronized Buildtools getInstance() {
        if (instance == null) {
            WebApi api = Buildtools.createWebApi();
            instance = new Buildtools(api);
        }
        return instance;
    }

    public static void main(String[] args) {
        CommandLineHelper.main(args);
    }

    Buildtools(WebApi api) {
        Buildtools.logD("Crashlytics Buildtools initialized.");
        Buildtools.setWebApi(api);
        Package buildtoolsPkg = this.getClass().getPackage();
        this.setBuildtoolsClientInfo(buildtoolsPkg.getImplementationTitle(), buildtoolsPkg.getImplementationVersion());
    }

    public String generateMappingFileId() {
        return UUID.randomUUID().toString().replace("-", "").toLowerCase();
    }

    public boolean injectMappingFileIdIntoResource(File resourceFile, String mappingFileId) throws IOException {
        Buildtools.logD(String.format("Injecting mappingFileId into file [mappingFileId: %1$s; file:  %2$s]", mappingFileId, resourceFile));
        XmlBuildIdReader reader = XmlBuildIdReader.create(resourceFile);
        if (mappingFileId.equals(reader.getBuildId())) {
            Buildtools.logD("mappingFileId was NOT updated; correct value already present.");
            return false;
        }
        XmlBuildIdWriter writer = new XmlBuildIdWriter(resourceFile);
        writer.setBuildId(mappingFileId);
        return true;
    }

    public void uploadMappingFile(File mappingFile, String mappingFileId, AppBuildInfo appBuildInfo, Obfuscator obfuscator) throws IOException {
        Buildtools.logD(String.format("Uploading Mapping File [mappingFile: %1$s; mappingFileId: %2$s;packageName: %3$s; googleAppId: %4$s]", mappingFile.getAbsolutePath(), mappingFileId, appBuildInfo.getPackageName(), appBuildInfo.getGoogleAppId()));
        FirebaseMappingFileService mappingService = new FirebaseMappingFileService(Buildtools.getWebApi());
        mappingService.uploadMappingFile(mappingFile, mappingFileId, appBuildInfo, obfuscator);
        Buildtools.logI(String.format("Mapping file uploaded: %1$s", mappingFile.toString()));
    }

    public void generateNativeSymbolFiles(File path, File symbolFileOutputDir) throws IOException {
        this.generateNativeSymbolFiles(path, symbolFileOutputDir, new NdkCSymGenerator());
    }

    public void generateNativeSymbolFiles(File path, File symbolFileOutputDir, NativeSymbolGenerator symbolGenerator) throws IOException {
        Set<File> soFiles;
        Buildtools.logD("Generating native symbol files for " + path.getAbsolutePath() + "; writing output to: " + symbolFileOutputDir.getAbsolutePath());
        if (!path.exists()) {
            throw new IOException(String.format("Unstripped native library path does not exist: %s. %s", path.getAbsolutePath(), UNSTRIPPED_NATIVE_LIBS_DIR_ERR_MSG));
        }
        Collection<File> collection = soFiles = path.isDirectory() ? org.apache.commons.io.FileUtils.listFiles((File)path, (IOFileFilter)NativeSymbolGenerator.SO_FILE_FILTER, (IOFileFilter)TrueFileFilter.INSTANCE) : Collections.singleton(path);
        if (soFiles.isEmpty()) {
            throw new IOException(String.format("No native libraries found at %s. %s", path.getAbsolutePath(), UNSTRIPPED_NATIVE_LIBS_DIR_ERR_MSG));
        }
        Buildtools.logD("" + soFiles.size() + " native libraries found at " + path);
        FileUtils.verifyDirectory(symbolFileOutputDir);
        try {
            for (File soFile : soFiles) {
                File symbolFile = symbolGenerator.generateSymbols(soFile, symbolFileOutputDir);
                if (symbolFile == null) {
                    Buildtools.logW(String.format("Null symbol file generated for %s", soFile.getAbsolutePath()));
                    continue;
                }
                Buildtools.logD(String.format("Generated symbol file: %s (%,d bytes)", symbolFile.getAbsolutePath(), symbolFile.length()));
            }
        }
        catch (CodeMappingException ex) {
            throw new IOException(ex);
        }
    }

    public void uploadNativeSymbolFiles(File symbolFileDir, String googleAppId) throws IOException {
        this.uploadNativeSymbolFiles(symbolFileDir, googleAppId, new CsymSymbolFileService());
    }

    public void uploadNativeSymbolFiles(File symbolFileDir, String googleAppId, SymbolFileService symbolFileService) throws IOException {
        Buildtools.logD("Uploading native symbol files from directory: " + symbolFileDir.getAbsolutePath());
        if (!symbolFileDir.exists()) {
            throw new IOException("Crashlytics native symbol files directory does not exist: " + symbolFileDir.getAbsolutePath());
        }
        for (File symbolFile : symbolFileDir.listFiles()) {
            symbolFileService.uploadNativeSymbolFile(Buildtools.getWebApi(), symbolFile, googleAppId);
            Buildtools.logD("Crashlytics symbol file uploaded successfully; deleting local file: " + symbolFile.getAbsolutePath());
            symbolFile.delete();
        }
    }

    public void setBuildtoolsClientInfo(String clientName, String clientVersion) {
        Buildtools.getWebApi().setClientType(clientName);
        Buildtools.getWebApi().setClientVersion(clientVersion);
        Buildtools.getWebApi().setUserAgent(clientName + "/" + clientVersion);
    }
}

