/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle.tasks;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsPlugin;
import com.google.firebase.crashlytics.buildtools.gradle.ProjectVariantState;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingFieldException;
import java.io.File;
import java.lang.ref.SoftReference;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class GenerateSymbolFileTask
extends DefaultTask
implements GroovyObject {
    private final ProjectVariantState.Provider stateProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Inject
    public GenerateSymbolFileTask(ProjectVariantState.Provider variantStateProvider) {
        MetaClass metaClass;
        CallSite[] callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callGetProperty(CrashlyticsPlugin.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GenerateSymbolFileTask.class, (GroovyObject)this, (String)"group");
        String string = "Generate native symbol file used by Crashlytics to symbolicate native (NDK) stack traces";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, GenerateSymbolFileTask.class, (GroovyObject)this, (String)"description");
        ProjectVariantState.Provider provider = variantStateProvider;
        this.stateProvider = (ProjectVariantState.Provider)ScriptBytecodeAdapter.castToType((Object)provider, ProjectVariantState.Provider.class);
    }

    public static String getTaskName(String taskAffix) {
        CallSite[] callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{taskAffix}, new String[]{"generateCrashlyticsSymbolFile", ""}));
    }

    public File getSymbolFileOutputDir() {
        CallSite[] callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
        Object variant = callSiteArray[1].callGroovyObjectGetProperty((Object)this.stateProvider);
        String taskAffix = ShortTypeHandling.castToString((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(variant)));
        File workingDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(CrashlyticsPlugin.class, callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)taskAffix), File.class);
        File symbolDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callConstructor(File.class, (Object)workingDir, (Object)"nativeSymbols"), File.class);
        return symbolDir;
    }

    @TaskAction
    public Object generateSymbols() {
        CallSite[] callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            String unstrippedNativeLibsPath = ShortTypeHandling.castToString((Object)callSiteArray[7].callCurrent((GroovyObject)this));
            String strippedNativeLibsPath = ShortTypeHandling.castToString((Object)callSiteArray[8].callCurrent((GroovyObject)this));
            return callSiteArray[9].call(callSiteArray[10].call(Buildtools.class), callSiteArray[11].callConstructor(File.class, (Object)unstrippedNativeLibsPath), callSiteArray[12].callConstructor(File.class, (Object)strippedNativeLibsPath), callSiteArray[13].callCurrent((GroovyObject)this));
        }
        String unstrippedNativeLibsPath = this.resolveUnstrippedNativeLibsPath();
        String strippedNativeLibsPath = this.resolveStrippedNativeLibsPath();
        return callSiteArray[14].call(callSiteArray[15].call(Buildtools.class), callSiteArray[16].callConstructor(File.class, (Object)unstrippedNativeLibsPath), callSiteArray[17].callConstructor(File.class, (Object)strippedNativeLibsPath), (Object)this.getSymbolFileOutputDir());
    }

    private static String getNativeLibsFallbackPath(Object project) {
        CallSite[] callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
        public class _getNativeLibsFallbackPath_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getNativeLibsFallbackPath_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getNativeLibsFallbackPath_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getNativeLibsFallbackPath_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getNativeLibsFallbackPath_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNativeLibsFallbackPath_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "exists";
                return new CallSiteArray(_getNativeLibsFallbackPath_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getNativeLibsFallbackPath_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object jniPath = callSiteArray[18].call(callSiteArray[19].callGetProperty(callSiteArray[20].callGetProperty(callSiteArray[21].callGetProperty(callSiteArray[22].callGetProperty(callSiteArray[23].callGetProperty(project))))), (Object)new _getNativeLibsFallbackPath_closure1(GenerateSymbolFileTask.class, GenerateSymbolFileTask.class));
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)jniPath) ? callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(project, jniPath))) : callSiteArray[27].call(callSiteArray[28].call(project, callSiteArray[29].call(project)))));
    }

    private String resolveUnstrippedNativeLibsPath() {
        CallSite[] callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
        Object variant = callSiteArray[30].callGroovyObjectGetProperty((Object)this.stateProvider);
        Object project = callSiteArray[31].callGroovyObjectGetProperty((Object)this.stateProvider);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[32].callGetProperty(callSiteArray[33].callGroovyObjectGetProperty((Object)this.stateProvider)), null)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[34].call(callSiteArray[35].callConstructor(File.class, callSiteArray[36].call(project), callSiteArray[37].callGetProperty(callSiteArray[38].callGroovyObjectGetProperty((Object)this.stateProvider)))));
        }
        String nativeLibsFallbackPath = ShortTypeHandling.castToString((Object)callSiteArray[39].callStatic(GenerateSymbolFileTask.class, project));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call(variant, (Object)"externalNativeBuildProviders"))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].callGetProperty(variant))) {
                return ShortTypeHandling.castToString((Object)callSiteArray[42].call(callSiteArray[43].callGetProperty(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].callGetProperty(variant), (Object)0)))));
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].call(variant, (Object)"externalNativeBuildTasks")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].callGetProperty(variant))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[49].call(callSiteArray[50].callGetProperty(callSiteArray[51].call(callSiteArray[52].callGetProperty(variant), (Object)0))));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[53].callConstructor(File.class, callSiteArray[54].call(callSiteArray[55].callConstructor(File.class, (Object)nativeLibsFallbackPath, (Object)"obj"))));
    }

    private String resolveStrippedNativeLibsPath() {
        CallSite[] callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[56].callGetProperty(callSiteArray[57].callGroovyObjectGetProperty((Object)this.stateProvider)), null)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[58].call(callSiteArray[59].callConstructor(File.class, callSiteArray[60].call(callSiteArray[61].callGroovyObjectGetProperty((Object)this)), callSiteArray[62].callGetProperty(callSiteArray[63].callGroovyObjectGetProperty((Object)this.stateProvider)))));
        }
        Object variant = callSiteArray[64].callGroovyObjectGetProperty((Object)this.stateProvider);
        Object project = callSiteArray[65].callGroovyObjectGetProperty((Object)this.stateProvider);
        String nativeLibsFallbackPath = ShortTypeHandling.castToString((Object)callSiteArray[66].callStatic(GenerateSymbolFileTask.class, project));
        Object strippedNativeLibsPath = callSiteArray[67].callStatic(GenerateSymbolFileTask.class, project, variant);
        if (DefaultTypeTransformation.booleanUnbox((Object)strippedNativeLibsPath)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[68].call(callSiteArray[69].callConstructor(File.class, strippedNativeLibsPath)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[70].call(callSiteArray[71].callGetProperty(project), (Object)"externalNativeBuild"))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[72].callConstructor(File.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].call(project), File.class)), File.class), (Object)new GStringImpl(new Object[]{callSiteArray[74].callGetProperty(variant)}, new String[]{"intermediates/transforms/stripDebugSymbol/", ""})));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[75].call(callSiteArray[76].callConstructor(File.class, (Object)nativeLibsFallbackPath, (Object)"libs")));
    }

    private static String resolveStrippedNativeLibsPathHelper(Object project, Object variant) {
        CallSite[] callSiteArray;
        block14: {
            block13: {
                callSiteArray = GenerateSymbolFileTask.$getCallSiteArray();
                Class<?> internalArtifactType = Class.forName("com.android.build.gradle.internal.scope.InternalArtifactType$STRIPPED_NATIVE_LIBS");
                Object artifacts = callSiteArray[77].callGetProperty(callSiteArray[78].callGetProperty(callSiteArray[79].callGetProperty(variant)));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].call(callSiteArray[81].callGetProperty(artifacts), artifacts, (Object)"getFinalProduct", ScriptBytecodeAdapter.getField(GenerateSymbolFileTask.class, internalArtifactType, (String)"INSTANCE")))) break block13;
                Object path = callSiteArray[82].call(callSiteArray[83].call(artifacts, ScriptBytecodeAdapter.getField(GenerateSymbolFileTask.class, internalArtifactType, (String)"INSTANCE")));
                callSiteArray[84].call(callSiteArray[85].callGetProperty(project), (Object)new GStringImpl(new Object[]{path}, new String[]{"Crashlytics resolved stripped native library path ", ""}));
                String string = ShortTypeHandling.castToString((Object)path);
                try {
                    return string;
                }
                catch (LinkageError e) {
                    callSiteArray[86].call(callSiteArray[87].callGetProperty(project), (Object)"Crashlytics could not resolve stripped native library path using AGP 3.6 APIs");
                }
                catch (ClassNotFoundException e) {
                    callSiteArray[88].call(callSiteArray[89].callGetProperty(project), (Object)"Crashlytics could not resolve stripped native library path using AGP 3.6 APIs");
                }
                catch (MissingFieldException e) {
                    callSiteArray[90].call(callSiteArray[91].callGetProperty(project), (Object)"Crashlytics could not resolve stripped native library path using AGP 3.6 APIs");
                }
            }
            Class<?> internalArtifactType = Class.forName("com.android.build.gradle.internal.scope.InternalArtifactType");
            Object artifacts = callSiteArray[92].callGetProperty(callSiteArray[93].callGetProperty(callSiteArray[94].callGetProperty(variant)));
            if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[95].call(callSiteArray[96].callGetProperty(internalArtifactType), (Object)"STRIPPED_NATIVE_LIBS")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[97].call(callSiteArray[98].callGetProperty(artifacts), artifacts, (Object)"getFinalProduct", internalArtifactType)))) break block14;
            Object path = callSiteArray[99].call(callSiteArray[100].call(artifacts, callSiteArray[101].callGetProperty(internalArtifactType)));
            callSiteArray[102].call(callSiteArray[103].callGetProperty(project), (Object)new GStringImpl(new Object[]{path}, new String[]{"Crashlytics resolved stripped native library path ", ""}));
            String string = ShortTypeHandling.castToString((Object)path);
            try {
                return string;
            }
            catch (LinkageError e) {
                callSiteArray[104].call(callSiteArray[105].callGetProperty(project), (Object)"Crashlytics could not resolve stripped native library path using AGP 3.5 APIs");
            }
            catch (ClassNotFoundException e) {
                callSiteArray[106].call(callSiteArray[107].callGetProperty(project), (Object)"Crashlytics could not resolve stripped native library path using AGP 3.5 APIs");
            }
        }
        callSiteArray[108].call(callSiteArray[109].callGetProperty(project), (Object)"Crashlytics could not automatically resolve stripped native library path");
        return ShortTypeHandling.castToString(null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GenerateSymbolFileTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "CRASHLYTICS_TASK_GROUP";
        stringArray[1] = "providedVariant";
        stringArray[2] = "capitalize";
        stringArray[3] = "name";
        stringArray[4] = "getCrashlyticsBuildDir";
        stringArray[5] = "project";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "resolveUnstrippedNativeLibsPath";
        stringArray[8] = "resolveStrippedNativeLibsPath";
        stringArray[9] = "generateSymbolsFromDirectory";
        stringArray[10] = "getInstance";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "getSymbolFileOutputDir";
        stringArray[14] = "generateSymbolsFromDirectory";
        stringArray[15] = "getInstance";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "find";
        stringArray[19] = "srcDirs";
        stringArray[20] = "jni";
        stringArray[21] = "main";
        stringArray[22] = "sourceSets";
        stringArray[23] = "android";
        stringArray[24] = "getAbsolutePath";
        stringArray[25] = "getParentFile";
        stringArray[26] = "file";
        stringArray[27] = "getAbsolutePath";
        stringArray[28] = "file";
        stringArray[29] = "getProjectDir";
        stringArray[30] = "providedVariant";
        stringArray[31] = "providedProject";
        stringArray[32] = "unstrippedNativeLibsDir";
        stringArray[33] = "providedExtension";
        stringArray[34] = "getAbsolutePath";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "getProjectDir";
        stringArray[37] = "unstrippedNativeLibsDir";
        stringArray[38] = "providedExtension";
        stringArray[39] = "getNativeLibsFallbackPath";
        stringArray[40] = "hasProperty";
        stringArray[41] = "externalNativeBuildProviders";
        stringArray[42] = "getAbsolutePath";
        stringArray[43] = "objFolder";
        stringArray[44] = "get";
        stringArray[45] = "getAt";
        stringArray[46] = "externalNativeBuildProviders";
        stringArray[47] = "hasProperty";
        stringArray[48] = "externalNativeBuildTasks";
        stringArray[49] = "getAbsolutePath";
        stringArray[50] = "objFolder";
        stringArray[51] = "getAt";
        stringArray[52] = "externalNativeBuildTasks";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "getAbsolutePath";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "strippedNativeLibsDir";
        stringArray[57] = "providedExtension";
        stringArray[58] = "getAbsolutePath";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "getProjectDir";
        stringArray[61] = "project";
        stringArray[62] = "strippedNativeLibsDir";
        stringArray[63] = "providedExtension";
        stringArray[64] = "providedVariant";
        stringArray[65] = "providedProject";
        stringArray[66] = "getNativeLibsFallbackPath";
        stringArray[67] = "resolveStrippedNativeLibsPathHelper";
        stringArray[68] = "getAbsolutePath";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "hasProperty";
        stringArray[71] = "android";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "getBuildDir";
        stringArray[74] = "dirName";
        stringArray[75] = "getAbsolutePath";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "artifacts";
        stringArray[78] = "scope";
        stringArray[79] = "variantData";
        stringArray[80] = "respondsTo";
        stringArray[81] = "metaClass";
        stringArray[82] = "get";
        stringArray[83] = "getFinalProduct";
        stringArray[84] = "debug";
        stringArray[85] = "logger";
        stringArray[86] = "debug";
        stringArray[87] = "logger";
        stringArray[88] = "debug";
        stringArray[89] = "logger";
        stringArray[90] = "debug";
        stringArray[91] = "logger";
        stringArray[92] = "artifacts";
        stringArray[93] = "scope";
        stringArray[94] = "variantData";
        stringArray[95] = "getMetaProperty";
        stringArray[96] = "metaClass";
        stringArray[97] = "respondsTo";
        stringArray[98] = "metaClass";
        stringArray[99] = "get";
        stringArray[100] = "getFinalProduct";
        stringArray[101] = "STRIPPED_NATIVE_LIBS";
        stringArray[102] = "debug";
        stringArray[103] = "logger";
        stringArray[104] = "debug";
        stringArray[105] = "logger";
        stringArray[106] = "debug";
        stringArray[107] = "logger";
        stringArray[108] = "debug";
        stringArray[109] = "logger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[110];
        GenerateSymbolFileTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GenerateSymbolFileTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GenerateSymbolFileTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

