/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.buildids;

import com.google.firebase.crashlytics.buildtools.buildids.BuildIdInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlResourceUtils {
    private static final String LIB_ATTRIBUTE = "com.google.firebase.crashlytics.build_ids_lib";
    private static final String ARCH_ATTRIBUTE = "com.google.firebase.crashlytics.build_ids_arch";
    private static final String BUILD_ID_ATTRIBUTE = "com.google.firebase.crashlytics.build_ids_build_id";
    private static final String XML_NAME_ATTRIBUTE = "name";
    private static final String XML_ITEM_TAG = "item";
    private static final String XML_ARRAY_TAG = "string-array";
    static final String ARRAY_RESOURCE_FORMAT = "<string-array name=\"%s\" tools:ignore=\"UnusedResources,TypographyDashes\" translatable=\"false\">\n%s</string-array>\n";
    static final String ITEM_RESOURCE_FORMAT = "<item>%s</item>\n";

    public static List<BuildIdInfo> getBuildIds(Document doc) {
        ArrayList<BuildIdInfo> buildIdInfoList = new ArrayList<BuildIdInfo>();
        NodeList libs = XmlResourceUtils.getLibElement(doc).getElementsByTagName(XML_ITEM_TAG);
        NodeList archs = XmlResourceUtils.getArchElement(doc).getElementsByTagName(XML_ITEM_TAG);
        NodeList buildIds = XmlResourceUtils.getBuildIdsElement(doc).getElementsByTagName(XML_ITEM_TAG);
        for (int i2 = 0; i2 < buildIds.getLength(); ++i2) {
            String lib = libs.item(i2).getTextContent();
            String arch = archs.item(i2).getTextContent();
            String buildId = buildIds.item(i2).getTextContent();
            buildIdInfoList.add(new BuildIdInfo(lib, arch, buildId));
        }
        return buildIdInfoList;
    }

    private static Element getLibElement(Document doc) {
        return XmlResourceUtils.getResourceElement(doc, LIB_ATTRIBUTE);
    }

    private static Element getArchElement(Document doc) {
        return XmlResourceUtils.getResourceElement(doc, ARCH_ATTRIBUTE);
    }

    private static Element getBuildIdsElement(Document doc) {
        return XmlResourceUtils.getResourceElement(doc, BUILD_ID_ATTRIBUTE);
    }

    public static Element getResourceElement(Document doc, String elementName) {
        NodeList strings = doc.getElementsByTagName(XML_ARRAY_TAG);
        Element element = null;
        for (int i2 = 0; i2 < strings.getLength(); ++i2) {
            Element el = (Element)strings.item(i2);
            if (!el.hasAttribute(XML_NAME_ATTRIBUTE) || !el.getAttribute(XML_NAME_ATTRIBUTE).equals(elementName)) continue;
            element = el;
            break;
        }
        return element;
    }

    private static String formatLibItems(List<BuildIdInfo> buildIdInfoList) {
        StringBuilder items = new StringBuilder();
        for (BuildIdInfo buildIdInfo : buildIdInfoList) {
            items.append(String.format(ITEM_RESOURCE_FORMAT, buildIdInfo.getLibraryName()));
        }
        return items.toString();
    }

    private static String formatArchItems(List<BuildIdInfo> buildIdInfoList) {
        StringBuilder items = new StringBuilder();
        for (BuildIdInfo buildIdInfo : buildIdInfoList) {
            items.append(String.format(ITEM_RESOURCE_FORMAT, buildIdInfo.getArch()));
        }
        return items.toString();
    }

    private static String formatBuildIdItems(List<BuildIdInfo> buildIdInfoList) {
        StringBuilder items = new StringBuilder();
        for (BuildIdInfo buildIdInfo : buildIdInfoList) {
            items.append(String.format(ITEM_RESOURCE_FORMAT, buildIdInfo.getBuildId()));
        }
        return items.toString();
    }

    public static InputStream createResourceFileStream(List<BuildIdInfo> buildIdInfoList) {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources xmlns:tools=\"http://schemas.android.com/tools\">\n<!--\n  This file is automatically generated by Crashlytics to uniquely\n  identify the build ids for your Android application.\n\n  Do NOT modify or commit to source control!\n-->\n" + String.format(ARRAY_RESOURCE_FORMAT, LIB_ATTRIBUTE, XmlResourceUtils.formatLibItems(buildIdInfoList)) + String.format(ARRAY_RESOURCE_FORMAT, ARCH_ATTRIBUTE, XmlResourceUtils.formatArchItems(buildIdInfoList)) + String.format(ARRAY_RESOURCE_FORMAT, BUILD_ID_ATTRIBUTE, XmlResourceUtils.formatBuildIdItems(buildIdInfoList)) + "</resources>\n";
        return new ByteArrayInputStream(xml.getBytes());
    }
}

