/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import com.google.firebase.crashlytics.internal.common.CurrentTimeProvider;
import com.google.firebase.crashlytics.internal.settings.SettingsJsonTransform;
import com.google.firebase.crashlytics.internal.settings.model.AppSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.FeaturesSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.SessionSettingsData;
import com.google.firebase.crashlytics.internal.settings.model.SettingsData;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class SettingsV3JsonTransform
implements SettingsJsonTransform {
    private static final String CRASHLYTICS_APP_URL = "https://api.crashlytics.com/spi/v1/platforms/android/apps";
    private static final String CRASHLYTICS_APP_URL_FORMAT = "https://api.crashlytics.com/spi/v1/platforms/android/apps/%s";
    private static final String REPORTS_URL_FORMAT = "https://reports.crashlytics.com/spi/v1/platforms/android/apps/%s/reports";
    private static final String NDK_REPORTS_URL_FORMAT = "https://reports.crashlytics.com/sdk-api/v1/platforms/android/apps/%s/minidumps";

    SettingsV3JsonTransform() {
    }

    @Override
    public SettingsData buildFromJson(CurrentTimeProvider currentTimeProvider, JSONObject json) throws JSONException {
        int settingsVersion = json.optInt("settings_version", 0);
        int cacheDuration = json.optInt("cache_duration", 3600);
        AppSettingsData appData = SettingsV3JsonTransform.buildAppDataFrom(json.getJSONObject("fabric"), json.getJSONObject("app"));
        SessionSettingsData sessionData = SettingsV3JsonTransform.defaultSessionData();
        FeaturesSettingsData featureData = SettingsV3JsonTransform.buildFeaturesSessionDataFrom(json.getJSONObject("features"));
        long expiresAtMillis = SettingsV3JsonTransform.getExpiresAtFrom(currentTimeProvider, cacheDuration, json);
        return new SettingsData(expiresAtMillis, appData, sessionData, featureData, settingsVersion, cacheDuration);
    }

    @Override
    public JSONObject toJson(SettingsData settingsData) throws JSONException {
        return new JSONObject().put("expires_at", settingsData.expiresAtMillis).put("cache_duration", settingsData.cacheDuration).put("settings_version", settingsData.settingsVersion).put("features", (Object)this.toFeaturesJson(settingsData.featuresData)).put("app", (Object)this.toAppJson(settingsData.appData)).put("fabric", (Object)this.toFabricJson(settingsData.appData));
    }

    private static AppSettingsData buildAppDataFrom(JSONObject fabricJson, JSONObject appJson) throws JSONException {
        String status = appJson.getString("status");
        boolean isNewApp = "new".equals(status);
        String bundleId = fabricJson.getString("bundle_id");
        String organizationId = fabricJson.getString("org_id");
        String url = isNewApp ? CRASHLYTICS_APP_URL : String.format(Locale.US, CRASHLYTICS_APP_URL_FORMAT, bundleId);
        String reportsUrl = String.format(Locale.US, REPORTS_URL_FORMAT, bundleId);
        String ndkReportsUrl = String.format(Locale.US, NDK_REPORTS_URL_FORMAT, bundleId);
        boolean updateRequired = appJson.optBoolean("update_required", false);
        return new AppSettingsData(status, url, reportsUrl, ndkReportsUrl, bundleId, organizationId, updateRequired);
    }

    private static FeaturesSettingsData buildFeaturesSessionDataFrom(JSONObject json) {
        boolean collectReports = json.optBoolean("collect_reports", true);
        return new FeaturesSettingsData(collectReports);
    }

    private static SessionSettingsData defaultSessionData() {
        int maxCustomExceptionEvents = 8;
        int maxCompleteSessionsCount = 4;
        return new SessionSettingsData(8, 4);
    }

    private JSONObject toFabricJson(AppSettingsData appData) throws JSONException {
        JSONObject json = new JSONObject().put("bundle_id", (Object)appData.bundleId).put("org_id", (Object)appData.organizationId);
        return json;
    }

    private JSONObject toAppJson(AppSettingsData appData) throws JSONException {
        JSONObject json = new JSONObject().put("status", (Object)appData.status).put("update_required", appData.updateRequired);
        return json;
    }

    private JSONObject toFeaturesJson(FeaturesSettingsData features) throws JSONException {
        return new JSONObject().put("collect_reports", features.collectReports);
    }

    private static long getExpiresAtFrom(CurrentTimeProvider currentTimeProvider, long cacheDurationSeconds, JSONObject json) {
        long expiresAtMillis = 0L;
        if (json.has("expires_at")) {
            expiresAtMillis = json.optLong("expires_at");
        } else {
            long currentTimeMillis = currentTimeProvider.getCurrentTimeMillis();
            expiresAtMillis = currentTimeMillis + cacheDurationSeconds * 1000L;
        }
        return expiresAtMillis;
    }
}

